/*
 * Decompiled with CFR 0.152.
 */
package com.handmark.pulltorefresh.library.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.R;

@SuppressLint(value={"ViewConstructor"})
public class IndicatorLayout
extends FrameLayout
implements Animation.AnimationListener {
    static final int DEFAULT_ROTATION_ANIMATION_DURATION = 150;
    private Animation mInAnim;
    private Animation mOutAnim;
    private ImageView mArrowImageView;
    private final Animation mRotateAnimation;
    private final Animation mResetRotateAnimation;

    public IndicatorLayout(Context context, PullToRefreshBase.Mode mode) {
        super(context);
        int outAnimResId;
        int inAnimResId;
        this.mArrowImageView = new ImageView(context);
        Drawable arrowD = this.getResources().getDrawable(R.drawable.indicator_arrow);
        this.mArrowImageView.setImageDrawable(arrowD);
        int padding = this.getResources().getDimensionPixelSize(R.dimen.indicator_internal_padding);
        this.mArrowImageView.setPadding(padding, padding, padding, padding);
        this.addView((View)this.mArrowImageView);
        switch (mode) {
            case PULL_FROM_END: {
                inAnimResId = R.anim.slide_in_from_bottom;
                outAnimResId = R.anim.slide_out_to_bottom;
                this.setBackgroundResource(R.drawable.indicator_bg_bottom);
                this.mArrowImageView.setScaleType(ImageView.ScaleType.MATRIX);
                Matrix matrix = new Matrix();
                matrix.setRotate(180.0f, (float)arrowD.getIntrinsicWidth() / 2.0f, (float)arrowD.getIntrinsicHeight() / 2.0f);
                this.mArrowImageView.setImageMatrix(matrix);
                break;
            }
            default: {
                inAnimResId = R.anim.slide_in_from_top;
                outAnimResId = R.anim.slide_out_to_top;
                this.setBackgroundResource(R.drawable.indicator_bg_top);
            }
        }
        this.mInAnim = AnimationUtils.loadAnimation((Context)context, (int)inAnimResId);
        this.mInAnim.setAnimationListener((Animation.AnimationListener)this);
        this.mOutAnim = AnimationUtils.loadAnimation((Context)context, (int)outAnimResId);
        this.mOutAnim.setAnimationListener((Animation.AnimationListener)this);
        LinearInterpolator interpolator = new LinearInterpolator();
        this.mRotateAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateAnimation.setInterpolator((Interpolator)interpolator);
        this.mRotateAnimation.setDuration(150L);
        this.mRotateAnimation.setFillAfter(true);
        this.mResetRotateAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mResetRotateAnimation.setInterpolator((Interpolator)interpolator);
        this.mResetRotateAnimation.setDuration(150L);
        this.mResetRotateAnimation.setFillAfter(true);
    }

    public final boolean isVisible() {
        Animation currentAnim = this.getAnimation();
        if (null != currentAnim) {
            return this.mInAnim == currentAnim;
        }
        return this.getVisibility() == 0;
    }

    public void hide() {
        this.startAnimation(this.mOutAnim);
    }

    public void show() {
        this.mArrowImageView.clearAnimation();
        this.startAnimation(this.mInAnim);
    }

    public void onAnimationEnd(Animation animation) {
        if (animation == this.mOutAnim) {
            this.mArrowImageView.clearAnimation();
            this.setVisibility(8);
        } else if (animation == this.mInAnim) {
            this.setVisibility(0);
        }
        this.clearAnimation();
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onAnimationStart(Animation animation) {
        this.setVisibility(0);
    }

    public void releaseToRefresh() {
        this.mArrowImageView.startAnimation(this.mRotateAnimation);
    }

    public void pullToRefresh() {
        this.mArrowImageView.startAnimation(this.mResetRotateAnimation);
    }
}

