package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardRecordDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardRecordSDK;
import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.dayouzc.e2eplatform.core.dto.equip.ConnectionInfoDTO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * “/userecords”是卡使用记录相关资源根目录，主要包括：
 * 注：以下rest路径中id如果=mine，表示当前token中的实体/组织/个人等。
 *
 *
 * 1.查询类（商家/卖家角度）
 *
 * 1.1.根据卡发行机构（客户实体）查询
 * /sp/mine/userecords		        查询当前客户实体发行的卡的用卡记录
 * /sp/{boId}/userecords	        查询指定客户实体发行的卡的用卡记录
 * /sp/{boId}/userecords/manage	    查询指定客户实体发行的卡的用卡记录管理
 *                                  旅游卡游玩预约列表  TODO 待定
 *                                  查询赠送有效期记录  TODO 待定
 *
 * 1.2.根据卡类型查询
 * /cardtype/{typeId}/userecords	    查询指定卡类型的用卡记录（如未指定查询时间段，则默认查询当前年度的）     * 将子卡类型id作为查询条件，可查询子卡类型的用户记录
 * /cardtype/{typeId}/userecords/manage	查询指定卡类型的用卡记录管理（如未指定查询时间段，则默认查询当前年度的）     * 将子卡类型id作为查询条件，可查询子卡类型的用户记录
 *
 * 1.3.根据卡查询
 * /card/{cardNum}/userecords		        查询指定卡的用卡记录（商家/卖家角度）     * 查询指定卡的用卡记录（如未指定查询时间段，则默认查询当前年度的）
 * /card/{cardNum}/userecords/manage		查询指定卡的用卡记录管理（商家/卖家角度）     * 查询指定卡的用卡记录（如未指定查询时间段，则默认查询当前年度的）
 *
 * 1.4.根据商铺查询
 * /mc/mine/userecords			    查询当前客户实体所属商铺（景区）的用卡记录     * 查询当前客户实体所属商铺的用卡记录（如未指定查询时间段，则默认查询当前年度的）
 * /mc/{mcId}/userecords		    查询指定商铺（景区）的用卡记录     * 查询指定商铺的用卡记录（如未指定查询时间段，则默认查询当前年度的）
 * /mc/{mcId}/userecords/manage		查询指定商铺（景区）的用卡记录管理     * 查询指定商铺的用卡记录（如未指定查询时间段，则默认查询当前年度的）
 *
 * 1.5.根据卡适用机构（客户实体）查询
 * /bo/mine/userecords		     查询当前客户实体适用的卡的用卡记录
 * /bo/{boId}/userecords	     查询指定客户实体适用的卡的用卡记录
 * /bo/{boId}/userecords/manage	 查询指定客户实体适用的卡的用卡记录管理
 *
 * 1.6.根据组织查询
 * /			                         查询当前组织（网点）的用卡记录  TODO 接口服务报错
 * /organ/{organId}/userecords	         查询指定组织（网点）的用卡记录  TODO 接口服务报错
 * /organ/{organId}/userecords/manage	 查询指定组织（网点）的用卡记录管理  TODO 接口服务报错
 *
 * 1.7.获取详情
 * /{recordId}		            用卡记录基本信息页
 *
 * 2.操作类（商家/卖家角度）
 *
 * 2.1.使用（发卡商家角度）
 * /sp/reserve		    使用预约页面
 * /sp/use/makeup		使用登记补录页面
 *
 * 2.2.使用（用卡商家角度）
 * /bo/reserve		    使用预约页面
 * /bo/use/makeup		使用登记补录页面
 *
 * 2.3.使用（景区角度）
 * /mc/reserve		    使用预约页面
 * /mc/use/makeup		使用登记补录页面
 *
 */
@Controller
@RequestMapping("/userecords")
public class MCardRecordController {
    private static final Logger logger = LoggerFactory.getLogger(MCardRecordController.class);

    //========================================================================================查询类（商家/卖家角度）=========================================

    //-----------------------------------------根据卡发行机构（客户实体）查询
    /**
     * 查询当前客户实体发行的卡的用卡记录
     * @param model
     * @param request
     * @param recordType        记录类型
     * @return
     */
    @RequestMapping(value = "/sp/mine/userecords")
    public String queryMCardRecordOfMineSpCustomer(
            Map<String, Object> model,
            HttpServletRequest request,
            @RequestParam(value = "recordType", required = false) String recordType) {

        //1、校验

        //2、业务处理
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        model.put("boId", "mine");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_sp";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_sp";
        }
    }
    /**
     * 查询指定客户实体发行的卡的用卡记录
     *
     */
    @RequestMapping(value = "/sp/{boId}/userecords")
    public String queryMCardRecordOfSpCustomer(Map<String, Object> model,
                                            HttpSession session,
                                             HttpServletRequest request,
                                            @PathVariable("boId")String boId,
                                            @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("boId",boId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_sp";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_sp";
        }
    }

    /**
     * 查询指定客户实体发行的卡的用卡记录管理
     *
     */
    @RequestMapping(value = "/sp/{boId}/userecords/manage")
    public String queryMCardRecordManageOfSpCustomer(Map<String, Object> model,
                                            HttpSession session,
                                             HttpServletRequest request,
                                            @PathVariable("boId")String boId,
                                            @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("boId",boId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/manage_sp";
        }else{
            return "mcardmgr/pc/cardrecord/list/manage_sp";
        }
    }

    //----------------------------------------------------------根据卡类型查询-------------
    /**
     * 查询指定卡类型的用卡记录（如未指定查询时间段，则默认查询当前年度的）
     * 将子卡类型id作为查询条件，可查询子卡类型的用户记录
     */
    @RequestMapping(value = "/cardtype/{typeId}/userecords")
    public String queryMCardRecordOfCardType(Map<String, Object> model,
                                             HttpSession session,
                                             HttpServletRequest request,
                                             @PathVariable(value = "typeId") String typeId,
                                             @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("typeId",typeId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_cardType";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_cardType";
        }

    }
    /**
     * 查询指定卡类型的用卡记录管理（如未指定查询时间段，则默认查询当前年度的）
     * 将子卡类型id作为查询条件，可查询子卡类型的用户记录
     */
    @RequestMapping(value = "/cardtype/{typeId}/userecords/manage")
    public String queryMCardRecordManageOfCardType(Map<String, Object> model,
                                             HttpSession session,
                                             HttpServletRequest request,
                                             @PathVariable(value = "typeId") String typeId,
                                             @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("typeId",typeId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/manage_cardType";
        }else{
            return "mcardmgr/pc/cardrecord/list/manage_cardType";
        }

    }
    //-------------------------------------------------------根据卡查询
    /**
     * 查询指定卡的用卡记录（商家/卖家角度）
     * 查询指定卡的用卡记录（如未指定查询时间段，则默认查询当前年度的）
     *
     */
    @RequestMapping(value = "/card/{cardNum}/userecords")
    public String queryMCardRecordOfCard(Map<String, Object> model, HttpSession session,
                                         HttpServletRequest request,
                                         @PathVariable(value = "cardNum") String cardNum,
                                        @RequestParam(value = "token",required = false) String token) {
        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("cardNum",cardNum);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_card";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_card";
        }

    }
    /**
     * 查询指定卡的用卡记录管理（商家/卖家角度）
     * 查询指定卡的用卡记录（如未指定查询时间段，则默认查询当前年度的）
     *
     */
    @RequestMapping(value = "/card/{cardNum}/userecords/manage")
    public String queryMCardRecordManageOfCard(Map<String, Object> model, HttpSession session,
                                         HttpServletRequest request,
                                         @PathVariable(value = "cardNum") String cardNum,
                                        @RequestParam(value = "token",required = false) String token) {
        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("cardNum",cardNum);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/manage_card";
        }else{
            return "mcardmgr/pc/cardrecord/list/manage_card";
        }

    }
    //-------------------------------------------------------根据商铺查询
    /**
     * 查询当前客户实体所属商铺（景区）的用卡记录
     * 查询当前客户实体所属商铺的用卡记录（如未指定查询时间段，则默认查询当前年度的）
     * @param model
     * @param request
     * @param recordType        记录类型
     * @return
     */
    @RequestMapping(value = "/mc/mine/userecords")
    public String queryMCardRecordOfMineMc(
            Map<String, Object> model,
            HttpServletRequest request,
            @RequestParam(value = "recordType", required = false) String recordType) {

        //1、校验

        //2、业务处理
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        model.put("mcId", "mine");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_mc";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_mc";
        }
    }
    /**
     * 查询指定商铺（景区）的用卡记录
     * 查询指定商铺的用卡记录（如未指定查询时间段，则默认查询当前年度的）
     *
     */
    @RequestMapping(value = "/mc/{mcId}/userecords")
    public String queryMCardRecordOfMc(Map<String, Object> model, HttpSession session,
                                       HttpServletRequest request,
                                       @PathVariable(value = "mcId") String mcId,
                                       @RequestParam(value = "token",required = false) String token) {


        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("mcId",mcId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_mc";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_mc";
        }
    }

    /**
     * 查询指定商铺（景区）的用卡记录管理
     * 查询指定商铺的用卡记录（如未指定查询时间段，则默认查询当前年度的）
     *
     */
    @RequestMapping(value = "/mc/{mcId}/userecords/manage")
    public String queryMCardRecordManageOfMc(Map<String, Object> model, HttpSession session,
                                       HttpServletRequest request,
                                       @PathVariable(value = "mcId") String mcId,
                                       @RequestParam(value = "token",required = false) String token) {


        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("mcId",mcId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/manage_mc";
        }else{
            return "mcardmgr/pc/cardrecord/list/manage_mc";
        }
    }


    //-----------------------------------------根据卡适用机构（客户实体）查询
    /**
     * 查询当前客户实体适用的卡的用卡记录
     * @param model
     * @param request
     * @param recordType        记录类型
     * @return
     */
    @RequestMapping(value = "/bo/mine/userecords")
    public String queryMCardRecordOfMineBoCustomer(Map<String, Object> model,
                                                HttpServletRequest request,
                                                @RequestParam(value = "recordType", required = false) String recordType) {

        //1、校验

        //2、业务处理
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        model.put("boId", "mine");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_bo";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_bo";
        }
    }
    /**
     * 查询指定客户实体适用的卡的用卡记录
     *
     */
    @RequestMapping(value = "/bo/{boId}/userecords")
    public String queryMCardRecordOfBoCustomer(Map<String, Object> model,
                                             HttpSession session,
                                             HttpServletRequest request,
                                             @PathVariable("boId")String boId,
                                             @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("boId",boId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_bo";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_bo";
        }
    }


    /**
     * 查询指定客户实体适用的卡的用卡记录管理
     *
     */
    @RequestMapping(value = "/bo/{boId}/userecords/manage")
    public String queryMCardRecordManageOfBoCustomer(Map<String, Object> model,
                                             HttpSession session,
                                             HttpServletRequest request,
                                             @PathVariable("boId")String boId,
                                             @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("boId",boId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/manage_bo";
        }else{
            return "mcardmgr/pc/cardrecord/list/manage_bo";
        }
    }



    //---------------------------------------------------------------根据组织查询
    /**
     * 查询当前组织（网点）的用卡记录
     *
     */
    @RequestMapping(value = "")
    public String queryMCardRecord(Map<String, Object> model,HttpSession session,
                                   HttpServletRequest request,
                                   @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("organId","mine");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_organ";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_organ";
        }

    }

    /**查询指定组织（网点）的用卡记录
     *
     */
    @RequestMapping(value = "/organ/{organId}/userecords")
    public String queryMCardRecordOfOrgan(Map<String, Object> model, HttpSession session,
                                          HttpServletRequest request,
                                          @PathVariable("organId")String organId,
                                          @RequestParam(value = "token",required = false) String token) {
        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("organId",organId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/list_organ";
        }else{
            return "mcardmgr/pc/cardrecord/list/list_organ";
        }
    }

    /**查询指定组织（网点）的用卡记录管理
     *
     */
    @RequestMapping(value = "/organ/{organId}/userecords/manage")
    public String queryMCardRecordManageOfOrgan(Map<String, Object> model, HttpSession session,
                                          HttpServletRequest request,
                                          @PathVariable("organId")String organId,
                                          @RequestParam(value = "token",required = false) String token) {
        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");

        model.put("organId",organId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/list/manage_organ";
        }else{
            return "mcardmgr/pc/cardrecord/list/manage_organ";
        }
    }
    //------------------------------------------------------------获取详情
    /**
     * 用卡记录基本信息页
     *
     */
    @RequestMapping(value = "/{recordId}")
    public String getMCardRecord(Map<String, Object> model, HttpSession session,
                                 HttpServletRequest request,
                                 @PathVariable(value = "recordId") String recordId,
                                 @RequestParam(value = "token",required = false) String token) {

        if(!StringUtils.isEmpty(token)) {
            session.setAttribute("token", token);
        }
        token = (String) session.getAttribute("token");
        Pageable pageable = new PageRequest(0,10);

        ResponseData<McardRecordDTO> responseData = McardRecordSDK.getInstance().getMCardRecord(recordId,token);

        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg",msg);
            return "common/errorPage";
        } else if (!StringUtils.equals(responseData.getStatus(),"10000")) {
            String msg = responseData.getMsg();
            model.put("msg",msg);
            return "common/errorPage";
        } else {
            McardRecordDTO mcardRecord = responseData.getResult();
            model.put("mcardRecord",mcardRecord);

        }

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/info/detail";
        }else{
            return "mcardmgr/pc/cardrecord/info/detail";
        }
    }
    /**
     * 旅游卡游玩预约列表  TODO 待定
     */

    /**
     * 查询赠送有效期记录  TODO 待定
     */

    //=========================================================================操作类（发卡 商家/卖家角度）================================================

    /**
     * 发卡商家角度，使用预约页面
     */
    @RequestMapping(value = "/sp/reserve")
    public String reserveOfSp(Map<String, Object> model, HttpSession session,
                          HttpServletRequest request) {

        String token = (String) session.getAttribute("token");
        //TODO 查询景区列表
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(request);

        model.put("customerId",tokenInfo.getCustomerId());

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/action/reserve_sp";
        }else{
            return "mcardmgr/pc/cardrecord/action/reserve_sp";
        }
    }


    /**
     * 发卡商家角度，使用登记补录页面
     *
     */
    @RequestMapping(value = "/sp/use/makeup")
    public String makeupCardRecordOfSp(Map<String, Object> model, HttpSession session,
                                   HttpServletRequest request) {

        String token = (String) session.getAttribute("token");
        //查询(消费)商铺目录 TODO ？？？？
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(request);

        model.put("customerId",tokenInfo.getCustomerId());
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/action/useMakeup_sp";
        }else{
            return "mcardmgr/pc/cardrecord/action/useMakeup_sp";
        }
    }

    //=========================================================================操作类（用卡 商家/卖家角度）================================================

    /**
     * 用卡商家角度，使用预约页面
     */
    @RequestMapping(value = "/bo/reserve")
    public String reserveOfBo(Map<String, Object> model, HttpSession session,
                          HttpServletRequest request) {

        String token = (String) session.getAttribute("token");
        //TODO 查询景区列表
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(request);

        model.put("customerId",tokenInfo.getCustomerId());

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/action/reserve_bo";
        }else{
            return "mcardmgr/pc/cardrecord/action/reserve_bo";
        }
    }


    /**
     * 用卡商家角度，使用登记补录页面
     *
     */
    @RequestMapping(value = "/bo/use/makeup")
    public String makeupCardRecordOfBo(Map<String, Object> model, HttpSession session,
                                   HttpServletRequest request) {

        String token = (String) session.getAttribute("token");
        //查询(消费)商铺目录 TODO ？？？？
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(request);

        model.put("customerId",tokenInfo.getCustomerId());
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/action/useMakeup_bo";
        }else{
            return "mcardmgr/pc/cardrecord/action/useMakeup_bo";
        }
    }


    //=========================================================================操作类（景区角度）================================================

    /**
     * 景区角度，使用预约页面
     */
    @RequestMapping(value = "/mc/reserve")
    public String reserveOfMc(Map<String, Object> model, HttpSession session,
                          HttpServletRequest request) {

        String token = (String) session.getAttribute("token");
        //TODO 查询景区列表
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(request);

        model.put("customerId",tokenInfo.getCustomerId());

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/action/reserve_mc";
        }else{
            return "mcardmgr/pc/cardrecord/action/reserve_mc";
        }
    }


    /**
     * 景区角度，使用登记补录页面
     *
     */
    @RequestMapping(value = "/mc/use/makeup")
    public String makeupCardRecordOfMc(Map<String, Object> model, HttpSession session,
                                   HttpServletRequest request) {

        String token = (String) session.getAttribute("token");
        //查询(消费)商铺目录 TODO ？？？？
        ConnectionInfoDTO tokenInfo = E2EAppWebContext.getTokenInfo(request);

        model.put("customerId",tokenInfo.getCustomerId());
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/cardrecord/action/useMakeup_mc";
        }else{
            return "mcardmgr/pc/cardrecord/action/useMakeup_mc";
        }
    }

}
