package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * “/mcards”是卡相关资源根目录，其中，查询类的主要包括：
 * 注：以下rest路径中id如果=mine，表示当前token中的实体/组织/个人等。
 *
 * 1.根据运营商（客户实体运营管理关系）查询
 * /operator/mine/mcards		    我运营管理下的卡             * 查询卡，站在运营商的角度
 * /operator/{operatorBoId}/mcards	指定运营商运营管理下的卡     * 查询卡，站在运营商的角度
 *
 * 2.根据商户（客户实体业务关系）查询
 * /sp/mine/mcards			        我发行的卡                   * 查询卡，站在发行机构（商户）的角度
 * /sp/{supplierBoId}/mcards		指定客户实体发行的卡         * 查询卡，站在发行机构（商户）的角度
 * /sp/mine/mcards/manage	        我发行的卡的管理页面         * 管理卡，站在发行机构（商户）的角度，点击进入卡管理页面
 *
 * /ag/mine/mcards			        我代理的卡                   * 查询卡，站在卖家（分销商）的角度，库存/销售的卡
 * /ag/{agencyBoId}/mcards	        指定客户实体代理的卡         * 查询卡，站在卖家（分销商）的角度，库存/销售的卡
 * /ag/mine/mcards/manage			我代理的卡售后管理           * 查询卡，站在卖家（分销商）的角度，库存/销售的卡，点击进入卡管理页面
 *
 * /bo/mine/mcards/usable           我适用的卡                   * 查询卡，站在商户（景区等）的角度，适用的卡
 * /bo/{boId}/mcards/usable         指定客户实体适用的卡         * 查询卡，站在商户（景区等）的角度，适用的卡
 *
 * 3.根据网点（组织经营范围）进行查询
 * /			                    当前组织网点经营范围（库存/销售）的卡
 * /organ/{organId}/mcards	        指定组织网点经营范围（库存/销售）的卡
 * /organ/mine/mcards/manage        当前网点经营范围（库存/销售）的卡管理     * 点击进入卡管理页面
 *
 * 4.根据商铺merchant进行查询
 * /mc/{mcId}/mcards		        指定商铺发行的卡
 * /mc/{mcId}/mcards/usable	        指定商铺适用的卡
 *
 * 5.根据个人进行查询
 * /user/{accountId}/mcards	        指定个人绑定的卡（买家）。     * 查询指定用户所有购买的卡。
 *
 * /user/mine/mcards/sales		    我个人销售的卡（卖家）         * 查询我(当前用户/操作员)卖的卡  TODO 接口服务报错
 * /user/{accountId}/mcards/sales	指定个人销售的卡（卖家）       TODO 接口服务报错
 *
 * 6.根据卡类型查询        TODO 新增了2个页面
 * /cardtype/{typeId}/mcards           指定卡类型的卡查询页面
 * /cardtype/{typeId}/mcards/manage    指定卡类型的卡管理页面
 *
 * 7.获取详情（商家/卖家角度）
 * /{cardNum}		                卡基本信息页面
 * /{cardNum}/manage		        卡管理页面                     * 显示卡基本信息，工具栏显示售后管理功能：绑定、修改、解绑、赠送有效期、续费、升级、冻结/解冻、预约、使用补录。。。
 * /{cardNum}/detail		        卡详细信息页面，包括：制卡记录、销售/发货记录、用卡记录等
 *
 *
 * 注：卡管理功能
 * （1）销售激活通过B2C、B2B、赠送等方式进行激活
 * （2）售后管理功能
 * 售后管理功能			发行机构	销售机构		说明/操作条件
 *  绑定					Y			Y			status=1待绑定
 *  修改绑定信息			Y			Y			status=2正常
 *  解绑					Y			Y			status=2，且没有使用过
 *  赠送有效期				Y		   XXX			status=1或2或4
 *  续费					Y			Y			status=1或2或4
 *  升级					Y			Y			有可升级的卡
 *  冻结/解冻				Y			Y
 *  预约					Y			Y			status=2
 *  使用补录				Y		   XXX			status=2
 *
 */
@Controller
@RequestMapping("/mcards")
public class MCardInfoQueryController {
    private static final Logger logger = LoggerFactory.getLogger(MCardInfoQueryController.class);

    //=============================================================================根据运营商（客户实体运营管理关系）查询===============================================================

    /**
     * 我运营管理下的卡
     * 查询卡，站在运营商的角度
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/operator/mine/mcards")
    public String queryMCardInfoOfMineAsOperator(Map<String, Object> model, HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "我运营管理下的卡");
        model.put("url", "/operator/mine/mcards");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_op_mine";
        }
    }

    /**
     * 指定运营商运营管理下的卡
     * 查询卡，站在运营商的角度
     * @param model
     * @param operatorBoId          运营商ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/operator/{operatorBoId}/mcards")
    public String queryMCardInfoOfOperator(
            Map<String, Object> model,
            @PathVariable("operatorBoId")String operatorBoId,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "指定运营商运营管理下的卡");
        model.put("url", "/operator/" + operatorBoId + "/mcards");
        model.put("operatorBoId", operatorBoId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_op";
        }
    }

    //===================================================================================根据商户（客户实体业务关系）查询===================================================================

    /**
     * 我发行的卡
     * 查询卡，站在发行机构（商户）的角度
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/sp/mine/mcards")
    public String queryMCardInfoOfMineAsSupplier(Map<String, Object> model, HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "我发行的卡");
        model.put("url", "/sp/mine/mcards");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_sp_mine";
        }
    }

    /**
     * 指定客户实体发行的卡
     * 查询卡，站在发行机构（商户）的角度
     * @param model
     * @param supplierBoId          发卡商户ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/sp/{supplierBoId}/mcards")
    public String queryMCardInfoOfSupplier(
            Map<String, Object> model,
            @PathVariable("supplierBoId")String supplierBoId,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "指定客户实体发行的卡");
        model.put("url", "/sp/" + supplierBoId + "/mcards");
        model.put("supplierBoId", supplierBoId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_sp";
        }
    }

    /**
     * 我发行的卡的管理页面
     * 管理卡，站在发行机构（商户）的角度 操作列：修改、。。。
     */
    @RequestMapping(value = "/sp/mine/mcards/manage")
    public String manageOfMineCard( Map<String, Object> model, HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址；3、跳往下级的地址；4、角色
        model.put("title", "我发行的卡的管理页面");
        model.put("url", "/sp/mine/mcards");
        model.put("next", "manage");
        model.put("role", "1");     //role角色：1 发行机构；2 销售机构（代理机构也算作销售机构）

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/manage_sp_mine";
        }
    }

    /**
     * 我代理的卡
     * 查询卡，站在卖家（分销商）的角度
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/ag/mine/mcards")
    public String queryMCardInfoOfMineAsAgency(Map<String, Object> model, HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "我代理的卡");
        model.put("url", "/ag/mine/mcards");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_ag_mine";
        }
    }

    /**
     * 指定客户实体代理的卡
     * 查询卡，站在卖家（分销商）的角度
     * @param model
     * @param agencyBoId            分销商实体ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/ag/{agencyBoId}/mcards")
    public String queryMCardInfoOfAgency(
            Map<String, Object> model,
            @PathVariable("agencyBoId")String agencyBoId,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "指定客户实体代理的卡");
        model.put("url", "/ag/" + agencyBoId + "/mcards");
        model.put("agencyBoId", agencyBoId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_ag";
        }
    }

    /**
     * 我代理的卡售后管理
     * 查询卡，站在卖家（分销商）的角度
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/ag/mine/mcards/manage")
    public String manageOfMineAsAgency(
            Map<String, Object> model,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址；3、跳往的下级页面地址；4、角色；
        model.put("title", "我代理的卡售后管理");
        model.put("url", "/ag/mine/mcards");
        model.put("next", "manage");
        model.put("role", "2");     //role角色：1 发行机构；2 销售机构（代理机构也算作销售机构）

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/manage_ag_mine";
        }
    }

    /**
     * 我适用的卡
     * 查询卡，站在商户（景区等）的角度，适用的卡
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/bo/mine/mcards/usable")
    public String queryMCardInfoOfMineBoUsable(Map<String, Object> model, HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "我适用的卡");
        model.put("url", "/bo/mine/mcards/usable");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_bo_usable_mine";
        }
    }

    /**
     * 指定客户实体适用的卡
     * 查询卡，站在商户（景区等）的角度，适用的卡
     * @param model
     * @param boId                商户ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/bo/{boId}/mcards/usable")
    public String queryMCardInfoOfBoUsable(
            Map<String, Object> model,
            @PathVariable("boId")String boId,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "指定客户实体适用的卡");
        model.put("url", "/bo/" + boId + "/mcards/usable");
        model.put("boId", boId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_bo_usable";
        }
    }

    //====================================================================================根据网点（组织经营范围）进行查询===================================================================
    /**
     * 当前组织经营范围（库存/销售）内的卡	获取卡列表(有分页)
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "")
    public String queryMCardInfo(Map<String, Object> model, HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "当前组织经营范围（库存/销售）内的卡");
        model.put("url", "/organ/mine/mcards");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_organ_mine";
        }
    }

    /**
     * 根据网点（组织经营范围）进行查询
     * 指定组织经营范围（库存/销售）内的卡
     * @param model
     * @param organId               组织ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/organ/{organId}/mcards")
    public String queryMCardInfoOfOrgan(
            Map<String, Object> model,
            @PathVariable("organId")String organId,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "根据网点（组织经营范围）进行查询");
        model.put("url", "/organ/" + organId + "/mcards");
        model.put("organId", organId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_organ";
        }
    }

    /**
     * 当前网点经营范围（库存/销售）的卡管理
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/organ/mine/mcards/manage")
    public String manageMCardInfoOfOrgan(Map<String, Object> model, HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址；3、跳往下级的地址
        model.put("title", "当前网点经营范围（库存/销售）的卡管理");
        model.put("url", "/organ/mine/mcards");
        //TODO 跳往下级的地址

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/manage_organ_mine";
        }
    }

    //==========================================================================================根据商铺merchant进行查询============================================================================

    /**
     * 指定商铺发行的卡
     * @param model
     * @param mcId              商铺ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/mc/{mcId}/mcards")
    public String queryMCardInfoOfMc(
            Map<String, Object> model,
            @PathVariable(value = "mcId") String mcId,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "指定商铺发行的卡");
        model.put("url", "/mc/" + mcId + "/mcards");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_mc";
        }
    }

    /**
     * 指定商铺适用的卡
     * @param model
     * @param mcId              商铺ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/mc/{mcId}/mcards/usable")
    public String queryMCardInfoOfMcUsable(
            Map<String, Object> model,
            @PathVariable("mcId")String mcId,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "指定商铺适用的卡");
        model.put("url", "/mc/" + mcId + "/mcards/usable");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_mc_usable";
        }
    }

    //=========================================================================================根据个人进行查询================================================================

    /**
     * 指定个人绑定的卡（买家）。查询指定用户所有购买的卡。
     * @param model
     * @param accountId         用户ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/user/{accountId}/mcards")
    public String getMCardInfoListOfUser(
            Map<String, Object> model,
            @PathVariable("accountId")String accountId,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "指定个人绑定的卡（买家）。查询指定用户所有购买的卡");
        model.put("url", "/user/" + accountId + "/mcards");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_user";
        }
    }

    /**
     * 我个人销售的卡（卖家）
     * 查询我(当前用户/操作员)卖的卡
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/user/mine/mcards/sales")
    public String queryMCardInfoOfMineSales(Map<String, Object> model, HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "我个人销售的卡（卖家）");
        model.put("url", "/user/mine/mcard/sales");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_user_mine_sale";
        }
    }

    /**
     * 指定个人销售的卡
     * @param model
     * @param accountId         用户ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/user/{accountId}/mcards/sales")
    public String queryMCardInfoOfUserSales(
            Map<String, Object> model,
            @PathVariable("accountId")String accountId,
            HttpServletRequest request) {

        //1、校验

        //2、业务处理
        //准备页面的参数：1、title；2、接口地址
        model.put("title", "指定个人销售的卡");
        model.put("url", "/user/" + accountId + "/mcards/sales");
        model.put("accountId", accountId);

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_user_sale";
        }
    }


    /**
     * 指定卡类型的卡查询页面
     * @param model
     * @param typeId         用户ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/cardtype/{typeId}/mcards")
    public String queryMCardsOfCardtype(
            Map<String, Object> model,
            @PathVariable("typeId")String typeId,
            HttpServletRequest request) {

        //1、校验
        //2、业务处理
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/list_card_type";
        }
    }

    /**
     * 指定卡类型的卡管理页面
     * @param model
     * @param typeId         用户ID
     * @param request
     * @return
     */
    @RequestMapping(value = "/cardtype/{typeId}/mcards/manage")
    public String queryMCardsOfCardtypeManage(
            Map<String, Object> model,
            @PathVariable("typeId")String typeId,
            HttpServletRequest request) {

        //1、校验
        //2、业务处理
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");

        //3、响应
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/list/list";
        }else{
            return "mcardmgr/pc/mcardinfo/list/manage_card_type";
        }
    }

    //==============================================================================获取详情（商家/卖家角度）======================================================

    /**
     * 卡基本信息页面
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/{cardNum}")
    public String getMCardInfo(Map<String, Object> model, HttpSession session,
                                @PathVariable("cardNum")String cardNum,
                               HttpServletRequest request) {

        model.put("cardNum", cardNum);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/info/info";
        }else{
            return "mcardmgr/pc/mcardinfo/info/info";
        }
    }
    /**
     * 卡管理页面
     * 显示卡基本信息 工具栏：修改、。。。
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/{cardNum}/manage")
    public String manageMCardInfo(Map<String, Object> model, HttpSession session,
                                  HttpServletRequest request,
                                @PathVariable("cardNum")String cardNum) {
        model.put("cardNum", cardNum);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/info/manage";
        }else{
            return "mcardmgr/pc/mcardinfo/info/manage";
        }
    }

    /**
     * 卡详细信息页面，包括：制卡记录、销售/发货记录、用卡记录等
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/{cardNum}/detail")
    public String getMCardInfoDetails(Map<String, Object> model, HttpSession session,
                               @PathVariable("cardNum")String cardNum,
                                      HttpServletRequest request) {

        model.put("cardNum", cardNum);
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/info/detail";
        }else {
            return "mcardmgr/pc/mcardinfo/info/detail";
        }
    }

}
