package com.dayouzc.e2eapp.mcard.mcardmgr.web.controller;

import com.dayouzc.e2eapp.mcard.dto.McardInfoDTO;
import com.dayouzc.e2eapp.mcard.dto.McardOrderDetailDTO;
import com.dayouzc.e2eapp.mcard.sdk.McardInfoSDK;
import com.dayouzc.e2eplatform.core.context.E2EAppWebContext;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Map;

/**
 * Created by Mr.Liu on 2017/8/8.
 *
 * “/mcards”是卡相关资源根目录，其中，操作类的主要包括：
 *
 * 售后（商家/卖家角度）
 * /bind			卡绑定页面               * 帮助消费者进行会员卡绑定
 * /modify			修改卡绑定信             * 修改会员卡绑定的用户信息
 * /unbind          卡解绑页面               TODO 新增的
 * /giftValidTime	赠送有效期
 *
 * /renewal         续费   TODO 界面未设计，代码未实现
 * /upgrade         升级   TODO 界面未设计，代码未实现
 *
 * /freeze			冻结/解冻会员卡页面
 * /change			补换卡（挂失/损坏）页面
 *
 * /giftCard		批量赠送        TODO 这个应该是在销售里
 *
 */
@Controller
@RequestMapping("/mcards")
public class MCardInfoActionController {
    private static final Logger logger = LoggerFactory.getLogger(MCardInfoActionController.class);

    //============================================================================= 售后（商家/卖家角度）=========================================================

    /**
     * 会员卡绑定页面
     * 帮助消费者进行会员卡绑定
     *
     */
    @RequestMapping(value = "/bind")
    public String bindCard(
            HttpServletRequest request,
            Map<String, Object> model,
            HttpSession session,
            @RequestParam("cardNum")String cardNum){

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/action/bind";
        }else{
            return "mcardmgr/pc/mcardinfo/action/bind";
        }
    }
    @RequestMapping(value = "/bind/submit")
    public String bindCardSubmit(
            Map<String, Object> model,
            HttpSession session,
            McardInfoDTO mcardInfoDTO){

        String token = (String) session.getAttribute("token");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().bindCard(mcardInfoDTO,token);
        McardInfoDTO mcardInfo = responseData.getResult();
        model.put("responseData", mcardInfo);
        return "redirect:/mcards/sp/mine/mcards";
    }

    /**
     * 修改卡绑定信息
     * 修改会员卡绑定的用户信息
     *
     */
    @RequestMapping(value = "/modify")
    public String modifyBindInfo(
        HttpServletRequest request,
        Map<String, Object> model,
        HttpSession session,
        @RequestParam("cardNum")String cardNum){

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/action/modify_bind";
        }else{
            return "mcardmgr/pc/mcardinfo/action/modify_bind";
        }

    }
    @RequestMapping(value = "/modify/submit")
    public String modifyBindInfoSubmit(
            Map<String, Object> model,
            HttpSession session,
            McardInfoDTO mcardInfoDTO){

        String token = (String) session.getAttribute("token");
        //TODO 暂定
        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().modifyBindInfo(mcardInfoDTO, token);

        return "redirect:/mcards/sp/mine/mcards";
    }

    /**
     * 卡解绑页面
     *
     */
    @RequestMapping(value = "/unbind")
    public String unbind(
            HttpServletRequest request,
            Map<String, Object> model,
            HttpSession session,
            @RequestParam("cardNum")String cardNum,
            @RequestParam("cardId")String cardId){
        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/action/unbind";
        }else{
            return "mcardmgr/pc/mcardinfo/action/unbind";
        }
    }

    /**
     * 赠送有效期
     *
     */
    @RequestMapping(value = "/giftValidTime")
    public String giftValidTime(Map<String, Object> model, HttpSession session,
                                HttpServletRequest request,
                                @RequestParam("cardNum")String cardNum){

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/action/gift_valid_time";
        }else{
            return "mcardmgr/pc/mcardinfo/action/gift_valid_time";
        }

    }
    @RequestMapping(value = "/giftValidTime/submit")
    public String giftValidTimeSubmit(Map<String, Object> model, HttpSession session,
                                      McardInfoDTO mcardInfoDTO){
        String token = (String) session.getAttribute("token");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().giftValidTime(mcardInfoDTO,token);

        return "redirect:/mcards/sp/mine/mcards/manage";
    }


    /**
     * 会员卡续费页面
     *
     */
    @RequestMapping(value = "/renewal")
    public String renewalCard(Map<String, Object> model, HttpSession session,
                             HttpServletRequest request,
                             @RequestParam("cardNum")String cardNum){

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/action/renewal";
        }else{
            return "mcardmgr/pc/mcardinfo/action/renewal";
        }
    }
    /**
     * 会员卡升级页面
     *
     */
    @RequestMapping(value = "/upgrade")
    public String upgradeCard(Map<String, Object> model, HttpSession session,
                              HttpServletRequest request,
                              @RequestParam("cardNum")String cardNum){

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/action/upgrade";
        }else{
            return "mcardmgr/pc/mcardinfo/action/upgrade";
        }
    }

    /**
     * 冻结/解冻会员卡页面
     *
     */
    @RequestMapping(value = "/freeze")
    public String freezeCard(Map<String, Object> model, HttpSession session,
                             HttpServletRequest request,
                             @RequestParam("cardNum")String cardNum){

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/action/freeze";
        }else{
            return "mcardmgr/pc/mcardinfo/action/freeze";
        }
    }
    @RequestMapping(value = "/freeze/submit")
    public String freezeCardSubmit(Map<String, Object> model, HttpSession session,
                                   McardInfoDTO mcardInfoDTO){
        String token = (String) session.getAttribute("token");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().frozenCard(mcardInfoDTO,token);
        McardInfoDTO mcardInfo = responseData.getResult();

        return "redirect:/mcards/"+mcardInfo.getCardNum();
    }

    /**
     * 补换卡（挂失/损坏）页面
     *
     */
    @RequestMapping(value = "/change")
    public String changeCard(Map<String, Object> model, HttpSession session,
                             HttpServletRequest request) {

        String token = (String) session.getAttribute("token");


        //jsp改为ajax获取卡信息展示；把change_view.jsp的内容融入change.jsp

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/action/change";
        }else{
            return "mcardmgr/pc/mcardinfo/action/change";
        }
    }

    @RequestMapping(value = "/change/submit")
    public String changeCardSubmit(Map<String, Object> model, HttpSession session,
                                    McardInfoDTO mcardInfo) {

        String token = (String) session.getAttribute("token");

        ResponseData<McardInfoDTO> responseData = McardInfoSDK.getInstance().changeCard(mcardInfo,token);

        if (responseData == null) {
            String msg = "[responseData] is null";
            model.put("msg",msg);
            return "common/errorPage";
        } else if (!StringUtils.equals(responseData.getStatus(),"10000")) {
            String msg = responseData.getMsg();
            model.put("msg",msg);
            return "common/errorPage";
        } else {
            McardInfoDTO mcardInfoDto = responseData.getResult();
            return "redirect:";//TODO 待定
        }

    }


    //===================================================== wws 2019年7月10日17:07:59 添加批量赠送功能
    /**
     * 批量赠送
     *
     * @param model
     * @param session
     * @return
     */
    @RequestMapping(value = "/giftCard")
    public String giftCard(Map<String, Object> model, HttpSession session,
                           HttpServletRequest request) {
        String token = (String) session.getAttribute("token");

        String screenOrientation = E2EAppWebContext.getContextParamValue(request, "screenOrientation");
        //判断是横屏还是竖屏
        if(StringUtils.equals(screenOrientation, "1")) {
            return "mcardmgr/app/mcardinfo/action/gift_card";
        }else{
            return "mcardmgr/pc/mcardinfo/action/gift_card";
        }
    }

    @RequestMapping(value = "/giftCard/submit")
    public String giftCardSubmit(Map<String, Object> model,
                                 @RequestParam("typeId")String typeId,
                                 @RequestParam("buyNumber")String buyNumber,
                                 @RequestParam("accepts")String accepts,
                                 HttpSession session) {
        String token = (String) session.getAttribute("token");
        McardOrderDetailDTO appData = new McardOrderDetailDTO();
        appData.setTypeId(typeId);
        appData.setBuyNumber(buyNumber);
        appData.setMemo(accepts);

        ResponseData responseData = McardInfoSDK.getInstance().giftCard(appData, token);
        model.put("result", responseData.getMsg());
        return "redirect:/mcards/giftCard";
    }



}
