package com.dayouzc.e2eapp.mcard.mcardmgr.web;

import com.dayouzc.e2eplatform.core.aop.ContextAccountInterceptor;
import com.dayouzc.e2eplatform.core.aop.ContextOrganInterceptor;
import com.dayouzc.e2eplatform.core.aop.TokenInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * Created by tyutNo4 on 2017/4/11.
 */
@Configuration
public class McardMgrConfigurer extends WebMvcConfigurerAdapter {

    public void addInterceptors(InterceptorRegistry registry) {
        //对当前context有无token的拦截
        registry.addInterceptor(new TokenInterceptor())
                .addPathPatterns("/**")   // 正式环境使用
//                .addPathPatterns("/xxx")   // 测试时使用
                /* 排斥规则 */
                // 系统自带ajax转发功能，默认不需要令牌，故排斥，请勿删除
                .excludePathPatterns("/ajax/**")
                .excludePathPatterns("/error")
                ;
        //对当前context有无用户的拦截
        registry.addInterceptor(new ContextAccountInterceptor())
                /* 有效规则 */
                .addPathPatterns("/**")   // 正式环境使用
//                .addPathPatterns("/xxx")   // 测试时使用
                /* 排斥规则 */
                .excludePathPatterns("/error")
        ;
        //对当前context有无组织的拦截
        registry.addInterceptor(new ContextOrganInterceptor())
                /* 有效规则 */
                .addPathPatterns("/**")   // 正式环境使用
//                .addPathPatterns("/xxx")   // 测试时使用
                /* 排斥规则 */
                .excludePathPatterns("/error")
        ;

        super.addInterceptors(registry);

    }


}
