/*是否需要预约 下拉选择*/
function isBookType(selValue) {
    var option = {
        domId: "#isNeedBook",
        selectName: "请选择",
        keyName: "value",
        valueName: "id",
        selectedValue: selValue?selValue:''
    };
    option.callback = function (selectObj) {
    };
    dyPlugins.selectModel.init(option, bookType);
}

/*预约提前时间单位 下拉选择*/
function selectBookAhead(selValue) {
    var option = {
        domId: "#bookAheadUnit",
        selectName: "请选择",
        keyName: "value",
        valueName: "id",
        selectedValue: selValue?selValue:''
    };
    option.callback = function (selectObj) {
    };
    dyPlugins.selectModel.init(option, bookAheadUnit);
}

/*预约是否算使用次数 下拉选择*/
function selectBookEffect(selValue) {
    var option = {
        domId: "#bookEffective",
        selectName: "请选择",
        keyName: "value",
        valueName: "id",
        selectedValue: selValue?selValue:''
    };
    option.callback = function (selectObj) {
    };
    dyPlugins.selectModel.init(option, bookEffectType);
}

/*获取ajax需要的参数*/
function getSvrParamsSting() {
    var paramsStr = '?';
    var paramsJson = [];
    if (token) {
        paramsJson.push('token=' + token);
    }
    paramsStr += paramsJson.join('&');
    return paramsStr;
}

/*获取创建年卡适用商铺页面提交所需数据*/
function getFormData() {
    var formData={
        "appData": {
            "mcName": $("#mcName").val(),//商铺名称
            "cmName": $("#cmName").val(),//商品名称
            "limitedNumTotal": $("#limitedNumTotal").val(),//可消费总次数
            "limitedNumMonth": $("#limitedNumMonth").val(),//每月可消费次数
            "limitedNumDay": $("#limitedNumDay").val(),//每天可消费次数
            "book": $("#isNeedBook select").val(),//是否需要预约
            "bookAhead": $("#bookAhead").val(),//预约提前时间
            "bookAheadUnit": $("#bookAheadUnit select").val(),//预约提前时间单位
            "bookDuration": $("#bookDuration").val(),//可预约几天内
            "bookEffective": $("#bookEffective select").val(),//预约是否算使用次数
            "memo": $("#memo").val(),//备注
            "mcId":$("#mcId").val(),//商铺Id
            "cmId":$("#cmId").val()//商品Id
        }
    };
    //新建页面传typeId，修改页面传cmfreeId
    if($("#createCardTypeCmFree").length>0){
        formData.appData.typeId=typeId
    }else if($("#modifyCardTypeCmFree").length>0){
        formData.appData.cmfreeId=cmfreeId
    }
    return formData;
}


/*点击提交按钮  提交年卡适用商铺数据*/
function submitDataInfo() {
    //防止多次提交
    var clickFlag = $("#submitData").data("click");
    if (!clickFlag) {
        return false;
    }
    //提交之前验证
    $("#submitData").data("click", false); //设置不可点击提交按钮
    //提交验证 errTime 返回 0的时候 说明验证都通过 >0 说明 有errTime处有信息问题
    var errTime = dyPlugins.Validate.checkAll();
    // console.log(errTime + "错误次数");
    if (errTime > 0) {
        $("#submitData").data("click", true); //设置可以点击
    }else {
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数
        //新建、修改页面数据提交
        var formData = JSON.stringify(getFormData());

        var options = {
            url: ctx + '/ajax/post?restPath=' + encodeURIComponent(postUrl + svrParamsString),//请求url
            type: "POST",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data: formData
        };
        options.callback = function (type, data) {
            $("#submitData").data("click", true); //设置可以点击

            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if (type == 1) {
                //创建卡类型页面
                $("#submitData").addClass("u-btn-disabled");
                $("#submitData").off("click");

                if(showType){
                    var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
                    parent.layer.close(index);
                }else {
                    //年卡适用商铺创建成功，跳转页面
                    window.location.href = ctx + "/mcardtypes/" + encodeURI(typeId) + "/cmfrees";
                }

            } else {
                layer.msg(data);
            }
        };
        dyCom.ajaxRequest(options);
    }
}


/*修改年卡适用商铺页面业务处理*/
/*获取年卡适用商铺详细信息*/
function getDataInfo() {
    var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
    var paramsJson = {
        restPath: encodeURI(getUrl + svrParamsString)
    };
    var options = {
        url: ctx + '/ajax/get',  //请求url
        type: "get",         //请求类型 默认get
        async: true,            //异步|同步加载 默认异步
        dataType: "json",      //数据类型      默认json
        data: paramsJson
    };
    options.callback = function (type, data) {
        //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
        //返回结果处理
        if (type == 1 && data.result) {
            setDataInfo(data.result);
        }else{
            layer.msg(data);
        }
    };
    dyCom.ajaxRequest(options);
}

/*渲染修改年卡适用商铺页面元素*/
function setDataInfo(list) {
    if (list) {
        cmfreeId=list.cmfreeId;
        typeId=list.typeId;
        //商铺名称
        $("#mcId").val(dyCom.stringFiltedNull(list.mcId));
        $("#mcName").val(dyCom.stringFiltedNull(list.mcName));
        $("#show_mcName").html(dyCom.stringFiltedNull(list.mcName));
        //商品名称
        $("#cmId").val(dyCom.stringFiltedNull(list.cmId));
        $("#cmName").val(dyCom.stringFiltedNull(list.cmName));
        $("#show_cmName").html(dyCom.stringFiltedNull(list.cmName));
        //可消费总次数
        $("#limitedNumTotal").val(dyCom.stringFiltedNull(list.limitedNumTotal));
        //每月可消费次数
        $("#limitedNumMonth").val(dyCom.stringFiltedNull(list.limitedNumMonth));
        //每天可消费次数
        $("#limitedNumDay").val(dyCom.stringFiltedNull(list.limitedNumDay));

        //初始化是否需要预约下拉筛选
        isBookType(list.book);

        //预约提前时间
        $("#bookAhead").val(dyCom.stringFiltedNull(list.bookAhead));
        //初始化预约提前时间单位下拉筛选
        selectBookAhead(list.bookAheadUnit);

        //可预约几天内
        $("#bookDuration").val(dyCom.stringFiltedNull(list.bookDuration));
        //初始化预约是否算使用次数下拉筛选
        selectBookEffect(list.bookEffective);

        //备注
        $("#memo").val(dyCom.stringFiltedNull(list.memo));
    }
}