/*是否带校验位（最后1位） 下拉选择*/
function cardNumCheck() {
    var option = {
        domId: "#cardNumCheck",
        selectName: "请选择",
        keyName: "value",
        valueName: "id",
        selectedValue: "0"
    };
    option.callback = function (selectObj) {
    };
    dyPlugins.selectModel.init(option, isCardNumCheck);
}

/*是否支持虚拟卡 下拉选择*/
function virtualCard() {
    var option = {
        domId: "#isVirtualCard",
        selectName: "请选择",
        keyName: "value",
        valueName: "id",
        selectedValue: "0"
    };
    option.callback = function (selectObj) {
    };
    dyPlugins.selectModel.init(option, isVirtualCard);
}

/*获取ajax需要的参数*/
function getSvrParamsSting() {
    var paramsStr = '?';
    var paramsJson = [];
    if (token) {
        paramsJson.push('token=' + token);
    }
    paramsStr += paramsJson.join('&');
    return paramsStr;
}

/*获取创建子卡类型页面提交所需数据*/
function getFormData() {
    var formData={
        "appData": {
            "typeId": $("#typeId").val(),//所属卡类型Id
            "typeName": $("#typeName").val(),//所属卡类型

            "childtypeName": $("#childtypeName").val(),//子卡类型名称
            "childcardDesc": $("#childcardDesc").val(),//简介
            "cardNumPrefix": $("#cardNumPrefix").val(),//卡号前缀
            "cardNumLen": $("#cardNumLen").val(),//卡号长度
            "cardPrice": ($("#cardPrice").val()) * 100,//卡面值
            "cardNumCheck": $("#cardNumCheck select").val(),//是否带校验位
            "isVirtualCard": $("#isVirtualCard select").val(),//是否支持虚拟卡,
            "memo": $("#childCardDemo").val(),//备注
        },
        "docList": docList
    };
    //新建页面传typeId，修改页面传childtypeId
    if($("#createChildCardType").length>0){
        formData.appData.typeId=typeId
    }else if($("#modifyChildCardType").length>0){
        formData.appData.childtypeId=childtypeId
    }
    return formData;
}


/*点击提交按钮  提交子卡类型数据*/
function submitDataInfo() {
    //防止多次提交
    var clickFlag = $("#submitData").data("click");
    if (!clickFlag) {
        return false;
    }
    //提交之前验证
    $("#submitData").data("click", false); //设置不可点击提交按钮
    //提交验证 errTime 返回 0的时候 说明验证都通过 >0 说明 有errTime处有信息问题
    var errTime = dyPlugins.Validate.checkAll();
    // console.log(errTime + "错误次数");
    if (errTime > 0) {
        $("#submitData").data("click", true); //设置可以点击
    }else {

        var formData = JSON.stringify(getFormData());
        var options = {
            url: ctx + '/ajax/post?restPath=' + encodeURIComponent(postUrl+'?token=' + token) + '&token=' + token,//请求url
            type: "POST",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data: formData
        };
        options.callback = function (type, data) {
            $("#submitData").data("click", true); //设置可以点击

            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if (type == 1) {
                //创建卡类型页面
                $("#submitData").addClass("u-btn-disabled");

                if(showType){
                    var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
                    parent.layer.close(index);
                }else {
                    if ($("#createChildCardType").length > 0) {
                        layer.msg('子卡类型创建成功！');
                        //子卡创建成功，跳转到卡类型详情页面
                        window.location.href = ctx + "/mcardtypes/" + encodeURI(typeId) + "/childtypes";
                    } else if ($("#modifyChildCardType").length > 0) {
                        layer.msg('子卡类型修改成功！');
                        // 子卡修改成功，跳转到子卡详情页面
                        window.location.href = ctx + '/mcardtypes/childtypes/' + encodeURI(childtypeId);
                    }
                }

            } else {
                layer.msg(data);
            }
        };
        dyCom.ajaxRequest(options);
    }
}


/*修改子卡类型页面业务处理*/
/*获取子卡类型详细信息*/
function getDataInfo(getUrl) {
    var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
    var paramsJson = {
        restPath: encodeURI(getUrl + svrParamsString)
    };
    var options = {
        url: ctx + '/ajax/get',  //请求url
        type: "get",         //请求类型 默认get
        async: true,            //异步|同步加载 默认异步
        dataType: "json",      //数据类型      默认json
        data: paramsJson
    };
    options.callback = function (type, data) {
        //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
        //返回结果处理
        if (type == 1 && data.result) {
            setDataInfo(data.result);
        }else{
            layer.msg(data);
        }
    };
    dyCom.ajaxRequest(options);
}

/*渲染修改子卡类型页面元素*/
function setDataInfo(list) {
    if (list) {
        typeId=list.typeId;
        if (dyCom.stringFiltedNull(list.childtypeId)) {
            //TODO 如何获取多张图片

            var htmlStr = '<div class="swiper-slide f-pr" id="mainimg">' +
                '<img src="'+dyCom.getImgPath(list.childtypeId, 'IMG', token)+'">' +
                '<span class="iconfont iconguanbi closeIcon" data-id="mainimg"></span>' +
                '</div>';
            /*在添加图片按钮前追加*/
            $('#uploadImgBtn').before(htmlStr);
        }
        //子卡名称
        $("#childtypeName").val(dyCom.stringFiltedNull(list.childtypeName));
        //所属卡类型
        $("#typeId").val(dyCom.stringFiltedNull(list.typeId));
        $("#typeName").val(dyCom.stringFiltedNull(list.typeName));
        $("#show_typeName").html(dyCom.stringFiltedNull(list.typeName));
        //子卡说明
        $("#childcardDesc").val(dyCom.stringFiltedNull(list.childcardDesc));
        //卡号前缀
        $("#cardNumPrefix").val(dyCom.stringFiltedNull(list.cardNumPrefix));
        //卡号长度
        $("#cardNumLen").val(dyCom.stringFiltedNull(list.cardNumLen));
        //卡面值
        if(dyCom.stringFiltedNull(list.cardPrice)){
            var cardPrice = (Math.round(list.cardPrice)/100).toFixed(2);
            $('#cardPrice').val(cardPrice);
        }
        //是否带校验位（最后1位）
        $("#cardNumCheck select").val(dyCom.stringFiltedNull(list.cardNumCheck));
        $("#cardNumCheck input").val(CardNumCheckStatus(dyCom.stringFiltedNull(list.cardNumCheck)));
        //是否支持虚拟卡
        $("#isVirtualCard select").val(dyCom.stringFiltedNull(list.isVirtualCard));
        $("#isVirtualCard input").val(VirtualCardStatus(dyCom.stringFiltedNull(list.isVirtualCard)));
        //备注
        $("#childCardDemo").val(dyCom.stringFiltedNull(list.memo));

        //添加删除图片的事件
        $('#picUrl .iconguanbi').off('click').on('click', function () {
            $('#' + $(this).data('id')).remove();

            //TODO 如何传递 删除的图片
        });
    }
}
