/*私有常量*/
//分页
var pageSize = 10; //每页多少条
var pageIndex = 0; //当前页
// 查询条件
var cardTypeName='';
var selectVal='';
//选择状态
function selectStatus() {
    var option = {
        domId: "#selectStatus",
        selectName: "状态",
        keyName: "value",
        valueName: "id",
        selectedValue: "1"
    };
    option.callback = function (selectObj) {

    };
    dyPlugins.selectModel.init(option, cardTypeStatus);
}

/*获取ajax需要的参数*/
function getSvrParamsSting(pageIndex){
    var paramsStr = '?';
    var paramsJson = [
        'page='+pageIndex,
        'size='+pageSize
    ];

    cardTypeName=$("#cardTypeName").val();
    if(cardTypeName){
        paramsJson.push('typeName='+cardTypeName);
    }

    selectVal=$("#selectStatus select").val();
    if(selectVal){
        paramsJson.push('typeStatus='+selectVal);
    }
    if(token){
        paramsJson.push('token='+token);
    }
    paramsStr += paramsJson.join('&');
    return paramsStr;
}

/*获取列表数据*/
function getDataList(pageIndex) {
    var svrParamsString = getSvrParamsSting(pageIndex); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
    var paramsJson = {
        restPath:encodeURI(getUrl+svrParamsString)
    };
    var options = {
        url: ctx+'/ajax/get',  //请求url
        type: "get",         //请求类型 默认get
        async: true,            //异步|同步加载 默认异步
        dataType: "json",      //数据类型      默认json
        data:paramsJson
    };
    options.callback = function(type,data){
        //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
        //返回结果处理
        if(type==1){
            var show_style = $('.header-option').find('.i_active').data('style');

            //1 数据渲染
            if(show_style && show_style == 'list'){
                cardTypeList(data,pageIndex);//表格版
            }else if(show_style && show_style == 'tile'){
                cardTypeTile(data,pageIndex);//图片列表版
            }else {
                cardTypeList(data,pageIndex);//表格版
            }

        }
    };
    dyCom.ajaxRequest(options);
}

/*渲染表格元素*/
function cardTypeList(data,pageIndex){
    $("#cardTypeList").empty();

    if(data.result){
       var list = data.result;
        if(list) {
            $.each(list, function (i, obj) {
                /*克隆table 模板*/
                var trClone = $('#templateTable tr').clone();
                /*赋值*/
                trClone.find('.label1').html(pageIndex*pageSize+Number(i+1));
                var img = '<img width="80" src="'+dyCom.getImgPath(obj.typeId, 'MAINIMG', token)+'">';
                trClone.find('.label2').html(img);
                trClone.find('.clickQuery').data('typid', obj.typeId);
                trClone.find('.label3').html((obj.typeName ? obj.typeName : ''));
                trClone.find('.label4').html((Math.round(dyCom.stringFiltedNull(obj.cardPrice))/100).toFixed(2));
                trClone.find('.label5').html(dyCom.stringFiltedNull(obj.cardDesc));
                trClone.find('.label6').html(dyCom.stringFiltedNull(obj.organId));
                trClone.find('.label7').html(getStatus(obj.typeStatus));

                /*追加HTML*/
                $("#cardTypeList").append(trClone);
            });
        }

    }
    /*加载分页*/
    dyPlugins.Page.init("pagesList",data.totalPage,data.currPage,pageSize,data.totalRows,function(pageData){
        pageIndex = pageData.curr;
        getDataList(pageIndex);
    });

    /*会员卡类型信息管理*/
    $('#cardTypeList .clickQuery').off('click').on('click',function(){
        var typeId = $(this).data('typid');

        var jumpUrl = '';
        if(jumpType && jumpType == 'base'){
            jumpUrl += '/mcardtypes/'+encodeURI(typeId);
        }else if(jumpType && jumpType == 'detail'){
            jumpUrl += '/mcardtypes/'+encodeURI(typeId)+'/details';
        }else if(jumpType && jumpType == 'manage'){
            jumpUrl += '/mcardtypes/'+encodeURI(typeId)+'/manage';
        }else{
            jumpUrl += '/mcardtypes/'+encodeURI(typeId);
        }

        window.location.href = ctx + jumpUrl;
    })
}

/*渲染列表元素*/
function cardTypeTile(data,pageIndex){
    $("#cardTypeTile").empty();

    if(data.result){
        var list = data.result;
        if(list) {
            var listText = '';
            $.each(list, function (i, obj) {
                listText += '<li class="f-cb" data-id="' + dyCom.stringFiltedNull(obj.typeId) + '"><a href="javascript:">' +
                    '<img class="f-db f-fl" height="100%" src="' + dyCom.getImgPath(obj.typeId, 'MAINIMG', token) + '" alt="">' +
                    '<div class="f-fl imgInfo">' +
                    '<h6 class="cardTitle">' + dyCom.stringFiltedNull(obj.typeName) + '</h6>' +
                    '<p class="cardInfo">' + dyCom.stringFiltedNull(obj.cardDesc) + '</p>' +
                    '<div class="f-cb">' +
                    '<p class="f-fl">￥' + (Math.round(dyCom.stringFiltedNull(obj.cardPrice)) / 100).toFixed(2) + '</p>' +
                    '<p class="f-fr">[ ' + getStatus(dyCom.stringFiltedNull(obj.typeStatus)) + ']</p>' +
                    '</div>' +
                    '</div>' +
                    '</a></li>';
            });
            $("#cardTypeTile").empty().append(listText);
        }

    }
    /*加载分页*/
    dyPlugins.Page.init("pagesList",data.totalPage,data.currPage,pageSize,data.totalRows,function(pageData){
        pageIndex = pageData.curr;
        getDataList(pageIndex);
    });

    /*会员卡类型信息管理*/
    $('#cardTypeTile li').off('click').on('click',function(){
        var typeId = $(this).data('id');

        var jumpUrl = '';
        if(jumpType && jumpType == 'base'){
            jumpUrl += '/mcardtypes/'+encodeURI(typeId);
        }else if(jumpType && jumpType == 'detail'){
            jumpUrl += '/mcardtypes/'+encodeURI(typeId)+'/details';
        }else if(jumpType && jumpType == 'manage'){
            jumpUrl += '/mcardtypes/'+encodeURI(typeId)+'/manage';
        }else{
            jumpUrl += '/mcardtypes/'+encodeURI(typeId);
        }

        window.location.href = ctx + jumpUrl;
    })
}

/*点击查询按钮-显示查询列表*/
$("#searchList").on("click",function(){
    cardTypeName=$("#cardTypeName").val();
    selectVal=$("#selectStatus select").val();
    getDataList(pageIndex);
});
