/*私有常量*/
// 查询条件
var cardTypeName = '';
var selectVal = '';

//选择状态初始化
function selectStatus() {
    var showBankDom = $('#selectStatus');
    var inputDom = showBankDom.find('input');
    inputDom.val(cardTypeStatus[0].value);
    inputDom.data('id', cardTypeStatus[0].id);
    inputDom.data('value', cardTypeStatus[0].value);
    showBankDom.off('click').on('click', function () {
        var selectId = inputDom.data('id');
        var bankSelect = new IosSelect(1,
            [cardTypeStatus],
            {
                container: '.container',
                title: '状态',
                itemHeight: 0.7,
                headerHeight: 0.88,
                itemShowCount: 3,
                cssUnit: 'rem',
                oneLevelId: selectId,
                callback: function (selectOneObj) {
                    inputDom.data('id', selectOneObj.id);
                    inputDom.data('value', selectOneObj.value);
                    inputDom.val(selectOneObj.value);
                }
            });
    });
}

/*获取ajax需要的参数*/
function getSvrParamsSting() {
    var paramsStr = '?';
    var paramsJson = [
        'page=$page' ,
        'size=$pageSize'
    ];
    if (cardTypeName) {
        paramsJson.push('mcName=' + cardTypeName);
    }
    if (selectVal) {
        paramsJson.push('typeStatus=' + selectVal);
    }
    if (token) {
        paramsJson.push('token=' + token);
    }
    paramsStr += paramsJson.join('&');
    return paramsStr;
}

/*获取列表数据*/
function getDataList(getUrl) {
    var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
    var paramsJson = {
        restPath: encodeURI(getUrl + svrParamsString)
    };
    var ajaxUrl = ctx+'/ajax/get';
    var options = {
        contentDomId: "#cardDataList", //填充内容的节点ID 如：“#myrelease_container”
        pagesDomId: "#dy-pages",    //分页节点ID  "#dy-pages"
        scrollDom: window,               //window对象  为了滑动使用 目前使用的是body滚动
        currPage: 0,                          //当前页 默认为0 从0开始计算页码
        pageSize: 30,                       //每页多少条
        itemHeight: 155,                  //每条的高度  为了计算滑动的当前页使用 需要计算目前所在的页
        static_image: static_images,  //图片地址   ${static_images}  如：webapp/static_new/images
        ajaxParems: {                         //ajax请求的参数 对jquery的ajax 二次封装
            url: ajaxUrl,                        //请求地址  需要全地址
            type: "GET",                       //请求方式
            async: true,                        //异步|同步  默认true异步
            dataType: "JSON",             //数据格式
            data: paramsJson                              //ajax请求传参
        },
        callback: function (type, data) {   //回调  ajax请求返回的数据  data
            //接收到数据 判断 type是否等于1如果等于1做业务处理  比如调用渲染页面方法
            if(type==1&& data.result){
            setDataList(data.result);
            }else{
                layer.msg(data);
            }
        }
    };

    dyPlugins.ajaxPages.Init(options);
}

/*渲染app列表元素*/
function setDataList(list) {
    if (list && list.length) {
        var listText = '';
        $.each(list, function (i, obj) {
            listText += '<li class="f-cb" data-id="'+dyCom.stringFiltedNull(obj.typeId)+'">' +
                '<img class="f-db f-fl" height="100%" src="' + dyCom.getImgPath(obj.typeId, 'MAINIMG', token) + '" alt="">' +
                '<div class="f-fl imgInfo">' +
                '<h6 class="cardTitle">' + dyCom.stringFiltedNull(obj.mcName) + '</h6>' +
                '<p class="cardInfo">' + dyCom.stringFiltedNull(obj.cardDesc) + '</p>' +
                '<div class="f-cb">' +
                '<p class="f-fl">￥' +(Math.round(dyCom.stringFiltedNull(obj.cardPrice))/100).toFixed(2) + '</p>' +
                '<p class="f-fr">[ ' + getStatus(dyCom.stringFiltedNull(obj.typeStatus)) + ' ]</p>' +
                '</div>' +
                '</div>' +
                '</li>';
        });
        $("#cardDataList").append(listText);
        //设置可以加载 分页组件
        dyPlugins.ajaxPages.setAjaxFlag(true);
    }
}

/*点击查询按钮-显示查询列表*/
$("#searchList").on("click", function () {
    cardTypeName = $("#cardTypeName").val();
    selectVal = $("#selectStatus input").data('id');
    getDataList(getUrl);
});


