/*卡类型信息页面*/
/*获取卡类型ajax需要的参数*/
function getMcardTypeParamsSting(){
    var paramsStr = '?';
    var paramsJson = [];
    if(token){
        paramsJson.push('token='+token);
    }
    paramsStr += paramsJson.join('&');
    return paramsStr;
}

/*获取会员卡类型信息*/
function getDataInfo(getUrl) {
    //获取接口参数
    var typeParams = getMcardTypeParamsSting();
    var typeParamsJson = {
        restPath:encodeURI(getUrl+typeParams)
    };
    var optionsAjax = {
        url: ctx+'/ajax/get',  //请求url
        type: "get",         //请求类型 默认get
        async: true,            //异步|同步加载 默认异步
        dataType: "json",      //数据类型      默认json
        data:typeParamsJson
    };
    optionsAjax.callback = function(type,data){
        //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
        //返回结果处理
        if(type==1){
            // 渲染卡类型信息页面
            if($("#cardDataInfo").length>0){
                setCardTypeData(data.result);
            }
            //子卡类型的基本信息页面
            if($("#childCardBaseInfo").length>0){
                setChildCardInfoData(data.result);
            }
            //优惠商铺商品设置基本信息页面
            if($("#yearnDiscountData").length>0){
                setDiscountData(data.result);
            }
            //年卡适用商铺商品设置基本信息页面
            if($("#yearnSuitData").length>0){
                setYearnSuitData(data.result);
            }
        }else{
            layer.msg(data);
        }
    };
    dyCom.ajaxRequest(optionsAjax);
}

/*渲染卡类型信息*/
function setCardTypeData(list) {
    if(list){
        //遍历会员卡对象下的属性
        for (var key in list) {
            var tempKey = dyCom.stringFiltedNull(list[key]);
            $('#'+key).html(tempKey);
        }
        //处理特殊字段
        //主图
        if(dyCom.stringFiltedNull(list.typeId)){
            $("#primaryImg").append('<img src="'+dyCom.getImgPath(list.typeId, 'MAINIMG', token) +'" alt="会员卡主图">')
        }
        //卡状态
        var typeStatus = '';
        if(dyCom.stringFiltedNull(list.typeStatus)){
            typeStatus = getStatus(list.typeStatus);
        }
        $('#showTypeStatus').html(typeStatus);
        //发行机构
        $("#cardOrganName").text(dyCom.stringFiltedNull(list.organName));
        //卡价格
        var cardPrice = 0;
        if(dyCom.stringFiltedNull(list.cardPrice)){
            cardPrice = (Math.round(list.cardPrice)/100).toFixed(2)+'元';
            $('#showCardPrice').html(cardPrice);
        }
        //续费时间
        var advanceBuyDay = '';
        if(dyCom.stringFiltedNull(list.advanceBuyDay)){
            advanceBuyDay = '有效期到期前【'+list.advanceBuyDay+'】天可续费';
            $('#showAdvanceBuyDay').html(advanceBuyDay);
        }
        //绑定数量
        if(dyCom.stringFiltedNull(list.haveNumber)==0){
            $("#cardCount").text("不限制");//每人最多可绑定
        }else{
            $("#cardCount").text(dyCom.stringFiltedNull(list.haveNumber)+'张')
        }
        //有效期方式
        var validWay = '';
        if(dyCom.stringFiltedNull(list.validWay)){
            if(list.validWay != '0'){
                validWay = validWayStatus(list.validWay);
            }else {
                validWay = validWayStatus(list.validWay) + '，' +
                '销售之日起'+list.autoActivateDay+'天后如未绑定，则自动激活';
            }
            $('#showValidWay').html(validWay);
        }
        //有效期
        var validDate = '';
        if(dyCom.stringFiltedNull(list.validDate)){
            validDate = dyCom.stringFiltedNull(list.validDate) + getValidDate(dyCom.stringFiltedNull(list.validUnit));
            $('#showValidDate').html(validDate);
        }
    }

}

/*渲染子卡类型的基本信息*/
function setChildCardInfoData(list) {
    if(list){
        //主图
        if(dyCom.stringFiltedNull(list.childtypeId)){
            $("#primaryImg").append('<img src="'+dyCom.getImgPath(list.childtypeId, 'MAINIMG', token) +'" alt="子卡主图">')
        }
        //子卡名称
        $("#childtypeName").text(dyCom.stringFiltedNull(list.childtypeName));
        //卡状态
        var typeStatus = '';
        if(dyCom.stringFiltedNull(list.status)){
            typeStatus = getChildStatus(list.status);
        }
        $('#showTypeStatus').html(typeStatus);
        //所属卡类型
        $("#typeName").text(dyCom.stringFiltedNull(list.typeName));
        //子卡说明
        $("#childcardDesc").text(dyCom.stringFiltedNull(list.childcardDesc));
        //卡号前缀
        $("#cardNumPrefix").text(dyCom.stringFiltedNull(list.cardNumPrefix));
        //卡号长度
        $("#cardNumLen").text(dyCom.stringFiltedNull(list.cardNumLen));
        //卡面值
        if(dyCom.stringFiltedNull(list.cardPrice)){
            var cardPrice = (Math.round(list.cardPrice)/100).toFixed(2)+'元';
            $('#cardPrice').html(cardPrice);
        }
        //是否带校验位（最后1位）
        $("#cardNumCheck").text(dyCom.stringFiltedNull(list.cardNumCheck));
        //是否支持虚拟卡
        $("#isVirtualCard").text(VirtualCardStatus(dyCom.stringFiltedNull(list.isVirtualCard)));
        //备注
        $("#childCardDemo").text(dyCom.stringFiltedNull(list.memo));
    }
}

/*渲染优惠商铺商品设置基本信息*/
function setDiscountData(list) {
    if(list){
        //主图
        if(dyCom.stringFiltedNull(list.typeId)){
            $("#primaryImg").append('<img src="'+dyCom.getImgPath(list.typeId, 'MAINIMG', token) +'" alt="子卡主图">')
        }
        //商铺名称
        $("#mcName").text(dyCom.stringFiltedNull(list.mcName));
        //卡状态
        var typeStatus = '';
        if(dyCom.stringFiltedNull(list.status)){
            typeStatus = getChildStatus(list.status);
        }
        $('#showTypeStatus').html(typeStatus);
        //商品名称
        $("#typeName").text(dyCom.stringFiltedNull(list.cmName));
        //优惠方式
        $("#discountType").text(discountTypeStatus(dyCom.stringFiltedNull(list.discountType)));
        //优惠次数
        $("#discountNum").text(dyCom.stringFiltedNull(list.discountNum));
        //是否需要预约
        $("#isNeedBook").text(bookTypeStatus(dyCom.stringFiltedNull(list.book)));
        //预约提前时间
        $("#bookAhead").text(dyCom.stringFiltedNull(list.bookAhead)+bookAheadUnitStatus(list.bookAheadUnit));
        //可预约几天内
        $("#bookDuration").text(bookEffectStatus(dyCom.stringFiltedNull(list.bookDuration)));
        //预约是否算使用次数
        $("#bookEffective").text(bookEffectStatus(dyCom.stringFiltedNull(list.cmName)));
        //优惠次数
        $("#cardMemo").text(dyCom.stringFiltedNull(list.memo));

    }
}

/*渲染年卡适用商铺商品设置基本信息*/
function setYearnSuitData(list){
    var limitedNumTotal='',limitedNumMonth='',limitedNumDay='';
    var limitedNumTotalTxt='',limitedNumMonthTxt='',limitedNumDayTxt='';
    if(list){
        //主图
        if(dyCom.stringFiltedNull(list.typeId)){
            $("#primaryImg").append('<img src="'+dyCom.getImgPath(list.typeId, 'MAINIMG', token) +'" alt="主图">')
        }
        //商铺名称
        $("#mcName").text(dyCom.stringFiltedNull(list.mcName));
        //卡状态
        var typeStatus = '';
        if(dyCom.stringFiltedNull(list.status)){
            typeStatus = getChildStatus(list.status);
        }
        $('#showTypeStatus').html(typeStatus);
        //商品名称
        $("#typeName").text(dyCom.stringFiltedNull(list.cmName));
//适用规则
        limitedNumTotal=dyCom.stringFiltedNull(list.limitedNumTotal);
        limitedNumMonth=dyCom.stringFiltedNull(list.limitedNumMonth);
        limitedNumDay=dyCom.stringFiltedNull(list.limitedNumDay);
        limitedNumTotal==0?limitedNumTotalTxt='不限制':limitedNumTotalTxt=limitedNumTotal;
        limitedNumMonth==0?limitedNumMonthTxt='不限制':limitedNumMonthTxt=limitedNumMonth;
        limitedNumDay==0?limitedNumDayTxt='不限制':limitedNumDayTxt=limitedNumDay;
        //可消费总次数
        $("#limitedNumTotal").text(limitedNumTotal);
        //每月可消费次数
        $("#limitedNumMonth").text(limitedNumMonthTxt);
        //每天可消费次数
        $("#limitedNumDay").text(limitedNumDayTxt);
        //是否需要预约
        $("#isNeedBook").text(bookTypeStatus(dyCom.stringFiltedNull(list.book)));
        //预约提前时间
        $("#bookAhead").text(dyCom.stringFiltedNull(list.bookAhead)+bookAheadUnitStatus(list.bookAheadUnit));
        //可预约几天内
        $("#bookDuration").text(bookEffectStatus(dyCom.stringFiltedNull(list.bookDuration)));
        //预约是否算使用次数
        $("#bookEffective").text(bookEffectStatus(dyCom.stringFiltedNull(list.cmName)));
        //优惠次数
        $("#cardMemo").text(dyCom.stringFiltedNull(list.memo));

    }
}

/*子卡列表页*/
/*获取卡类型ajax需要的参数*/
function getMcardChildTypeParams(){
    var paramsStr = '?';
    var paramsJson = [
    ];
    if(token){
        paramsJson.push('token='+token);
    }
    paramsStr += paramsJson.join('&');
    return paramsStr;
}

/*获取当前卡类型下的子卡类型列表*/
function getChildCardTypes(getChildListUrl) {
    //获取接口参数
    var cTypeParams = getMcardChildTypeParams();
    var cTypeParamsJson = {
        restPath:encodeURI(getChildListUrl+cTypeParams)
    };
    var optionsAjax = {
        url: ctx+'/ajax/get',  //请求url
        type: "get",         //请求类型 默认get
        async: true,            //异步|同步加载 默认异步
        dataType: "json",      //数据类型      默认json
        data:cTypeParamsJson
    };
    optionsAjax.callback = function(type,data){
        //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
        //返回结果处理
        if(type==1){
            //1 数据渲染
            //子卡列表
                setChildCardTypesData(data.result);
        }else{
            layer.msg(data);
        }
    };
    dyCom.ajaxRequest(optionsAjax);

}

/*渲染子卡列表数据*/
function setChildCardTypesData(list) {
    if(list){
        var listText = '';
        $.each(list, function (i, obj) {
            listText += '<li class="f-cb" data-childtypeId="'+dyCom.stringFiltedNull(obj.childtypeId)+'">' +
                '<img class="f-db f-fl" height="100%" src="' + dyCom.getImgPath(obj.childtypeId, 'MAINIMG', token) + '" alt="子卡主图">' +
                '<div class="f-fl imgInfo">' +
                '<h6 class="cardTitle">' + dyCom.stringFiltedNull(obj.childtypeName) + '</h6>' +
                '<p class="cardInfo">' + dyCom.stringFiltedNull(obj.childcardDesc) + '</p>' +
                    '<p class="cardNumPrefix">卡号前缀：'+dyCom.stringFiltedNull(obj.cardNumPrefix)+'</p>'+
                '<div class="f-cb">' +
                '<p class="f-fl">￥' + (Math.round(dyCom.stringFiltedNull(obj.cardPrice))/100).toFixed(2) + '</p>' +
                '<p class="f-fr">[ ' + getStatus(dyCom.stringFiltedNull(obj.status)) + ' ]</p>' +
                '</div>' +
                '</div>' +
                '</li>';
        });
        $("#cardDataList").empty().append(listText);
    }
}

/*年卡商铺商品清单列表页*/
/*获取卡类型ajax需要的参数*/
function getYearnCardParams(){
    var paramsStr = '?';
    var paramsJson = [
        'page=$page' ,
        'size=$pageSize'
    ];
    if(token){
        paramsJson.push('token='+token);
    }
    paramsStr += paramsJson.join('&');
    return paramsStr;
}

/*获取年卡商铺商品清单列表*/
function getYearnCardTypes(getUrl) {
    //获取接口参数
    var svrParamsString = getYearnCardParams();
    var paramsJson = {
        restPath:encodeURI(getUrl+svrParamsString)
    };
    var ajaxUrl = ctx+'/ajax/get';
    var options = {
        contentDomId: "#yarnCardList", //填充内容的节点ID 如：“#myrelease_container”
        pagesDomId: "#dy-pages",    //分页节点ID  "#dy-pages"
        scrollDom: window,               //window对象  为了滑动使用 目前使用的是body滚动
        currPage: 0,                          //当前页 默认为0 从0开始计算页码
        pageSize: 30,                       //每页多少条
        itemHeight: 155,                  //每条的高度  为了计算滑动的当前页使用 需要计算目前所在的页
        static_image: static_images,  //图片地址   ${static_images}  如：webapp/static_new/images
        ajaxParems: {                         //ajax请求的参数 对jquery的ajax 二次封装
            url: ajaxUrl,                        //请求地址  需要全地址
            type: "GET",                       //请求方式
            async: true,                        //异步|同步  默认true异步
            dataType: "JSON",             //数据格式
            data: paramsJson                              //ajax请求传参
        },
        callback: function (type, data) {   //回调  ajax请求返回的数据  data
            //接收到数据 判断 type是否等于1如果等于1做业务处理  比如调用渲染页面方法
            if(type==1&& data.result){
                setYearnCardData(data.result);
            }else{
                layer.msg(data);
            }
        }
    };
    dyPlugins.ajaxPages.Init(options);
}

/*渲染卡类型的年卡商铺商品清单数据*/
function setYearnCardData(list) {
    if(list && list.length){
        var listText = '';
        $.each(list, function (i, obj) {
            listText += '<li class="f-cb" data-typeId="'+dyCom.stringFiltedNull(obj.typeId)+'">' +
                '<img class="f-db f-fl" height="100%" src="' + dyCom.getImgPath(obj.typeId, 'MAINIMG', token) + '" alt="商铺主图">' +
                '<div class="f-fl imgInfo">' +
                '<h6 class="cardTitle">' + dyCom.stringFiltedNull(obj.mcName) + '</h6>' +
                '<p class="cardTitle">' + dyCom.stringFiltedNull(obj.cmName) + '</p>' +
                '<p class="">适用规则：'+dyCom.stringFiltedNull(obj.cardNumPrefix)+'</p>'+
                '<div class="">' +
                '<p>可消费总次数：'+dyCom.stringFiltedNull(obj.limitedNumTotal)+'</p>' +
                '<p>每月可消费次数：'+dyCom.stringFiltedNull(obj.limitedNumMonth)+'</p>' +
                '<p>每天可消费次数：'+dyCom.stringFiltedNull(obj.limitedNumDay)+'</p>'+
                '</div>' +
                '</div>' +
                '</li>';
        });
        $("#yarnCardList").append(listText);
        //设置可以加载 分页组件
        dyPlugins.ajaxPages.setAjaxFlag(true);
    }
}

/*卡类型的优惠商铺商品目录*/
/*获取年卡优惠商铺商品列表*/
function getCatalogsList(getUrl) {
    //获取接口参数
    var svrParamsString = getYearnCardParams();
    var paramsJson = {
        restPath:encodeURI(getUrl+svrParamsString)
    };
    var ajaxUrl = ctx+'/ajax/get';
    var options = {
        contentDomId: "#catalogsList", //填充内容的节点ID 如：“#myrelease_container”
        pagesDomId: "#dy-pages",    //分页节点ID  "#dy-pages"
        scrollDom: window,               //window对象  为了滑动使用 目前使用的是body滚动
        currPage: 0,                          //当前页 默认为0 从0开始计算页码
        pageSize: 30,                       //每页多少条
        itemHeight: 155,                  //每条的高度  为了计算滑动的当前页使用 需要计算目前所在的页
        static_image: static_images,  //图片地址   ${static_images}  如：webapp/static_new/images
        ajaxParems: {                         //ajax请求的参数 对jquery的ajax 二次封装
            url: ajaxUrl,                        //请求地址  需要全地址
            type: "GET",                       //请求方式
            async: true,                        //异步|同步  默认true异步
            dataType: "JSON",             //数据格式
            data: paramsJson                              //ajax请求传参
        },
        callback: function (type, data) {   //回调  ajax请求返回的数据  data
            //接收到数据 判断 type是否等于1如果等于1做业务处理  比如调用渲染页面方法
            if(type==1&& data.result){
                setCatalogsList(data.result);
            }else{
                layer.msg(data);
            }
        }
    };
    dyPlugins.ajaxPages.Init(options);
}

/*渲染卡类型的年卡优惠商铺商品数据*/
function setCatalogsList(list) {
    if(list && list.length){
        var listText = '';
        $.each(list, function (i, obj) {
            listText += '<li class="f-cb" data-typeId="'+dyCom.stringFiltedNull(obj.typeId)+'">' +
                '<img class="f-db f-fl" height="100%" src="' + dyCom.getImgPath(obj.typeId, 'MAINIMG', token) + '" alt="商铺主图">' +
                '<div class="f-fl imgInfo">' +
                '<h6 class="cardTitle">' + dyCom.stringFiltedNull(obj.mcName) + '</h6>' +
                '<p class="cardTitle">' + dyCom.stringFiltedNull(obj.cmName) + '</p>' +
                '<p class="">适用规则：'+dyCom.stringFiltedNull(obj.cardNumPrefix)+'</p>'+
                '<div class="">' +
                '<p>优惠方式：'+discountTypeStatus(dyCom.stringFiltedNull(obj.discountType)).statusTxt+'</p>' +
                '<p>优惠价格：'+dyCom.stringFiltedNull(obj.discountPrice)+discountTypeStatus(dyCom.stringFiltedNull(obj.discountType)).showText+'</p>' +
                '<p>优惠次数：'+dyCom.stringFiltedNull(obj.discountNum)+'</p>'+
                '</div>' +
                '</div>' +
                '</li>';
        });
        $("#catalogsList").append(listText);
        //设置可以加载 分页组件
        dyPlugins.ajaxPages.setAjaxFlag(true);
    }
}

