/*有效期方式选择列表*/
var validWayArray = [
    {
        id: '0',
        value: '自激活之日起有效'
    }, {
        id: '1',
        value: '自然年月日(即1.1-12.31有效)'
    }, {
        id: '2',
        value: '自销售之日起有效'
    }
];

/*有效期方式 下拉选择*/
function selectValidWay(selValue) {
    var option = {
        domId: "#cardExpirateType",
        selectName: "有效期方式",
        keyName: "value",
        valueName: "id",
        selectedValue: selValue?selValue:''
    };
    option.callback = function (selectObj) {
        /*使用规则--有效期方式为[自激活之日起有效]显示自动激活日期 下拉选择*/
        if (selectObj.value == 0) {
            $("#validWayFirst").addClass("f-db").removeClass("f-dn");
        } else {
            $("#validWayFirst").addClass("f-dn").removeClass("f-db");
        }
    };
    dyPlugins.selectModel.init(option, validWayArray);
}


/*有效期时间方式选择*/
function selectValidDate(selValue) {
    var option = {
        domId: "#validDateType",
        selectName: "有效期单位",
        keyName: "value",
        valueName: "id",
        selectedValue: selValue?selValue:''
    };
    option.callback = function (selectObj) {
    };
    dyPlugins.selectModel.init(option, validDate);
}

/*获取ajax需要的参数*/
function getSvrParamsSting() {
    var paramsStr = '?';
    var paramsJson = [];
    if (token) {
        paramsJson.push('token=' + token);
    }
    paramsStr += paramsJson.join('&');
    return paramsStr;
}

/*获取创建卡类型页面提交所需数据*/
function getFormData() {
    var formData = {
        "appData": {
            "typeName": $("#typeName").val(),//名称
            "cardPrice": dyCom.numMulti($("#cardPrice").val(),100),//价格
            "cardDesc": $("#cardIntro").val(),//简介
            "advanceBuyDay": $("#cardUpdateTime").val(),//续费时间
            "haveNumber": $("#cardCount").val(),//每人最多可绑定,
            "validWay": $("#cardExpirateType select").val(),//有效期方式
            "autoActivateDay": $("#validWayFirst input").val(),//【自激活之日起有效】，自动激活日期
            "validDate": $("#cardExpirate").val(),//有效期时间
            "validUnit": $("#validDateType select").val(),//有效期日期方式
        },
        "docList": docs
    };
    //新建页面传mcId，修改页面传typeId
    if($("#createCardType").length>0){
        formData.appData.mcId=mcId
    }else if($("#modifyCardType").length>0){
        formData.appData.mcId=mcId;
        formData.appData.typeId=typeId
    }
    return formData;
}


/*获取提交卡类型所需数据*/
function submitDataInfo() {
    //防止多次提交
    var clickFlag = $("#submitData").data("click");

    if (!clickFlag) {
        return false;
    }
    //提交之前验证
    $("#submitData").data("click", false); //设置不可点击提交按钮
    //提交验证 errTime 返回 0的时候 说明验证都通过 >0 说明 有errTime处有信息问题
    var errTime = dyPlugins.Validate.checkAll();

    if (errTime > 0) {
        $("#submitData").data("click", true); //设置可以点击
    }else {

        var formData = JSON.stringify(getFormData());

        var options = {
            url: ctx + '/ajax/post?restPath=' + encodeURIComponent(postUrl +'?token=' + token) + '&token=' + token,
            type: "POST",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data: formData
        };
        options.callback = function (type, data) {
            $("#submitData").data("click", true); //设置可以点击

            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if (type == 1) {

                $("#submitData").addClass("u-btn-disabled");
                $("#submitData").off("click");

                if ($("#createCardType").length > 0) {
                    layer.msg('卡类型创建成功！');
                    // TODO 卡类型创建成功，跳转页面
                    window.location.href = ctx + "/mcardtypes/mc/" + mcId + "/mcardtypes/manage";
                } else if ($('#modifyCardType').length > 0) {
                    layer.msg('卡类型修改成功！');
                    // TODO 卡类型修改成功，跳转页面
                    window.location.href = ctx + "/mcardtypes/" + encodeURI(typeId) + "/manage";
                }
            } else {
                layer.msg(data);
            }
        };
        dyCom.ajaxRequest(options);
    }
}


/*修改卡类型页面业务处理*/
/*获取卡类型详细信息*/
function getDataInfo() {
    var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
    var paramsJson = {
        restPath: encodeURI(getUrl + svrParamsString)
    };
    var options = {
        url: ctx + '/ajax/get',  //请求url
        type: "get",         //请求类型 默认get
        async: true,            //异步|同步加载 默认异步
        dataType: "json",      //数据类型      默认json
        data: paramsJson
    };
    options.callback = function (type, data) {
        //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
        //返回结果处理
        if (type == 1 && data.result) {
            setDataInfo(data.result);
        } else {
            layer.msg(data);
        }
    };
    dyCom.ajaxRequest(options);
}

/*渲染修改卡类型页面元素*/
function setDataInfo(list) {
    if (list) {
        mcId = list.mcId;
        typeId=list.typeId;

        var main = '<img src="'+dyCom.getImgPath(list.typeId, 'MAINIMG', token)+'" style="width: 100%; height: auto;">';
        $('#mainImg').html(main);

        $("#typeName").val(dyCom.stringFiltedNull(list.typeName));//名称
        $("#cardPrice").val(dyCom.stringFiltedNull((Math.round(list.cardPrice) / 100).toFixed(2)));//价格
        $('#organName').text(dyCom.stringFiltedNull(list.organName));//发行机构
        $('#createTime').text(dyCom.stringFiltedNull(dyCom.stringFiltedNull(list.createTime).substr(0,11)));


        $("#cardIntro").val(dyCom.stringFiltedNull(list.cardDesc));//简介
        $("#cardUpdateTime").val(dyCom.stringFiltedNull(list.advanceBuyDay));//续费时间
        if (dyCom.stringFiltedNull(list.haveNumber) == 0) {
            $("#cardCount").val("不限制");//每人最多可绑定
        } else {
            $("#cardCount").val(dyCom.stringFiltedNull(list.haveNumber))
        }
        //有效期方式
        if (dyCom.stringFiltedNull(list.validWay)) {
            //初始化有效期方式下拉筛选
            selectValidWay(list.validWay);
            if (list.validWay == '0') {
                $("#validWayFirst input").val(list.autoActivateDay);
            }
        }

        $("#cardExpirate").val(list.validDate);//有效期
        //初始化有效期日期方式下拉筛选
        selectValidDate(list.validUnit);

    }
}
