//将旧的枚举值转成新的枚举值数组
function dataConver(oldConstant) {
    var newConstant = [];
    if (oldConstant) {
        for (var key in oldConstant) {
            newConstant.push({id: key, value: oldConstant[key]});
        }
    }
    return newConstant;
}

/**
 * 获取静态枚举值的value
 * @param list      枚举值集合
 * @param id     值
 * @returns {*}
 */
function getValue(list, id) {
    if (list && id) {
        for(var i = 0, j=list.length; i < j; i++) {
            if (list[i].id == id) {
                return list[i].value;
            }
        }
    }
    return '';
}

/**
 * 递归获取静态枚举值的value
 * （处理多层静态资源方便，但性能较差）
 * @param list      枚举值集合
 * @param id     值
 * @returns {*}
 */
function getValueRecursion(list, id) {
    if (list && id) {
        for(var i = 0, j=list.length; i < j; i++) {
            if (list[i].id == id) {
                return list[i].value;
            }
            if (list[i].children) {
                var value = getValue(list[i].children, id);
                if (value) return value;
            }
        }
    }
    return '';
}

/**
 * 递归获取静态枚举值的value路径
 * （处理多层静态资源方便，但性能较差）
 * @param list          枚举值集合
 * @param id            值
 * @param interval      间隔
 * @returns {*}
 */
function getValueRecursionStr(list, id, interval) {
    if (list && id) {
        for(var i = 0, j=list.length; i < j; i++) {
            if (list[i].id == id) {
                return list[i].value;
            }
            if (list[i].children) {
                var value = getValue(list[i].children, id);
                if (value) return list[i].value + interval +value;
            }
        }
    }
    return '';
}

/**
 * 获取子级列表
 * @param list      集合列表
 * @param id        枚举值
 */
function queryChildrenList(list, id) {
    if (list && id) {
        for(var i = 0, j=list.length; i < j; i++) {
            if (list[i].id == id && list[i].children) {
                return list[i].children;
            }
        }
    }
    return '';
}