!(function(win) {
  var com = {};

  var def = {
    element: $("#treeDemo"), //容器Id
    enable: true, //true 、 false 分别表示 使用 、 不使用 简单数据模式
    idKey: "id", //节点数据中保存唯一标识的属性名称
    pIdKey: "pId", //节点数据中保存其父节点唯一标识的属性名称
    name: "name", //zTree 节点数据保存节点名称的属性名称  默认值："name"
    isCheckbox: false, //true 、 false 分别表示 显示 、不显示 复选框或单选框
    isExpandAll: false, //true 节点全部展开、false节点收缩
    isExpand3: false //是否展开3级,true 节点全部展开、false节点收缩
  };
  com.init = function(opt, zNodes, callbacks) {
    def = $.extend(def, opt);
    var settings = {
      data: {
        simpleData: {
          enable: def.enable,
          idKey: def.idKey,
          pIdKey: def.pIdKey,
          rootPId: -1 //用于修正根节点父节点数据，即 pIdKey 指定的属性值
        },
        key: {
          name: def.name
        }
      },
      check: {
        enable: def.isCheckbox,
        nocheckInherit: true //当父节点设置 nocheck = true 时，设置子节点是否自动继承 nocheck = true
      },
      callback: callbacks
    };

    var zTreeObj = $.fn.zTree.init(def.element, settings, zNodes); //初始化树

    if (def.isExpandAll) {
      zTreeObj.expandAll(def.isExpandAll);
    } else {
      if (def.isExpand3) {
        //默认展开三级
        var nodes = zTreeObj.getNodes();
        if (nodes.length > 0) {
          for (let i = 0; i < nodes.length; i++) {
            zTreeObj.expandNode(nodes[i], true, false, false);
            var neodeChild = nodes[i].children;
            if (neodeChild) {
              for (let j = 0; j < neodeChild.length; j++) {
                zTreeObj.expandNode(neodeChild[j], true, false, false);
                var neodeChild2 = neodeChild[j].children;
                if (neodeChild2) {
                  for (let n = 0; n < neodeChild2.length; n++) {
                    zTreeObj.expandNode(neodeChild2[n], false, false, false);
                  }
                }
              }
            }
          }
        }
      } else {
        zTreeObj.expandAll(def.isExpandAll);
      }
    }
  };
  if (!win.dyPlugins) {
    win.dyPlugins = {};
  }
  dyPlugins.Ztree = com;
})(window);
