/**
 @Name : h_common v1.0 常用方法 (包括表单验证)
 @Author: 刘辉
 */
!(function(win) {
  var this_form = "";
  var h_Common = {};
  var h_Validate = {};
  /**h_Common some Validate function**/
  h_Validate.tipmsg = {
    w: {
      "*": "不能为空！",
      "*6-16": "请输入6-16位任意字符！",
      n: "请输入任意数字！",
      "n6-16": "请输入6-16位数字！",
      s: "不能输入特殊字符！",
      "s6-18": "请填写6到18位字符！",
      m: "请输入手机号码为11位数字！",
      e: "请输入邮箱格式为XXXX@XXX.com！",
      p: "请输入邮政编码！",
      ncardNo: "请输入身份证号码！",
      bir: "请输入生日格式为2000-09-02！",
      radio: "请选择一项！",
      checkbox: "请选择选择一项！"
    },
    def: "信息有误,",
    undef: "datatype未定义！",
    reck: "两次输入的内容不一致！",
    r: "通过信息验证！",
    c: "正在检测信息…",
    s: "请{填写|选择}{0|信息}！",
    v: "所填信息没有经过验证，请稍后…",
    p: "正在提交数据…"
  };
  h_Validate.dataType = {
    "*": /[\w\W]+/,
    "*6-16": /^[\w\W]{6,16}$/,
    n: /^\d+$/,
    "n6-16": /^\d{6,16}$/,
    s: /^[\u4E00-\u9FA5\uf900-\ufa2d\w\.\s]+$/,
    "s6-18": /^[\u4E00-\u9FA5\uf900-\ufa2d\w\.\s]{6,18}$/,
    m: /^1[3-8]{1}[0-9]{9}$/,
    e: /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/,
    p: /^[0-9]{6}$/,
    ncardNo: "h_Validate.isIdCardNo",
    bir: /^((((1[6-9]|[2-9]\d)\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\d|3[01]))|(((1[6-9]|[2-9]\d)\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\d|30))|(((1[6-9]|[2-9]\d)\d{2})-0?2-(0?[1-9]|1\d|2[0-8]))|(((1[6-9]|[2-9]\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-))$/,
    radio: /[\w\W]+/,
    checkbox: /[\w\W]+/,
    submit: "h_Validate.before_submit"
  };

  h_Validate.init = function(form_id) {
    this_form = form_id;
    var this_required = $("#" + form_id + " .required");

    //提交按钮点击事件
    this_required.off("click").on("click", function() {
      var ef = $(this);
      var validate_type = ef.data("datatype");
      if (
        validate_type == "submit" ||
        ef.find("input").is(":radio") ||
        ef.find("input").is(":checkbox")
      ) {
        h_Validate.check_validate(validate_type, ef, "blur");
      }
    });
    //失去焦点
    this_required.off("blur").on("blur", function() {
      var ef = $(this);
      var validate_type = ef.data("datatype");
      if (validate_type != "submit") {
        h_Validate.check_validate(validate_type, ef, "blur");
      }
    });
    //获取焦点
    this_required.off("focus").on("focus", function() {
      var ef = $(this);
      var validate_type = ef.data("datatype");
      if (validate_type != "submit") {
        h_Validate.check_validate(validate_type, ef, "focus");
      }
    });
  };
  //type input (text radio checkbox ) select
  h_Validate.check_validate = function(validate_type, ef, type) {
    var inputval = "";
    var w_text = "";
    var checked_flag = true;

    if (ef.find("input").is(":radio")) {
      inputval = ef.find("input[name='" + ef.data("name") + "']:checked").val();
      if (!inputval) {
        inputval = "";
      }
    } else if (ef.find("input:checkbox").length) {
      ef.find("input[name='" + ef.data("name") + "']:checked").each(function() {
        inputval += $(this).val() + ",";
      });
    } else {
      inputval = ef.val();
    }

    var dataType_Regular = h_Validate.dataType[validate_type];
    if (validate_type == "ncardNo" || validate_type == "submit") {
      //身份证验证和提交
      //checked_flag = eval(dataType_Regular+"(ef)");
      var f_eval = eval(
        "(function()　{return　(" + dataType_Regular + ");})()"
      );
      f_eval.call(this, ef);
    } else {
      if (!dataType_Regular.test(inputval)) {
        checked_flag = false;
      }
    }

    if (!checked_flag) {
      if (type == "focus") {
        if (inputval == "") {
          w_text = h_Validate.tipmsg.w[validate_type];
        } else {
          w_text = h_Validate.tipmsg.def + h_Validate.tipmsg.w[validate_type];
        }
      } else {
        w_text = h_Validate.tipmsg.def + h_Validate.tipmsg.w[validate_type];
      }
      if (ef.find("input").is(":radio") || ef.find("input").is(":checkbox")) {
        if (ef.find("span.error").length > 0) {
          ef.find("span.error")
            .find(".mes_text")
            .text(w_text);
        } else {
          ef.append(
            '<span class="mes_err error f-mt-10"><span class="dec"><s class="dec1">◆</s><s class="dec2">◆</s></span><span class="mes_text">' +
              w_text +
              "</span></span>"
          );
        }
        ef.find("span.error")
          .addClass("mes_err")
          .removeClass("mes_right");
      } else {
        if (ef.next("span.error").length > 0) {
          ef.next("span.error")
            .find(".mes_text")
            .text(w_text);
        } else {
          ef.parent().append(
            '<span class="mes_err error"><span class="dec"><s class="dec1">◆</s><s class="dec2">◆</s></span><span class="mes_text">' +
              w_text +
              "</span></span>"
          );
        }
        ef.next("span.error")
          .addClass("mes_err")
          .removeClass("mes_right");
      }
    } else {
      if (ef.find("input").is(":radio") || ef.find("input").is(":checkbox")) {
        ef.find("span.error")
          .addClass("mes_right")
          .removeClass("mes_err")
          .find(".mes_text")
          .text(w_text);
      } else {
        ef.next("span.error")
          .addClass("mes_right")
          .removeClass("mes_err")
          .find(".mes_text")
          .text(w_text);
      }
    }
    return { flag: checked_flag };
  };

  //身份证验证
  h_Validate.isIdCardNo = function(ef) {
    var idNumber = ef.val();
    var factorArr = new Array(
      7,
      9,
      10,
      5,
      8,
      4,
      2,
      1,
      6,
      3,
      7,
      9,
      10,
      5,
      8,
      4,
      2,
      1
    );
    var varArray = new Array();
    var lngProduct = 0;
    var intCheckDigit;

    var birthday_T = "";
    var sex_T = "";
    /*if(ef.data("birthday")){
			$('#'+this_form+' input[name="'+ef.data("birthday")+'"]').val(birthday_T);//初始化生日
		}
		if(ef.data("sex")){
			$('#'+this_form+' input[name="'+ef.data("sex")+'"]').prop("checked",false);//初始化性别
		}*/

    if (idNumber.length != 15 && idNumber.length != 18) {
      return false;
    }
    for (i = 0; i < idNumber.length; i++) {
      varArray[i] = idNumber.charAt(i);
      if ((varArray[i] < "0" || varArray[i] > "9") && i != 17) {
        return false;
      } else if (i < 17) {
        varArray[i] = varArray[i] * factorArr[i];
      }
    }
    if (idNumber.length == 18) {
      var date8 = idNumber.substring(6, 14);
      if (h_Common.checkDate(date8) == false) {
        return false;
      }
      for (i = 0; i < 17; i++) {
        lngProduct = lngProduct + varArray[i];
      }
      intCheckDigit = 12 - (lngProduct % 11);
      switch (intCheckDigit) {
        case 10:
          intCheckDigit = "X";
          break;
        case 11:
          intCheckDigit = 0;
          break;
        case 12:
          intCheckDigit = 1;
          break;
      }

      if (varArray[17].toUpperCase() != intCheckDigit) {
        return false;
      }
      birthday_T =
        date8.substring(0, 4) +
        "-" +
        date8.substring(4, 6) +
        "-" +
        date8.substring(6, 8);
      sex_T = idNumber.substring(16, 17);
    } else {
      var date6 = idNumber.substring(6, 12);

      if (h_Common.checkDate6(date6) == false) {
        return false;
      }
      birthday_T =
        "19" +
        date6.substring(0, 2) +
        "-" +
        date6.substring(2, 4) +
        "-" +
        date6.substring(4, 6);
      sex_T = idNumber.substring(14, 15);
    }

    if (ef.data("birthday")) {
      $("#" + this_form + ' input[name="' + ef.data("birthday") + '"]').val(
        birthday_T
      ); //联动生日
      $("#" + this_form + ' input[name="' + ef.data("birthday") + '"]')
        .next("span.error")
        .addClass("mes_right")
        .removeClass("mes_err")
        .find(".mes_text")
        .text("");
    }

    if (ef.data("sex")) {
      $(
        "#" +
          this_form +
          ' input[name="' +
          ef.data("sex") +
          '"][data-value="' +
          (sex_T % 2) +
          '"]'
      ).prop("checked", true); // 0(女),1(男)  联动性别
      $("#" + this_form + ' input[name="' + ef.data("sex") + '"]')
        .parent()
        .find("span.error")
        .addClass("mes_right")
        .removeClass("mes_err")
        .find(".mes_text")
        .text("");
    }

    return true;
  };

  h_Common.checkDate = function(str) {
    str = h_Common.convDate(str, "/");
    if (str.length != 8 || !h_Common.checkNumber(str)) {
      return false;
    }
    var year = str.substring(0, 4);
    var month = str.substring(4, 6);
    var day = str.substring(6, 8);
    dayOfMonth = new Array(31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    if (month < 1 || month > 12) {
      return false;
    }
    if (day < 1 || day > dayOfMonth[month - 1]) {
      return false;
    }
    if (!h_Common.checkLeapYear(year) && month == 2 && day == 29) {
      return false;
    }
    return true;
  };

  h_Common.checkDate6 = function(str) {
    str = h_Common.convDate(str, "/");
    if (str.length != 6 || !h_Common.checkNumber(str)) {
      return false;
    }
    var year = str.substring(0, 2);
    var month = str.substring(2, 4);
    var day = str.substring(4, 6);
    dayOfMonth = new Array(31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    if (month < 1 || month > 12) {
      return false;
    }
    if (day < 1 || day > dayOfMonth[month - 1]) {
      return false;
    }
    //	if (!checkLeapYear(year) && (month == 2) && (day == 29)) {
    //	  return false;
    //	}
    return true;
  };
  //日期型转换为格式化的字符串  YYYYMMDD
  h_Common.convDate = function(sDate, sSep) {
    var pos = 0;
    var str = sDate;
    var len = str.length;
    if (len < 8 || len > 10) {
      return str;
    } else if (str.indexOf(sSep) == 4) {
      pos = str.indexOf(sSep, 5);
      if (pos == 6) {
        if (len == 8) {
          return (
            str.substring(0, 4) +
            "0" +
            str.substring(5, 6) +
            "0" +
            str.substring(7, 8)
          );
        } else {
          return (
            str.substring(0, 4) +
            "0" +
            str.substring(5, 6) +
            str.substring(7, 9)
          );
        }
      } else if (pos == 7) {
        if (len == 9) {
          return (
            str.substring(0, 4) +
            str.substring(5, 7) +
            "0" +
            str.substring(8, 9)
          );
        } else {
          return (
            str.substring(0, 4) + str.substring(5, 7) + str.substring(8, 10)
          );
        }
      } else {
        return str;
      }
    } else {
      return str;
    }
  };
  /**判断是否是数字（身份证验证使用）**/
  h_Common.checkNumber = function(str) {
    var i;
    var len = str.length;
    var chkStr = "1234567890";
    if (len == 1) {
      if (chkStr.indexOf(str.charAt(i)) < 0) {
        return false;
      }
    } else {
      if (chkStr.indexOf(str.charAt(0)) < 0) {
        return false;
      }
      for (i = 1; i < len; i++) {
        if (chkStr.indexOf(str.charAt(i)) < 0) {
          return false;
        }
      }
    }
    return true;
  };
  /**判断是否是闰年（身份证验证使用）**/
  h_Common.checkLeapYear = function(year) {
    if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0) {
      return true;
    }
    return false;
  };
  h_Validate.checkAll = function() {
    var validate_err_num = 0;
    //console.log($('#'+this_form+' .required').length);
    $("#" + this_form + " .required").each(function(i, n) {
      //console.log(i);
      var efv = $(this);
      var validate_type = efv.data("datatype");
      if (validate_type != "submit") {
        var validate_flag = h_Validate.check_validate(
          validate_type,
          efv,
          "blur"
        );

        if (validate_flag.flag == false) {
          if (validate_err_num == 0) {
            $(efv).focus();
          }
          validate_err_num++;
        }
      }
    });
    return validate_err_num;
  };
  /**表单提交**/
  h_Validate.before_submit = function(ef) {
    var validate_err_num = h_Validate.checkAll();
    if (validate_err_num == 0) {
      $("#" + this_form).submit();
    }
    return true;
  };

  /**h_Common some public function**/
  /**url中数据的提取数据 get请求**/
  h_Common.getUrlParam = function(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
    var r = window.location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]);
    return null;
  };

  /**获取服务器时间并且加上间隔时间**/
  h_Common.serverDate = function() {
    var start_day = $("#start_day").val();
    if (start_day == 0) {
      start_day = 6;
    }
    var date = $("#server_time").val();
    date = parseInt(date);
    var bombay = date + 3600 * 24 * start_day;
    var time_s = new Date(bombay * 1000);
    var time_str =
      time_s.getFullYear() +
      "-" +
      (time_s.getMonth() + 1 > 9
        ? time_s.getMonth() + 1
        : "0" + (time_s.getMonth() + 1)) +
      "-" +
      (time_s.getDate() > 9 ? time_s.getDate() : "0" + time_s.getDate());
    return time_str;
  };

  /**获取服务器时间不加间隔时间**/
  h_Common.serverNowDate = function() {
    var date = $("#server_time").val();
    date = parseInt(date);

    var time_s = new Date(date * 1000);

    var time_str =
      time_s.getFullYear() +
      "-" +
      (time_s.getMonth() + 1 > 9
        ? time_s.getMonth() + 1
        : "0" + (time_s.getMonth() + 1)) +
      "-" +
      (time_s.getDate() > 9 ? time_s.getDate() : "0" + time_s.getDate());
    return time_str;
  };

  /**获取服务器时间+/-几天  可以是负数也可以是正数**/

  h_Common.servernow_Day = function(num) {
    var date = $("#server_time").val();
    date = parseInt(date);

    var time_s = new Date((date + parseInt(num) * 3600 * 24) * 1000);

    var time_str =
      time_s.getFullYear() +
      "-" +
      (time_s.getMonth() + 1 > 9
        ? time_s.getMonth() + 1
        : "0" + (time_s.getMonth() + 1)) +
      "-" +
      (time_s.getDate() > 9 ? time_s.getDate() : "0" + time_s.getDate());
    return time_str;
  };

  /**时间转化成字符串 以 str_val 为间隔**/
  h_Common.time2string = function(date_times, str_val) {
    var str_Month =
      date_times.getMonth() + 1 < 10
        ? "0" + (date_times.getMonth() + 1)
        : date_times.getMonth() + 1;
    var str_Date =
      date_times.getDate() < 10
        ? "0" + date_times.getDate()
        : date_times.getDate();

    var date_str =
      date_times.getFullYear() + str_val + str_Month + str_val + str_Date;
    return date_str;
  };

  /**ajax数据加载  VAR  A = Ajax_option(url_type,Qjson,type,async_type);**/
  h_Common.Ajax_option = function(url_type, Qjson, type, async_type) {
    var dataajax = "";

    $.ajax({
      url: url_type,
      type: type,
      async: async_type,
      dataType: "json",
      data: Qjson,
      success: function(result) {
        if (result != null) {
          dataajax = result;
        } else {
          dataajax = [];
        }
      },
      error: function(result) {}
    });
    return dataajax;
  };

  /**页面跳转**/
  h_Common.redirect = function(ef) {
    document.location.href = $(ef).data("value");
  };

  /**浮点数乘法**/
  h_Common.accMul = function(arg1, arg2) {
    var m = 0,
      ms = 0,
      mz = 0,
      s1 = arg1.toString(),
      s2 = arg2.toString();
    try {
      m = s1.split(".")[1].length;
    } catch (e) {}
    try {
      ms = s2.split(".")[1].length;
    } catch (e) {}
    if (m > ms) {
      mz = m;
    } else {
      mz = ms;
    }
    return parseFloat(
      (Number(s1.replace(".", "")) * Number(s2.replace(".", ""))).toFixed(0) /
        Math.pow(10, m + ms)
    ).toFixed(mz);
  };

  /**浮点数减法**/
  h_Common.accsubtract = function(arg1, arg2) {
    var r1,
      r2,
      m,
      mz = 0;

    try {
      r1 = arg1.toString().split(".")[1].length;
    } catch (e) {
      r1 = 0;
    }
    try {
      r2 = arg2.toString().split(".")[1].length;
    } catch (e) {
      r2 = 0;
    }
    m = Math.pow(10, Math.max(r1, r2));
    if (r1 > r2) {
      mz = r1;
    } else {
      mz = r2;
    }
    return parseFloat((arg1 * m - arg2 * m).toFixed(0) / m).toFixed(mz);
  };

  /**浮点数相加**/
  h_Common.accAdd = function(arg1, arg2) {
    var r1,
      r2,
      m,
      mz = 0;

    try {
      r1 = arg1.toString().split(".")[1].length;
    } catch (e) {
      r1 = 0;
    }
    try {
      r2 = arg2.toString().split(".")[1].length;
    } catch (e) {
      r2 = 0;
    }
    m = Math.pow(10, Math.max(r1, r2));
    if (r1 > r2) {
      mz = r1;
    } else {
      mz = r2;
    }
    return parseFloat((arg1 * m + arg2 * m).toFixed(0) / m).toFixed(mz);
  };

  /**除法**/
  h_Common.accDiv = function(arg1, arg2) {
    var t1 = 0,
      t2 = 0,
      r1,
      r2;
    try {
      t1 = arg1.toString().split(".")[1].length;
    } catch (e) {}
    try {
      t2 = arg2.toString().split(".")[1].length;
    } catch (e) {}
    with (Math) {
      r1 = Number(arg1.toString().replace(".", ""));
      r2 = Number(arg2.toString().replace(".", ""));
      return (r1 / r2) * pow(10, t2 - t1);
    }
  };

  /**根据生日计算年龄  dom_id只有华安学平险目前使用  dom_id  是为了被保险人年龄的计算  以保险起期来开始投保的**/
  h_Common.getAgeByBirthday = function(bir, dom_id) {
    if (trim(bir) == "") {
      return "";
    } else if (/^(\d{4})(-)(\d{1,2})(-)(\d{1,2})$/.test(trim(bir))) {
      var birthday = new Date(bir.replace(/-/g, "/"));
      if ($("#cp_name").val() == "xinhua_licaierhao") {
        if (birthday.getFullYear() == 1954 && birthday.getMonth() == 10) {
          bir = timeStamp2String(bir, 0, "day").substring(0, 10);
          birthday = new Date(bir.replace(/-/g, "/"));
        }
      }

      var d = new Date();
      if ($("#xuepingxian").val() == "y" && dom_id == "assured_birthday") {
        d = new Date(
          $("#startDate")
            .val()
            .substring(0, 10)
            .replace(/-/g, "/")
        );
      }

      var age =
        d.getFullYear() -
        birthday.getFullYear() -
        (d.getMonth() < birthday.getMonth() ||
        (d.getMonth() == birthday.getMonth() &&
          d.getDate() < birthday.getDate())
          ? 1
          : 0);

      if (typeof age == "undefined") {
        //alert("getAgeByBirthday，变量无效");
        age = -1;
      } else if (isNaN(age)) {
        //alert("getAgeByBirthday，年龄是非数字");
        age = -1;
      } else {
        //alert("getAgeByBirthday: "+age);
      }
    } else {
      age = -1;
    }
    return age;
  };
  h_Common.Validate = h_Validate;
    if (!win.dyPlugins) {
        win.dyPlugins = {};
    }
  win.dyPlugins.Validate = h_Validate;
})(window);
