
// 初始化时间选择组件的 可选日期集合
function formatYear (nowYear) {
    var arr = [];
    for (var i = nowYear - 50; i <= nowYear + 5; i++) {
        arr.push({
            id: i + '',
            value: i + '年'
        });
    }
    return arr;
}
function formatMonth () {
    var arr = [];
    for (var i = 1; i <= 12; i++) {
        arr.push({
            id: i + '',
            value: i + '月'
        });
    }
    return arr;
}
function formatDate (count) {
    var arr = [];
    for (var i = 1; i <= count; i++) {
        arr.push({
            id: i + '',
            value: i + '日'
        });
    }
    return arr;
}


var yearData = function(callback) {
    callback(formatYear(nowYear))
}
var monthData = function (year, callback) {
    callback(formatMonth());
};
var dateData = function (year, month, callback) {
    if (/^(1|3|5|7|8|10|12)$/.test(month)) {
        callback(formatDate(31));
    }
    else if (/^(4|6|9|11)$/.test(month)) {
        callback(formatDate(30));
    }
    else if (/^2$/.test(month)) {
        if (year % 4 === 0 && year % 100 !==0 || year % 400 === 0) {
            callback(formatDate(29));
        }
        else {
            callback(formatDate(28));
        }
    }
    else {
        throw new Error('month is illegal');
    }
};
var hourData = function(year, month, day, callback) {
    var hours = [];
    for (var i = 0,len = 24; i < len; i++) {
        hours.push({
            id: i,
            value: i + '时'
        });
    }
    callback(hours);
};
var minuteData = function(year, month, day, hour, callback) {
    var minutes = [];
    for (var i = 0, len = 60; i < len; i++) {
        minutes.push({
            id: i,
            value: i + '分'
        });
    }
    callback(minutes);
};
var secondsData = function(oyear, month, day, hour, minute, callback) {
    var seconds = [];
    for (var i = 0, len = 60; i < len; i++) {
        seconds.push({
            id: i,
            value: i + '秒'
        });
    }
    callback(seconds);
};