!(function(win) {
  var ajaxPages = {};
  /**
   var options = {
      contentDomId:'#myrelease_container',      //内容dom节点ID
      pagesDomId:'#dy-pages',                  //分页dom节点ID
      scrollDom:window,                       //滚动的dom对象
      currPage:1,                            //当前页
      pageSize:10,                  //每页多少条
      itemHeight:155,               //每条内容高度
      url: "http://www.baidu.com",  //请求url
      type: "get|post|put",         //请求类型 默认get
      async: true|false,            //异步|同步加载 默认异步
      dataType: "json|jsonp",       //数据类型      默认json
      data:{},                      //参数 json格式
  }
   */
  ajaxPages.options = {
    contentDomId: "#myrelease_container",
    pagesDomId: "#dy-pages",
    scrollDom: win,
    currPage: 0,
    pageSize: 10,
    itemHeight: 155,
    static_image: "",
    ajaxParems: {
      url: "",
      type: "GET",
      async: true,
      dataType: "JSON",
      data: {}
    }
  };

  ajaxPages.Init = function(optionJson) {
    /*返回顶部*/
    dyCom.callbackTop(optionJson.static_image, 0);
    // console.log('进入了初始化');
    //初始化options
    optionJson.viewH =
      document.documentElement.clientHeight || document.body.clientHeight; //可见高度
    optionJson.topValue = 0; // 上次滚动条到顶部的距离
    optionJson.intervalTime = null; //定时器
    optionJson.isAjaxFlag = true; //是否可以请求 true 可以请求 false 不可以请求
    optionJson.isLoadFlag = true; //是否显示加载状态 true 加载中... false 加载完成
    if (!optionJson.totalCount) {
      optionJson.totalCount = 0; // 总条数
    }
    //把获取到的options给 组件的options, ajaxPages.options
    ajaxPages.options = optionJson;
    $(ajaxPages.options.pagesDomId + " .page-loading").show();

    //初始化分页html
    ajaxPages.htmlInit();

    //第一次加载
    ajaxPages.options.ajaxParems.data.page = optionJson.currPage;
    ajaxPages.options.ajaxParems.data.size = optionJson.pageSize;
    ajaxPages.options.ajaxParems.callback = function(type, data) {
      ajaxPages.ajaxCallback(type, data);
    }; //ajax返回回调
    if (optionJson.totalCount == 0) {
      //清空列表容器
      $(contentDomId).html("");
      $(ajaxPages.options.pagesDomId + " .page-loading").show();
      dyCom.ajaxRequest(ajaxPages.options.ajaxParems);
    } else {
      if (ajaxPages.options.totalCount == ajaxPages.options.currPage + 1) {
        $(ajaxPages.options.pagesDomId + " .page-loading").hide();
        $(ajaxPages.options.pagesDomId + " .page-over").show();
      }
    }
    //监听
    ajaxPages.listenerScroll();
  };
  //初始化分页的html内容
  ajaxPages.htmlInit = function() {
    var tempId = ajaxPages.options.pagesDomId;
    var pageHtml =
      '<div class="dy-pages" id="' +
      tempId.replace("#", "") +
      '" ' +
      'data-loading="true" ' +
      'data-currpage="' +
      ajaxPages.options.currPage +
      '" ' +
      'data-size="' +
      ajaxPages.options.pageSize +
      '" ' +
      'data-pages="' +
      ajaxPages.options.totalCount +
      '" ' +
      'data-showcurrpage="' +
      ajaxPages.options.currPage +
      '">' +
      '            <div class="page-loading">正在加载...</div>' +
      '            <div class="page-nodata">暂无数据</div>' +
      '            <div class="page-error">加载失败,<span id="reloadAjax" class="page-reload">请重新加载</span></div>' +
      '        <div class="page-over">我是有底线的</div>' +
      '            <div class="page-count"><span class="curr-showpage">' +
      (ajaxPages.options.currPage ? ajaxPages.options.currPage : 1) +
      '</span>/<span class="counts-page">' +
      (ajaxPages.options.totalCount
        ? ajaxPages.options.totalCount
        : ajaxPages.options.currPage) +
      "</span></div>" +
      "        </div>";
    if (
      !$(ajaxPages.options.pagesDomId) ||
      $(ajaxPages.options.pagesDomId).length == 0
    ) {
      $("body").append(pageHtml);
    }
    //绑定重新加载
    $(ajaxPages.options.pagesDomId + " #reloadAjax")
      .off("click")
      .on("click", function() {
        $(ajaxPages.options.pagesDomId + " .page-loading").show();
        $(ajaxPages.options.pagesDomId + " .page-error").hide();
        ajaxPages.options.ajaxParems.data.size = ajaxPages.options.pageSize;
        ajaxPages.options.ajaxParems.data.page = ajaxPages.options.currPage + 1;
        ajaxPages.options.ajaxParems.callback = function(type, data) {
          ajaxPages.ajaxCallback(type, data);
        }; //ajax返回回调
        dyCom.ajaxRequest(ajaxPages.options.ajaxParems);
      });
  };
  //ajax返回数据处理
  ajaxPages.ajaxCallback = function(type, data) {
    var textType = 0;
    if (type == 1 || type == 2) {
      if (data.totalPage) {
        ajaxPages.options.totalCount = data.totalPage;
        $(ajaxPages.options.pagesDomId).data("pages", data.totalPage);
        $(ajaxPages.options.pagesDomId + " .counts-page").text(data.totalPage);
      }
      if (ajaxPages.options.currPage == 0) {
        //第一页
        if (!data.result || data.result.length == 0) {
          //暂无数据
          textType = 1;
          //暂无数据
          $(ajaxPages.options.pagesDomId + " .page-nodata").show();
          $(ajaxPages.options.pagesDomId + " .page-error").hide();
          $(ajaxPages.options.pagesDomId + " .page-over").hide();
          $(ajaxPages.options.pagesDomId + " .page-loading").hide();
        } else if (data.result.length < ajaxPages.options.pageSize) {
          //我到底了
          textType = 2;
          $(ajaxPages.options.pagesDomId + " .page-over").show();
          $(ajaxPages.options.pagesDomId + " .page-nodata").hide();
          $(ajaxPages.options.pagesDomId + " .page-error").hide();
        }
      } else if (ajaxPages.options.currPage > 0) {
        //从第二页开始
        if (
          !data.result ||
          data.result.length == 0 ||
          data.result.length < ajaxPages.options.pageSize
        ) {
          //我到底了
          textType = 2;
          $(ajaxPages.options.pagesDomId + " .page-over").show();
          $(ajaxPages.options.pagesDomId + " .page-nodata").hide();
          $(ajaxPages.options.pagesDomId + " .page-error").hide();
        }
      }
    } else {
      //报错的
      textType = 3;
      //报错的
      $(ajaxPages.options.pagesDomId + " .page-error").show();
      $(ajaxPages.options.pagesDomId + " .page-over").hide();
      $(ajaxPages.options.pagesDomId + " .page-loading").hide();
      $(ajaxPages.options.pagesDomId + " .page-nodata").hide();
    }
    if (textType == 0 || textType == 2) {
      ajaxPages.options.currPage = ajaxPages.options.ajaxParems.data.page;
      $(ajaxPages.options.pagesDomId).data(
        "currpage",
        ajaxPages.options.currPage
      );
    }

    ajaxPages.options.callback(type, data);
  };
  //设置ajax是否可以加载
  ajaxPages.setAjaxFlag = function(flag) {
    ajaxPages.options.isAjaxFlag = flag;
  };
  //监听滚动事件
  ajaxPages.listenerScroll = function() {
    // console.log('进入监听事件');
    var domObj = win;
    if (ajaxPages.options.scrollDom) {
      domObj = ajaxPages.options.scrollDom;
    }
    domObj.addEventListener("scroll", function() {
      $(ajaxPages.options.pagesDomId + " .page-count").show(); //滚动中显示页码

      var contentH = document.body.scrollHeight, //内容高度
        scrollTop =
          document.documentElement.scrollTop || document.body.scrollTop; //滚动高度

      //判断滚动停止
      if (ajaxPages.options.intervalTime == null) {
        ajaxPages.options.intervalTime = setInterval(function() {
          ajaxPages.isStop();
        }, 1000);
      }
      if (scrollTop > 800) {
        $(".callback-top").show();
      } else {
        $(".callback-top").hide();
      }
      var scrollUp = ajaxPages.options.topValue < scrollTop;
      //赋值滚动距离 为了判断滚动停止使用
      ajaxPages.options.topValue = scrollTop;

      //当前所在页面
      ajaxPages.getCurpage();

      if (!scrollUp) {
        return false;
      }
      // console.log('获取高度并打印');
      //console.log(contentH , ajaxPages.options.viewH , scrollTop)
      if (
        ajaxPages.options.isAjaxFlag &&
        scrollTop > 0 &&
        contentH - ajaxPages.options.viewH - scrollTop <= 100
      ) {
        //当滚动到距离底部100px时,
        if (ajaxPages.options.isAjaxFlag) {
          ajaxPages.options.isAjaxFlag = false;
          //总页数满足条件
          if (
            ajaxPages.options.currPage < ajaxPages.options.totalCount - 1 &&
            ajaxPages.options.totalCount > 0
          ) {
            $(ajaxPages.options.pagesDomId + " .page-loading").show();
            //请求接口
            ajaxPages.options.ajaxParems.data.page =
              ajaxPages.options.currPage + 1;
            dyCom.ajaxRequest(ajaxPages.options.ajaxParems);
          }
        }
      }
    });
  };
  //是否停止滚动
  ajaxPages.isStop = function() {
    // console.log('进入了是否停止滚动');
    var scrollTop =
      document.documentElement.scrollTop || document.body.scrollTop;
    if (scrollTop == ajaxPages.options.topValue) {
      setTimeout(function() {
        $(ajaxPages.options.pagesDomId + " .page-count").hide();
      }, 1500);
      clearInterval(ajaxPages.options.intervalTime);
      ajaxPages.options.intervalTime = null;
    }
  };

  //获取当前所在的页码 并赋值到页面上
  ajaxPages.getCurpage = function(itemHeight, pageSize) {
    // console.log('设置页码');
    var itemHeightTemp = itemHeight || ajaxPages.options.itemHeight;
    var pageSizeTemp = pageSize || ajaxPages.options.pageSize;
    var scrollTop =
      document.documentElement.scrollTop || document.body.scrollTop; //滚动高度
    var curr = Math.ceil(Math.ceil(scrollTop / itemHeightTemp) / pageSizeTemp);
    if (itemHeight) {
      return curr;
    }
    if (curr == 0) {
      curr = 1;
    }
    $(ajaxPages.options.pagesDomId + " .curr-showpage").text(curr);
    $(ajaxPages.options.pagesDomId).data("showcurrpage", curr);
  };
  /*
   * 判断有没有滚动定位 返回 滚动对象或者false
   */
  ajaxPages.isScrollFlag = function(localObj) {
    var localJson = sessionStorage.getItem(localObj);
    //当localJson存在说明是从详情返回的页面
    if (localJson) {
      sessionStorage.removeItem(localObj);
      localJson = JSON.parse(localJson);
      if (localJson.scrollHeight && localJson.nums) {
        return localJson;
      } else {
        return false;
      }
    } else {
      return false;
    }
  };
  /*跳转详情设置当前位置*/
  ajaxPages.setScrollInfo = function(ef, localObj) {
    var scrollHeight =
      document.documentElement.scrollTop || document.body.scrollTop;
    var nums = $(options.contentDomId).children().length;
    var curIndex = $(ef)
      .parent()
      .parent()
      .index();
    var localJson = {
      nums: nums,
      scrollHeight: scrollHeight,
      curIndex: curIndex
    };
    sessionStorage.setItem(localObj, JSON.stringify(localJson));
  };
  // 带返回定位的初始化
  ajaxPages.initWithCallbackLocation = function(
    ajaxParems,
    localObj,
    callbackHtml,
    callbackPageInit
  ) {
    //是否有滚动定位
    var isCrollFlagValue = ajaxPages.isScrollFlag(localObj);
    var urlText = ajaxParems.url;
    if (isCrollFlagValue) {
      var maxSize = Math.ceil(parseInt(isCrollFlagValue.nums) / 10) * 10;
      urlText += "&page=0&size=" + maxSize;

      ajaxParems.url = urlText;
      ajaxParems.callback = function(type, data) {
        if (type == 1 && data.result && data.result.length) {
          callbackHtml(isCrollFlagValue, data);
          document.documentElement.scrollTop = isCrollFlagValue.scrollHeight;
          document.body.scrollTop = isCrollFlagValue.scrollHeight;
          callbackPageInit();
        }
      }; //ajax返回回调
      dyCom.ajaxRequest(ajaxParems);

    } else {
      callbackPageInit();
    }
  };
  if (!win.dyPlugins) {
    win.dyPlugins = {};
  }
  win.dyPlugins.ajaxPages = ajaxPages;
})(window);
