;!function (win) {
  var lottery = {};
  lottery.options = {
    contentDomId:'#myLottery',
    screenWidth: window.innerWidth,
    screenHeight: window.innerHeight,
    container: null,
    
    particle: null,
    camera: null,
    renderer: null,
    starSnow: 1,
    particles: [],
    particleImage: new Image(),
    // particleImage.src= '../image/ParticleSmoke.png',
    pointerImg: null,
    rotateImg: null,
    touchStartX: null,
    touchFlag: 0,
    touchSensitive: 80,

  }
  lottery.init = function (options) {
    lottery.options = options;

    if (lottery.options) {
      var externalContainer = $(lottery.options.contentDomId).addClass('couten');    //抽奖转盘容器
      
      //1、创建转盘画布
      var turntableDiv = $('<div></div>').addClass('turntable-bg');

      //2、创建指针
      var pointerDiv = $('<div></div>').addClass('pointer');
      turntableDiv.append(pointerDiv);
      var pointerImg = $('<img></img>').attr('src', lottery.options.pointerImg);
      pointerDiv.append(pointerImg);

      //3、创建转盘
      var rotateDiv = $('<div></div>').addClass('rotate');
      turntableDiv.append(rotateDiv);
      var rotateImg = $('<img></img>').attr('id', 'rotate')
                                      .attr('src', lottery.options.rotateImg)
      rotateDiv.append(rotateImg);
      externalContainer.append(turntableDiv);

      lottery.options.container = $('<div></div>');
      externalContainer.append(lottery.options.container);

      camera = new THREE.PerspectiveCamera(50, lottery.options.screenWidth / lottery.options.screenHeight, 1, 10000);
      camera.position.z = 1000;


      scene = new THREE.Scene();
      scene.add(camera);

      renderer = new THREE.CanvasRenderer();
      renderer.setSize(lottery.options.screenWidth, lottery.options.screenHeight);
      var material = new THREE.ParticleBasicMaterial({ map: new THREE.Texture(lottery.options.particleImage) });

      for (var i = 0; i < 260; i++) {

          particle = new Particle3D(material);
          particle.position.x = Math.random() * 2000 - 1000;

          particle.position.z = Math.random() * 2000 - 1000;
          particle.position.y = Math.random() * 2000 - 1000;

          particle.scale.x = particle.scale.y = 0.5;
          scene.add(particle);
          // console.log(lottery.options.particles);
          
          lottery.options.particles.push(particle);
      }
      
      
      lottery.options.container.append(renderer.domElement);
      // console.log(lottery.options.container);
      document.addEventListener('touchstart', lottery.onDocumentTouchStart, false);
      document.addEventListener('touchmove', lottery.onDocumentTouchMove, false);
      document.addEventListener('touchend', lottery.onDocumentTouchEnd, false);

      setInterval(lottery.loop, 1000 / 40);
    }
  }

  lottery.onDocumentTouchStart = function (event) {
    if (event.touches.length == 1) {

      // event.preventDefault();
      lottery.options.touchStartX = 0;
      lottery.options.touchStartX = event.touches[0].pageX;
    }
  }

  lottery.onDocumentTouchMove = function (event) {
    if (event.touches.length == 1) {
      // event.preventDefault();
      var direction = event.touches[0].pageX - lottery.options.touchStartX;
      if (Math.abs(direction) > lottery.options.touchSensitive) {
          if (direction > 0) { lottery.options.touchFlag = 1; }
          else if (direction < 0) { lottery.options.touchFlag = -1; };
   
      }
    }
  }

  lottery.onDocumentTouchEnd = function (event) {
    var direction = event.changedTouches[0].pageX - lottery.options.touchStartX;
    lottery.changeAndBack(lottery.options.touchFlag);
  }
  
  lottery.changeAndBack = function (touchFlag) {
    var speedX = 20 * touchFlag;
    touchFlag = 0;
    for (var i = 0; i < lottery.options.particles.length; i++) {
      lottery.options.particles[i].velocity = new THREE.Vector3(speedX, -10, 0);
    }
    var timeOut = setTimeout(";", 800);
    clearTimeout(timeOut);

    var clearI = setInterval(function () {
        if (lottery.options.touchFlag) {
            clearInterval(clearI);
            return;
        };
        speedX *= 0.8;

        if (Math.abs(speedX) <= 1.5) {
            speedX = 0;
            clearInterval(clearI);
        };

        for (var i = 0; i < lottery.options.particles.length; i++) {
          lottery.options.particles[i].velocity = new THREE.Vector3(speedX, -10, 0);
        }
    }, 100);
  }

  lottery.loop = function () {
    for (var i = 0; i < lottery.options.particles.length; i++) {
      var particle = lottery.options.particles[i];
      particle.updatePhysics();

      with (particle.position) {
          if ((y < -1000) && lottery.options.starSnow) { y += 2000; }

          if (x > 1000) x -= 2000;
          else if (x < -1000) x += 2000;
          if (z > 1000) z -= 2000;
          else if (z < -1000) z += 2000;
      }
    }

    camera.lookAt(scene.position);

    renderer.render(scene, camera);
  }
    if (!win.dyPlugins) {
        win.dyPlugins = {};
    }
  win.dyPlugins.Lottery = lottery;
}(window);