!(function(win) {
    var com = {};

    /*
    * com.option = {
        domId: "",  //需要渲染的domId 需要到id标识[#]或者class标识[.]
        fixed: false,  //是否fixed浮动定位
        title: "默认标题", //头部名称  默认取页面的title标签内容
        isHistory: true, //点击返回箭头是否 使用history  window.history.go(-1);
        jumpCallback: false // 点击返回箭头回调  自定义跳转
      };
    */
    com.option = {
        domId: "",
        bgColor: "",
        zIndex:0,
        fixed: false,
        isApp: true,
        title: "默认标题",
        isHistory: true,
        jumpCallback: false
    };

    com.init = function(option) {
        if (option) {
            com.option.domId = option.domId;
            com.option.fixed = option.fixed ? true : false;
            com.option.isHistory = option.isHistory ? true : false;
            com.option.isApp = option.isApp;
            com.option.title = option.title ? option.title : $("title").text();
            com.option.bgColor = option.bgColor ? option.bgColor : "";
            com.option.zIndex = option.zIndex ? option.zIndex : 0;

            com.option.jumpCallback = option.jumpCallback;
            if (com.option.isApp) {
                //在微信下默认删除头部
                let ua = window.navigator.userAgent.toLowerCase();
                if (ua.match(/MicroMessenger/i) == "micromessenger") {
                    $(com.option.domId).remove();
                } else {
                    com.htmlAppInit();
                }
            } else {
                com.htmlPcInit();
            }
        } else {
            console.log("你的option不存在");
        }
    };
    //app的初始化
    com.htmlAppInit = function() {
        var fixedHtml = "";
        var fixedHtmlHeight = "";
        if (com.option.fixed) {
            //浮动的情况下 需要增加高度
            fixedHtml = "dy-header-fixed";
            fixedHtmlHeight = '<div class="dy-wrapper-header-placeholder"></div>';
        }
        var bgStyle = ' style="';
        if (com.option.bgColor && com.option.bgColor.length == 7) {
            bgStyle += 'background:' + com.option.bgColor + '; ';
        }
        if(com.option.zIndex){
            bgStyle += 'z-index:' + com.option.zIndex + '; ';
        }
        bgStyle += '" ';
        var headerHtml =
            '<div class="dy-wrapper-header ' +
            fixedHtml +
            '" ' +
            bgStyle +
            ">" +
            '<div class="f-cb">' +
            '<div class="f-fl dy-f-tal">' +
            '<div class="dy-wrapper-header-callback" ></div>' +
            "</div>" +
            '<div class="f-fl dy-f-pl5 dy-f-pr5">' +
            '<span id="dyHeaderText" class="dy-wrapper-header-text">' +
            com.option.title +
            "</span>" +
            "</div>" +
            '<div class="f-fr dy-f-pl5 dy-f-pr0 f-fs12">&nbsp;</div>' +
            "</div>" +
            "</div>" +
            fixedHtmlHeight;

        $(com.option.domId).html(headerHtml);
        $(com.option.domId)
            .find(".dy-wrapper-header-callback")
            .off("click")
            .on("click", function() {
                if (com.option.isHistory) {
                    window.history.go(-1);
                } else {
                    if (com.option.jumpCallback) {
                        com.option.jumpCallback();
                    }
                }
            });
    };
    com.htmlPcInit = function() {
        console.log("pc没有实现");
    };
    if (!win.dyPlugins) {
        win.dyPlugins = {};
    }
    dyPlugins.Header = com;
})(window);
