!(function(win) {
  var com = {};
  /*ajax请求,
  * 参数说明:
      options = {
        url: "http://www.baidu.com",  //请求url
        type: "get|post|put",         //请求类型 默认get
        async: true|false,            //异步|同步加载 默认异步
        dataType: "json|jsonp",       //数据类型      默认json
        data:{},                      //参数 json格式
        callback:function(type,data){      //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据

        }
      }
  * 调用方式：byCom.ajaxRequest(options);
  */
  com.ajaxRequest = function(options) {
    //数据传输类型 默认 json格式
    var ajaxdatatype = options.dataType || "json";
    //默认 异步加载
    var async_type = options.async_type || true;
    //请求方式 默认get请求
    var type = options.type || "get";
    //请求参数 json格式
    var dataJson = options.data || {};

    $.ajax({
      url: options.url,
      type: type,
      async: async_type,
      dataType: ajaxdatatype,
      contentType: "application/json;charset=UTF-8",
      headers: {},
      data: dataJson,
      success: function(result, e, xrl) {
        if (result) {
          options.callback(1, result);
        } else {
          options.callback(2, result);
        }
      },
      complete: function(XMLHttpRequest, TS) {
        //完成响应
        if (XMLHttpRequest.status == 401 || XMLHttpRequest.status == 404) {
          options.callback(0, "401或者404");
        } else if (XMLHttpRequest.status == 200) {
        }
      },
      error: function(XMLHttpRequest, textStatus, errorThrown) {
        options.callback(0, errorThrown);
      }
    });
  };
  /*
   * 对字符串为NULL 或者 underfined做处理 0不做处理
   */
  com.stringFiltedNull = function(str) {
    var tmp = str;
    if (tmp == 0) {
      tmp = str;
    } else if (!tmp) {
      tmp = "";
    }
    if (tmp == "undefined" || tmp == "null") {
      tmp = "";
    }
    return tmp;
  };

  /*
   * 返回顶部
   */
  com.callbackTop = function(baseUrl, type) {
    if (!baseUrl) {
      return false;
    }
    if (!$(".callback-top") || $(".callback-top").length == 0) {
      var topHtml =
        '<div class="callback-top">' +
        '        <img src="' +
        baseUrl +
        '/common/callbackTop.png" width="100%">' +
        "    </div>";
      $("body").append(topHtml);
    }
    if (type) {
      $(".callback-top").show();
    }
    $(".callback-top")
      .off("click")
      .on("click", function() {
        document.documentElement.scrollTop = 0;
        document.body.scrollTop = 0;
      });
  };
  /*
   * textarea转化String 换行符 \r\n \n \r \s
   */
  com.textareaToString = function(areaStr) {
    var valStr = areaStr;
    valStr = valStr.replace(/\r\n/g, "<br/>"); //IE9、FF、chrome
    valStr = valStr.replace(/\n/g, "<br/>"); //IE7-8
    valStr = valStr.replace(/\r/g, "<br/>"); //IE7-8
    valStr = valStr.replace(/\s/g, " "); //空格处理
    return valStr;
  };
  /*
   * 验证是否为空
   * 验证规则 去除前后空格的情况下 验证str是否为空
   * 返回值 true 不为空  false 为空
   */
  com.isNotEmpty = function(str) {
    if (str && $.trim(str).length > 0) {
      return true;
    } else {
      return false;
    }
  };
  /*
   * 验证是数字
   * 验证规则 去除前后空格的情况下 验证str是数字
   * 返回值 true 数字 false 不是数字
   */
  com.isNumber = function(str) {
    if (/^\d{1,}$/.test(str)) {
      return true;
    } else {
      return false;
    }
  };
  /*
   * 验证是手机号
   * 验证规则 去除前后空格的情况下 验证str是数字
   * 返回值 true 数字 false 不是数字
   */
  com.isPhoneNumber = function(str) {
    if (/^[1][3,4,5,6,7,8,9]{1}[0-9]{9}$/.test(str)) {
      return true;
    } else {
      return false;
    }
  };

  /**
   * 获取本周、本季度、本月、上月的开端日期、停止日期
   */
  var now = new Date(); //当前日期
  var nowDayOfWeek = now.getDay(); //今天本周的第几天
  var nowDay = now.getDate(); //当前日
  var nowMonth = now.getMonth(); //当前月
  var nowYear = now.getFullYear(); //当前年
  nowYear += nowYear < 2000 ? 1900 : 0;

  //格局化日期：yyyy-MM-dd
  com.formatDate = function(date) {
    var myyear = date.getFullYear();
    var mymonth = date.getMonth() + 1;
    var myweekday = date.getDate();

    if (mymonth < 10) {
      mymonth = "0" + mymonth;
    }
    if (myweekday < 10) {
      myweekday = "0" + myweekday;
    }
    return myyear + "-" + mymonth + "-" + myweekday;
  };

  //获得某月的天数
  com.getMonthDays = function(myMonth) {
    var monthStartDate = new Date(nowYear, myMonth, 1);
    var monthEndDate = new Date(nowYear, myMonth + 1, 1);
    var days = (monthEndDate - monthStartDate) / (1000 * 60 * 60 * 24);
    return days;
  };

  //获得本季度的开端月份
  com.getQuarterStartMonth = function() {
    var quarterStartMonth = 0;
    if (nowMonth < 3) {
      quarterStartMonth = 0;
    }
    if (2 < nowMonth && nowMonth < 6) {
      quarterStartMonth = 3;
    }
    if (5 < nowMonth && nowMonth < 9) {
      quarterStartMonth = 6;
    }
    if (nowMonth > 8) {
      quarterStartMonth = 9;
    }
    return quarterStartMonth;
  };

  //获得本日的开端日期
  com.getDayStartDate = function() {
    var dayStartDate = new Date(nowYear, nowMonth, nowDay);
    return com.formatDate(dayStartDate);
  };

  //获得本日的停止日期
  com.getDayEndDate = function() {
    var dayEndDate = new Date(nowYear, nowMonth, nowDay);
    return com.formatDate(dayEndDate);
  };

  //获得本周的开端日期
  com.getWeekStartDate = function() {
    var weekStartDate = new Date(nowYear, nowMonth, nowDay - nowDayOfWeek);
    return com.formatDate(weekStartDate);
  };

  //获得本周的停止日期
  com.getWeekEndDate = function() {
    var weekEndDate = new Date(nowYear, nowMonth, nowDay + (6 - nowDayOfWeek));
    return com.formatDate(weekEndDate);
  };

  //获得本月的开端日期
  com.getMonthStartDate = function() {
    var monthStartDate = new Date(nowYear, nowMonth, 1);
    return com.formatDate(monthStartDate);
  };

  //获得本月的停止日期
  com.getMonthEndDate = function() {
    var monthEndDate = new Date(nowYear, nowMonth, com.getMonthDays(nowMonth));
    return com.formatDate(monthEndDate);
  };

  //获得本季度的开端日期
  com.getQuarterStartDate = function() {
    var quarterStartDate = new Date(nowYear, com.getQuarterStartMonth(), 1);
    return com.formatDate(quarterStartDate);
  };

  //或的本季度的停止日期
  com.getQuarterEndDate = function() {
    var quarterEndMonth = com.getQuarterStartMonth() + 2;
    var quarterStartDate = new Date(
      nowYear,
      quarterEndMonth,
      com.getMonthDays(quarterEndMonth)
    );
    return com.formatDate(quarterStartDate);
  };

  //获得本年的开端日期
  com.getYearStartDate = function() {
    var yearStartDate = new Date(nowYear, 0, 1);
    return com.formatDate(yearStartDate);
  };

  //或的本年的停止日期
  com.getYearEndDate = function() {
    var yearEndDate = new Date(nowYear, 11, 31);
    return com.formatDate(yearEndDate);
  };
  /*格式化时间*/
  com.formatterTime = function(timestamp, format) {
      //format:  "yyyy-m-d h:i:s.S","yyyy年mm月dd日 hh:ii:ss"  default: "yyyy-mm-dd hh:ii:ss"
      var obj = parseInt(timestamp);
      var date = new Date(obj);
      var data = {
          "m+": date.getMonth() + 1,                 //月
          "d+": date.getDate(),                    //日
          "h+": date.getHours(),                   //小时
          "i+": date.getMinutes(),                 //分
          "s+": date.getSeconds(),                 //秒
          "q+": Math.floor((date.getMonth() + 3) / 3), //季度
          "S": date.getMilliseconds()             //毫秒
      };
      if (!format) {
          format = "yyyy-mm-dd hh:ii:ss";
      }
      if (/(y+)/.test(format)) {
          // date.getFullYear() + ""  转为字符串
          format = format.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
      }
      for (var k in data) {
          if (new RegExp("(" + k + ")").test(format)) {
              format = format.replace(RegExp.$1, (RegExp.$1.length === 1) ? (data[k]) : (("00" + data[k]).substring(("" + data[k]).length)));
          }
      }
      return format;
  };
    com.getUrlParams = function(name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)"); //构造一个含有目标参数的正则表达式对象
        var r = window.location.search.substr(1).match(reg);  //匹配目标参数
        if (r != null) return decodeURI(r[2]); return null; //返回参数值
    }
  win.dyCom = com;
})(window);
