/**
 * query_bar
 * @param {...Array} data [oneLevelData, twoLevelData, threeLevelData, fourLevelData, fiveLevelData] 可以用数组，也可以用方法
 * @param {Object} options
 * @param {string=} domId 容器Id
 * @param {number} level 选择的层级 1 2 3 4 5 最多支持5个 
 * @param {Function} options.callback 按钮的回调函数
 */

!(function(win) {
    var com = {};
    // 数据模型
    var dataModel = {
        id:'id',
        showValue:'showValue',//按钮显示内容
        uniconName:'uniconName',//未选中时的按钮图标名称
        iconName:'iconName',//已选中时的按钮图标名称
        isSelect:'isSelect',//是否选中【true 选中，false 未选中】
        jumpUrl:'jumpUrl'//按钮点击后的跳转路径
    }

    //设置属性方法
    com.setOption = function(optionTemp) {
      var option = {
        domId: "",
        level:"0",
        iconPath:'',//按钮图标基础路径
        callback: null
      };
      option.domId = optionTemp.domId;
      if (optionTemp.level > 5) {
        throw new RangeError('最大支持5个按钮');
        return;
      }
      option.level = optionTemp.level ? optionTemp.level : "0";
      option.iconPath = optionTemp.iconPath ? optionTemp.iconPath : "";
      option.callback = optionTemp.callback ? optionTemp.callback : null;
      return option;
    };


    //初始化方法
    com.init = function(optionData, data) {
        //设置option
        var option = com.setOption(optionData);
        com.setHtml(option, data);
        com.eventFunction(option);
    };
    //设置html
    com.setHtml = function(option, data) {

        //计算每列的宽
        var width = parseFloat(100/parseInt(option.level)).toFixed(4);
        var itemWidth = 'style="width:'+width+'%"';

        //判断data 是否为空
        if (data.length === 0) {
            throw new TypeError('数据必须非空数组!');
            return;
        }
        var tabObjs = data;

        var initHtml = '';
        initHtml += '<ul id="bottomBut">';
        var iconUrl = '';
        $(tabObjs).each(function(i,obj){
            initHtml += '<li ';
            if(obj.isSelect){
                initHtml += 'class="active" ';
                iconUrl = option.iconPath + obj.iconName;
            }else{
                iconUrl = option.iconPath + obj.uniconName;
            }
            initHtml += itemWidth +' data-id="'+obj.id+'" '+ 
                'data-url="'+obj.jumpUrl+'"'+
                'data-unicon="'+obj.uniconName+'" '+
                'data-icon="'+obj.iconName+'">'+
                '<div class="icon_container"><img src="'+iconUrl+'" class="icon-img"/></div>'+
                '<div class="text-info">'+obj.showValue+'</div>'+
            '</li>';
        });
        initHtml += '</ul>';
        $(option.domId).html(initHtml);

    };

    //设置点击事件
    com.eventFunction = function(option) {
        // 切换按钮
        $('#bottomBut li').off('click').on('click',function(){
            if(!$(this).hasClass('active')){
                var oldActiveBut = $(this).parent().find('li.active');
                // 替换上一个选中按钮的图片
                var oldpath = option.iconPath+oldActiveBut.data('unicon');
                oldActiveBut.children().children().attr('src',oldpath); 
                // 移除上一个选中按钮样式
                oldActiveBut.removeClass('active');

                // 添加新选中按钮图片
                var newpath = option.iconPath+$(this).data('icon');
                $(this).children().children().attr('src',newpath); 
                //添加新选中按钮样式
                $(this).addClass('active');
            }

            var id = $(this).data('id');
            var jumpUrl = $(this).data('url');

            if (option.callback) {
                option.callback({"id":id,"jumpUrl":jumpUrl});
            }
        });
    };

    
      if(!win.dyPlugins){
          win.dyPlugins = {};
      }
      dyPlugins.bottomBarModel = com;
  })(window);
  