<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>生产制卡管理</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--下拉框 样式--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">

</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul id="operationBut">
            <li>
                <a href="javascript:void(0);" onclick="produceApply()">制卡申请</a>
            </li>
            <li>
                <a href="javascript:void(0);" onclick="produceImport()">制卡导入</a>
            </li>
        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
            <span class="header-name">
              <i class="iconfont iconqiapian"></i>
              <span class="name-text">生产制卡管理</span>
            </span>
            <div class="header-option f-pt10"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <div class="main-block">
            <div class="m-table-list">
                <div class="m-search-list">
                    <div class="search-form">
                        <div class="row">
                            <div class="col-md-3 hidden-sm"></div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input placeholder="请输入卡类型名称" id="typeName">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input placeholder="请输入子卡类型名称" id="childtypeName">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item" id="selectStatus"></div>
                            </div>
                        </div>
                    </div>
                    <div class="search-btn">
                        <button type="button" class="u-btn u-btn-primary u-btn-sm" id="searchList">
                            查询
                        </button>
                    </div>
                </div>

                <!--会员卡 table列表 start-->
                <section id="list_contaniner" class="content f-mt20">
                    <table>
                        <thead>
                        <tr>
                            <th class="m-table-col-2">No.</th>
                            <th class="m-table-col-4">卡类型</th>
                            <th class="m-table-col-4">子卡类型</th>
                            <th class="m-table-col-4">是否是虚拟卡</th>
                            <th class="m-table-col-4">生产数量</th>
                            <th class="m-table-col-4">生产时间</th>
                            <th class="m-table-col-2">状态</th>
                        </tr>
                        </thead>
                        <tbody id="mCardProduces">

                        </tbody>
                    </table>
                </section>
                <!--会员卡 table列表 end-->
            </div>
            <!--分页开始-->
            <div id="producesPages" class="f-mt20"></div>
            <!--分页结束-->
        </div>
    </section>
    <!--内容区结束-->
</div>

<%--table模板--%>
<table id="templateTable" class="f-dn">
    <tr>
        <td><div class="f-tac label1 " ></div></td>
        <td><div class="f-tac label2 clickQuery f-csp"></div></td>
        <td><div class="f-tac label3"></div></td>
        <td><div class="f-tac label4"></div></td>
        <td><div class="f-tac label5"></div></td>
        <td><div class="f-tac label6"></div></td>
        <td><div class="f-tac label7"></div></td>
    </tr>
</table>

<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>

<%--<!--js引入私有 下拉选择组件-->--%>
<script type="text/javascript" charset="utf-8" src="${static_plugins}/select/pc/dist/js/select.js"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>


<script>
    /*初始化分页信息*/
    var page = {
        currPage:0,
        pageSize:10,
    };
    /*是否是虚拟卡*/
    var isVirtualCardArray = [
        {
            'value':'0',
            'label':'否'
        }, {
            'value': '1',
            'label': '是'
        }
    ];
    /*状态*/
    var statusArray = [
        {
            'value':'0',
            'label':'失败'
        }, {
            'value': '1',
            'label': '成功'
        }
    ];


    /*1.初始化*/
    $().ready(function(){
        /*状态下拉框*/
        selectStatus();

        //查询当前用户所属客户实体的生产记录
        queryMCardProducesOfCustomer();
    });
    //选择状态
    function selectStatus() {
        var option = {
            domId: "#selectStatus",
            selectName: "状态",
            keyName: "label",
            valueName: "value",
            selectedValue: ""
        };
        option.callback = function (selectObj) {

        };
        dyPlugins.selectModel.init(option, statusArray);
    }



    /*获取生产记录列表ajax需要的参数*/
    function getMCardProducesParams(){
        var paramsStr = '?';
        var paramsJson = [
            'page='+page.currPage,
            'size='+page.pageSize
        ];
        /*卡类型*/
        var typeName = $('#typeName').val();
        if(typeName){
            paramsJson.push('typeName='+typeName);
        }
        /*子卡类型*/
        var childtypeName = $('#childtypeName').val();
        if(childtypeName){
            paramsJson.push('childtypeName='+childtypeName);
        }
        /*生产记录状态*/
        var selectStatus = $('#selectStatus select').val();
        if(selectStatus){
            paramsJson.push('status='+selectStatus);
        }

        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    //查询当前用户所属客户实体的生产记录
    function queryMCardProducesOfCustomer() {
        var producesParams = getMCardProducesParams();
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/produces'+producesParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 渲染生产记录列表
                setMCardProducesData(data);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //渲染生产记录列表
    function setMCardProducesData(data) {
        //清空旧数据
        $("#mCardProduces").html('');

        if(data && data.result){
            var objs = data.result;
            $.each(objs, function (i, obj) {
                /*克隆table 模板*/
                var trClone = $('#templateTable tr').clone();
                /*赋值*/
                trClone.find('.label1').text(i+1);
                trClone.find('.label2').text((obj.typeName?obj.typeName:''));
                trClone.find('.clickQuery').data('produceid',obj.produceId);
                trClone.find('.label3').text((obj.childtypeName?obj.childtypeName:''));

                var isVirtualCard = '';
                if(dyCom.stringFiltedNull(obj.isVirtualCard)){
                    isVirtualCard = isVirtualCardArray.find(x => x.value === obj.isVirtualCard).label;
                }
                trClone.find('.label4').html(isVirtualCard);
                trClone.find('.label5').html((obj.produceAmount?obj.produceAmount:''));
                trClone.find('.label6').html((obj.produceTime?obj.produceTime:''));

                var status = '';
                if(dyCom.stringFiltedNull(obj.status)){
                    status = statusArray.find(x => x.value === obj.status).label;
                }
                trClone.find('.label7').html(status);

                /*追加HTML*/
                $("#mCardProduces").append(trClone);
            });

            //查看生产记录详情
            $('#mCardProduces .clickQuery').off('click').on('click',function () {
                var produceid = $(this).data('produceid');
                getProduceDetail(produceid);
            });

        }
        //分页
        dyPlugins.Page.init("producesPages",data.totalPage,data.currPage,data.pageSize,data.totalRows,function(pageData){
            //页码+1
            page.currPage = pageData.curr;
            queryMCardProducesOfCustomer();
        });
    }
    /*查看生产记录详情*/
    function getProduceDetail(produceId) {
        window.location.href = "${ctx}/produces/"+encodeURI(produceId);
    }

    //生成制卡文件
    function produceApply() {
        window.location.href = "${ctx}/produces/produce/apply";
    }
    //制卡导入
    function produceImport() {
        window.location.href = "${ctx}/produces/produce/import";
    }

</script>
</body>
</html>
