<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>制卡记录详细信息</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>

</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>
            <!--TODO-->
        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icondescribe"></i>
                  <span class="name-text">制卡记录详细信息</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <div class="main-block">
            <div class="m-table-detail m-form-list">
                <section class="content">
                <table>
                    <tbody>
                    <tr>
                        <th class="m-table-col-4">卡类型</th>
                        <td class="m-table-col-8 td-edit">
                            <div class="item-form" id="typeName"></div>
                        </td>
                        <th class="m-table-col-4">子卡类型</th>
                        <td class="m-table-col-8 td-edit">
                            <div class="item-form" id="childtypeName"></div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">是否为虚拟卡</th>
                        <td class="m-table-col-8 td-edit">
                            <div class="item-form" id="isVirtualCard"></div>
                        </td>
                        <th class="m-table-col-4">生产数量</th>
                        <td class="m-table-col-8 td-edit">
                            <div class="item-form" id="produceAmount"></div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">制卡文件</th>
                        <td class="m-table-col-20 td-edit" colspan="3">
                            <div id="files" class="item-form f-ib" style="width:97%;">
                                <span class="f-ib s-bg-default f-pA5 f-mA5" id="fileUrl"></span>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
                </section>
            </div>
        </div>

    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>


<script>
    /** 是否为虚拟卡*/
    var isVirtualCard = [
        {
            value: '1',
            label: '是'
        },
        {
            value: '0',
            label: '否'
        }
    ];

    var recordId = '${recordId}';

    /*1.初始化*/
    $().ready(function(){
        getMCardProduce();

    });
    /* 2.业务方法  */
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        // console.log(paramsStr);
        return paramsStr;
    }
    //生产记录基本信息
    function getMCardProduce(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/produces/'+recordId+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setProduceInfoData(data.result);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充基本信息的数据
    function setProduceInfoData(info) {
        if (info) {
            //遍历实体对象下的属性
            for (var key in info) {
                var tempKey = dyCom.stringFiltedNull(info[key]);
                $('#'+key).html(tempKey);
            }
            //处理枚举值信息
            //虚拟卡
            var virtualCard = '';
            if(dyCom.stringFiltedNull(info.isVirtualCard)){
                virtualCard = isVirtualCard.find(x => x.value === info.isVirtualCard).label
            }
            $('#isVirtualCard').html(virtualCard);

        }
    }
</script>
</body>
</html>
