<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>制卡导入</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--下拉框 样式--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">
    <style type="text/css">
        .m-form-list .item-form {
            width:100%;
        }
    </style>
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul></ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icondaoru"></i>
                  <span class="name-text">制卡导入</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <div class="main-block">
            <div id="formValidate" class="m-table-detail m-form-list">
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>卡类型</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <div class="m-select required" id="selectCardType" data-datatype="*"></div>
                                </div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>子卡类型</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <div class="m-select required" id="selectChildCardType" data-datatype="*"></div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>是否为虚拟卡</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <div class="m-select required" id="selectIsVirtualCard"  data-datatype="*"></div>
                                </div>
                            </td>
                            <th class="m-table-col-4"><span class="label-required"></span>生产数量</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form">
                                    <input type="text" placeholder="请填写制卡文件中卡号的数量" id="produceAmount"  data-datatype="*" class="required">
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4"><span class="label-required"></span>制卡文件</th>
                            <td class="m-table-col-20 td-edit" colspan="3">
                                <div id="files" class="item-form f-ib" style="width:97%;">
                                    <span id="files_msg" class="f-mt10 s-c-999999 f-ib">*虚拟卡的首列内容为卡号；实体卡的首列内容为卡号，第二列内容为卡的物理ID。</span>
                                </div>
                                <div id="uploadFilesBut" class="f-ib f-fr f-mt5 f-csp">
                                    <span class="iconfont iconjiahao s-c-primary f-fs22"></span>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
            </div>
        </div>
        <!--业务模块结束-->
        <div class="u-btn-fixed-placeholder"></div>
        <div class="f-tac u-btn-fixed-b24">
            <button type="button" class="u-btn u-btn-default" id="cancalBut">
                取消
            </button>
            <button id="submitBut" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
                确定
            </button>
        </div>
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<%--<!--js引入私有 下拉选择组件-->--%>
<script type="text/javascript" charset="utf-8" src="${static_plugins}/select/pc/dist/js/select.js"></script>
<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>

<script>
    /*是否是虚拟卡*/
    var isVirtualCardArray = [
        {
            'value':'0',
            'label':'否'
        }, {
            'value': '1',
            'label': '是'
        }
    ];
    /*卡类型*/
    var cardTypeArray = [];
    /*子卡类型*/
    var childCardTypeArray = [];

    /*附件上传*/
    var docList=[];
    var upUrl = baseResourcePath+'/commonsvr/docs/uploadMulti?token=' + token;
    var uploadOptions = {
        url: upUrl,
        domId: '#uploadFilesBut',
        callback:function(type,data){      //回调  type=1 成功  type=0 请求失败 data 返回数据
            if (type == 1) {
                if (type == 1 && '10000' == data.status && data.result.length > 0) {
                    for (var i = 0, len = data.result.length; i < len; i++) {
                        var docInfo = data.result[i];
                        var htmlStr = '<span class="f-ib s-bg-default f-pA5 f-mA5">' +
                            '<input type="hidden" value="' + docInfo.docId + '">' +
                            docInfo.docName+'</span>';

                        $('#files').append(htmlStr);
                        docList.push({"docId":docInfo.docId,"status":'1'});
                    }

                    /*清空附件的提醒文字*/
                    $('#files_msg').hide();
                }else {
                    //上传失败，打印错误信息；
                    layer.msg(data);
                }

            } else if (type == 0) {
                //上传失败，打印错误信息；
                layer.msg(data);
            }
        }
    };

    /*1.初始化*/
    $().ready(function(){
        /*是否是虚拟卡 下拉框*/
        selectIsVirtualCard();

        /*查询当前用户所属客户实体发行的卡类型*/
        queryMCardTypeOfMineAsSupplier();

        //上传附件
        $("#uploadFilesBut").off("click").on("click", function() {
            dyCom.ajaxUpload(uploadOptions);
        });

        //取消
        $("#cancalBut").off("click").on("click", function() {
            history.go(-1);
        });

        //点击提交
        $('#submitBut').off('click').on('click', function () {
            createSubmit();
        })
    });
    /* 2.业务方法  */

    //下拉选择是否是虚拟卡
    function selectIsVirtualCard() {
        var option = {
            domId: "#selectIsVirtualCard",
            selectName: "是否为虚拟卡",
            keyName: "label",
            valueName: "value",
            selectedValue: ""
        };
        option.callback = function (selectObj) {

        };
        dyPlugins.selectModel.init(option, isVirtualCardArray);
    }

    //下拉选择卡类型
    function selectCardType() {
        var option = {
            domId: "#selectCardType",
            selectName: "卡类型",
            keyName: "typeName",
            valueName: "typeId",
            selectedValue: ""
        };
        option.callback = function (selectObj) {
            var cardTypeId = selectObj.value;

            /*获取指定卡类型下的子卡类型列表*/
            queryMCardChildTypeOfCardType(cardTypeId);
        };
        dyPlugins.selectModel.init(option, cardTypeArray);
    }

    //下拉选择子卡类型
    function selectChildCardType() {
        var option = {
            domId: "#selectChildCardType",
            selectName: "卡类型",
            keyName: "childtypeName",
            valueName: "childtypeId",
            selectedValue: ""
        };
        option.callback = function (selectObj) {};
        dyPlugins.selectModel.init(option, childCardTypeArray);
    }


    /*获取发行的卡类型ajax需要的参数*/
    function getMCardTypesParams(){
        var paramsStr = '?';
        var paramsJson = [];
        /*卡类型*/
        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    /*查询当前用户所属客户实体发行的卡类型*/
    function queryMCardTypeOfMineAsSupplier(){
        var typesParams = getMCardTypesParams();
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/sp/mine/mcardtypes'+typesParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                if(data && data.result){
                    cardTypeArray = data.result;
                    /*初始化 卡类型下拉框*/
                    selectCardType();
                    /*初始化 子卡类型下拉框*/
                    selectChildCardType();
                }
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }


    /*获取发行的子卡类型ajax需要的参数*/
    function getMCardChildTypesParams(){
        var paramsStr = '?';
        var paramsJson = [];
        /*卡类型*/
        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    /*获取指定卡类型下的子卡类型列表*/
    function queryMCardChildTypeOfCardType(tid){
        var typesParams = getMCardChildTypesParams();
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/'+tid+'/childtypes'+typesParams)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                if(data && data.result){
                    childCardTypeArray = data.result;

                }else {
                    childCardTypeArray = [];
                    /*TODO 生产制卡 是否必须指定子卡类型？？？暂定必须*/
                    layer.msg('该卡类型暂无子卡类型，请切换卡类型');
                }
            }else{
                layer.msg(data);
                childCardTypeArray = [];
            }

            selectChildCardType();
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    /*ajax需要的参数*/
    function ajaxPostCreateParams() {
        var obj = {};
        var cardTypeId = $('#selectCardType select').val();
        var childCardTypeId = $('#selectChildCardType select').val();
        var isVirtualCard = $('#selectIsVirtualCard select').val();
        var produceAmount = $('#produceAmount').val();
        /*卡类型*/
        if(cardTypeId){
            obj.typeId = cardTypeId;
        }
        /*子卡类型*/
        if(childCardTypeId){
            obj.childtypeId = childCardTypeId;
        }
        /*是否为虚拟卡*/
        if(isVirtualCard){
            obj.isVirtualCard = isVirtualCard;
        }
        /*生产数量*/
        if(produceAmount){
            obj.produceAmount = produceAmount;
        }

        /*附件集合*/
        $('#files .item-form>input').each(function (i,n) {
            var doc = {};
            var value = $(n).val();
            if(value){
                doc.docId = value;
            }
            docList.push(doc);
        });

        var formData = {
            "appData": obj,
            "docList": docList
        };

        return formData;
    }
    /**/
    function createSubmit() {
        var clickFlag = $("#submitBut").data("click");
        if (!clickFlag) {
            return false;
        }
        //提交之前验证
        $("#submitBut").data("click", false); //设置不可点击提交按钮
        //提交验证 errTime 返回 0的时候 说明验证都通过 >0 说明 有errTime处有信息问题
        var errTime = dyPlugins.Validate.checkAll();
        if (errTime > 0) {
            $("#submitBut").data("click", true); //设置可以点击
        }else{
            var params = JSON.stringify(ajaxPostCreateParams());

            var optionsAjax = {
                url: '${ctx}/ajax/post?restPath='+encodeURIComponent('/mcardsvr/produces/import?token=${sessionScope.token}'),  //请求url
                type: "post",         //请求类型 默认get
                async: true,            //异步|同步加载 默认异步
                dataType: "json",      //数据类型      默认json
                data:params
            }
            optionsAjax.callback = function(type,data){
                //返回结果处理
                if(type==1){
                    layer.msg('生产制卡成功！');
                    window.location.href = "${ctx}/produces/produce/import"
                }else{
                    layer.msg(data?data:'生产制卡失败！');
                }
            }
            dyCom.ajaxRequest(optionsAjax);
        }
    }
</script>
</body>
</html>
