<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>会员卡管理-卡类型列表</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">
    <!--js引入私有 表格样式-->
    <link href="${static_css}/themes/content/pc/table.css" rel="stylesheet">
    <!--引入私有 卡类型页面样式-->
    <link rel="stylesheet" href="${ctx}/static_new_new/css/view/cardType/cardTypeStyle.css" />
</head>

<body>
<div class="wrapper" id="loading">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>
        </ul>
    </nav>
    <!--工具栏结束-->
    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
            <span class="header-name">
              <i class="iconfont icondingdan"></i>
              <span class="name-text">运营商下卡类型列表</span>
            </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->
    <!--内容区开始-->
    <div class="main-content" >
        <div class="col-xs-12 swlDetail">
            <div class="m-table-list">
                <!--查询开始-->
                <div class="main-block">
                    <div class="m-search-list">
                        <div class="search-form">
                            <div class="row">
                                <div class="col-md-6 hidden-sm"></div>
                                <div class="col-md-3 col-sm-6 col-xs-12">
                                    <div class="form-item">
                                        <input placeholder="请输入会员卡类型名称" id="cardTypeName">
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6 col-xs-12">
                                    <div class="form-item">
                                        <div id="selectStatus"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="search-btn">
                            <button type="button" class="u-btn u-btn-primary u-btn-sm" id="searchList">
                                查询
                            </button>
                        </div>
                    </div>
                </div>
                <!--查询结束-->
                <!--数据表格渲染区开始-->
                <section class="content f-mt20">
                    <table>
                        <thead>
                        <tr>
                            <th width="4%">No.</th>
                            <th width="10%">图片</th>
                            <th width="10%">名称</th>
                            <th width="10%">价格</th>
                            <th width="15%">简介</th>
                            <th width="10%">发卡机构</th>
                            <th width="10%">状态</th>
                        </tr>
                        </thead>
                        <tbody id="cardTypeList"></tbody>
                    </table>
                </section>
                <!--数据表格渲染区结束-->
                <!--分页开始-->
                <div id="pagesList" class="f-mt20"></div>
                <!--分页结束-->
            </div>
        </div>
    </div>
</div>

<%--table模板--%>
<table id="templateTable" class="f-dn">
    <tr>
        <td><div class="f-tac label1 " ></div></td>
        <td><div class="f-tac label2 clickQuery f-csp"></div></td>
        <td><div class="f-tac label3"></div></td>
        <td><div class="f-tac label4"></div></td>
        <td><div class="f-tac label5"></div></td>
        <td><div class="f-tac label6"></div></td>
        <td><div class="f-tac label7"></div></td>
    </tr>
</table>

<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>
<!--js引入私有 下拉选择组件-->
<script src="${static_plugins}/select/pc/dist/js/select.js"></script>
<!--引入私有  卡类型状态-->
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<!--引入私有  卡类型状态处理-->
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>
<!--引入私有  卡类型数据处理-->
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeSetData_pc.js"></script>
<script type="text/javascript">
    /*请求路径*/
    var getUrl='/mcardsvr/mcardtypes/operator/mine/mcardtypes';
    /*跳转类型-卡类型详情*/
    var jumpType = 'detail';

    $().ready(function(){
        //加载列表数据
        getDataList(pageIndex,getUrl);
        //初始化状态下拉筛选
        selectStatus();
    });

</script>
</body>
</html>
