<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>会员卡管理-卡类型列表</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp" %>
    <%--引入私有css文件--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">
    <!--js引入私有 表格样式-->
    <link href="${static_css}/themes/content/pc/table.css" rel="stylesheet">
    <!--引入私有 卡类型页面样式-->
    <link rel="stylesheet" href="${ctx}/static_new_new/css/view/cardType/cardTypeStyle.css"/>
</head>

<body id="loading">
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option f-cb">
        <div class="f-ml10 f-mt5 f-fl">
            <button type="button" class="u-btn u-btn-primary u-btn-sm" onclick="cardCreate('${mcId}')">创建卡类型
            </button>
        </div>
    </nav>
    <!--工具栏结束-->
    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icondingdan"></i>
                  <span class="name-text">卡类型管理</span>
                </span>
            <div class="header-option">
                <a href="javascript:" class="iconfont iconliebiao1 f-mr10" id="list_icon"></a>
                <a href="javascript:" id="title_icon" class="iconfont iconliebiao2 active"></a>
            </div>
        </div>
    </header>
    <!--标题栏结束-->
    <!--列表内容-->
    <div class="main-content">
        <div class="col-xs-12 swlDetail">
                <div class="main-block">
                    <div class="m-search-list">
                        <div class="search-form">
                            <div class="row">
                                <div class="col-md-6 hidden-sm"></div>
                                <div class="col-md-3 col-sm-6 col-xs-12">
                                    <div class="form-item">
                                        <input placeholder="请输入会员卡类型名称" id="cardTypeName">
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6 col-xs-12">
                                    <div class="form-item">
                                        <div id="selectStatus"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="search-btn">
                            <button type="button" class="u-btn u-btn-primary u-btn-sm" id="searchList">
                                查询
                            </button>
                        </div>
                    </div>
                </div>
                <!--tab内容开始-->
                <div  class="tab-content f-mt20">
                    <!-- 会员卡 信息块列表 -->
                    <ul class="f-cb cardMangeList" id="cardTypeList"></ul>
                </div>
                <!--分页开始-->
                <div id="pagesList" class="f-mt20"></div>
                <!--分页结束-->
                <!--tab内容结束-->
            </div>
    </div>
</div>
</body>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp" %>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp" %>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8" src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8" src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>
<%--<!--js引入私有 下拉选择组件-->--%>
<script src="${static_plugins}/select/pc/dist/js/select.js"></script>
<%--引入私有  卡类型状态--%>
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<%--引入私有  卡类型状态处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>
<%--引入私有  卡类型数据处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeSetData_pc.js"></script>

<script>
    /*商铺Id*/
    var mcId = '${mcId}';
    //请求路径
    var getUrl='/mcardsvr/mcardtypes/mc/'+mcId+'/mcardtypes';

    //跳往基本信息的标识
    var urlFlag = '';

    $().ready(function(){
        //加载列表数据
        getDataList(pageIndex,getUrl);
        //初始化状态下拉筛选
        selectStatus();
    });

    /*点击创建卡类型-跳转页面*/
    function cardCreate(mcId) {
        window.location.href = "${ctx}/mcardtypes/create?mcId="+mcId;
    }

    /*点击板式跳转页面*/
    $("#list_icon").click(function(){
        window.location.href = "${ctx}/mcardtypes/mc/${mcId}/mcardtypes";
    });
    $("#title_icon").click(function(){
        window.location.href = "${ctx}/mcardtypes/mc/${mcId}/mcardtypes/manage";
    });

    /*会员卡类型信息管理*/
    $('#cardTypeList').on('click',"li",function(){
        var typeId = $(this).data('id');
         window.location.href = '${ctx}/mcardtypes/'+encodeURI(typeId)+'/manage';
    })
</script>
</html>
