<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>适用商户</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp" %>

</head>
<body>
<div class="wrapper" id="loading">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul></ul>
    </nav>
    <!--工具栏结束-->
    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconqiapian"></i>
                  <span class="name-text">适用商户</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容-->
    <section id="M-Content" class="wrapper-main f-pA0">
        <div class="m-table-list">
            <div class="m-search-list">
                <div class="search-form">
                    <div class="row">
                        <div class="col-md-3 col-sm-6 col-xs-12 hidden-xs"></div>
                        <div class="col-md-3 col-sm-6 col-xs-12 hidden-xs"></div>
                        <div class="col-md-3 col-sm-6 col-xs-12 hidden-xs"></div>
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="form-item">
                                <input id="mcName" placeholder="请输入商铺名称">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="search-btn">
                    <button id="searchBut" type="button" class="u-btn u-btn-primary u-btn-sm">
                        查询
                    </button>
                </div>
            </div>
            <section class="content f-mt20">
                <table>
                    <thead>
                    <tr>
                        <th class="m-table-col-1">No.</th>
                        <th class="m-table-col-4">商户</th>
                        <th class="m-table-col-7">使用规则</th>
                        <th class="m-table-col-8">预约规则</th>
                        <th class="m-table-col-2">备注</th>
                        <th class="m-table-col-2">状态</th>
                    </tr>
                    </thead>
                    <tbody id="cmFreesOfCardType" class="tbodyCenter cardInfoList"></tbody>
                </table>
            </section>
            <!--数据表格渲染区结束-->
        </div>
        <!--分页开始-->
        <div id="cmFreesPages" class="f-mt20"></div>
        <!--分页结束-->
    </section>
</div>

<%--table模板--%>
<table id="templateTable" class="f-dn">
    <tr class="clickQuery f-csp">
        <td><div class="f-tac label1"></div></td>
        <td><div class="f-tac label2">
            <span class="f-db label2_mc"></span>
            <span class="f-db label2_cm"></span>
        </div></td>
        <td><div class="f-tac label3"></div></td>
        <td><span class="f-tac label4"></span></td>
        <td><div class="f-tac label5"></div></td>
        <td><div class="f-tac label6"></div></td>
    </tr>
</table>

<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp" %>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp" %>
<%--引入 枚举常量--%>
<script type="text/javascript" charset="utf-8"  src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<script type="text/javascript" charset="utf-8"  src="${ctx}/static_new_new/js/data/common.js"></script>

<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>

<script>
    //分页
    var pageSize = 10; //每页多少条
    var pageIndex = 0; //当前页

    /*卡类型id*/
    var typeId = dyCom.getUrlPathNameParams(2);
    /*展示方式 【嵌入展示时，隐藏工具栏和标题栏】*/
    var showType = dyCom.getUrlParams('showType');
    /*页面类型 查看or管理*/
    var pageType = dyCom.getUrlParams('pageType');

    $().ready(function(){
        dyCom.setScrollHeight('#M-Content',-90);

        if(showType && showType == 'import'){
            $('.wrapper-option').hide();
            $('.wrapper-header').hide();
        }

        /*查询指定卡类型的适用商户列表*/
        queryCmfreesOfCardtype();
        /*条件查询*/
        $('#searchBut').off('click').on('click',function () {
            queryCmfreesOfCardtype();
        });

    });

    function getParams() {
        var paramsStr = '?';
        var paramsJson = [
            'page='+pageIndex,
            'size='+pageSize
        ];
        var mcName = $('#mcName').val();
        if(mcName){
            paramsJson.push('mcName=' + mcName);
        }
        if (token) {
            paramsJson.push('token=' + token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    function queryCmfreesOfCardtype() {
        var params = getParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/' + typeId +'/cmfrees'+ params)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setCmfreesData(data);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);

    }

    function setCmfreesData(data) {
        /*清理旧数据*/
        $("#cmFreesOfCardType").empty();

        var limitedNumTotal='',limitedNumMonth='',limitedNumDay='';
        var limitedNumTotalTxt='',limitedNumMonthTxt='',limitedNumDayTxt='';

        if(data && data.result) {
            var list = data.result;
            $.each(list, function (i, obj) {
                limitedNumTotal=dyCom.stringFiltedNull(obj.limitedNumTotal);
                limitedNumMonth=dyCom.stringFiltedNull(obj.limitedNumMonth);
                limitedNumDay=dyCom.stringFiltedNull(obj.limitedNumDay);
                limitedNumTotal==0?limitedNumTotalTxt='不限制':limitedNumTotalTxt=limitedNumTotal;
                limitedNumMonth==0?limitedNumMonthTxt='不限制':limitedNumMonthTxt=limitedNumMonth;
                limitedNumDay==0?limitedNumDayTxt='不限制':limitedNumDayTxt=limitedNumDay;

                /*克隆table 模板*/
                var trClone = $('#templateTable tr').clone();
                trClone.data('cmfreeid', obj.cmfreeId);
                /*赋值*/
                trClone.find('.label1').html(Number(i+1));
                trClone.find('.label2_mc').html(dyCom.stringFiltedNull(obj.mcName));
                trClone.find('.label2_cm').html(dyCom.stringFiltedNull(obj.cmName));
                var usage_rules = '';
                usage_rules += '<span class="f-db">可消费总次数：'+limitedNumTotalTxt+'</span>';
                usage_rules += '<span class="f-db">每月可消费次数：'+limitedNumMonthTxt+'</span>';
                usage_rules += '<span class="f-db">每天可消费次数：'+limitedNumDayTxt+'</span>';
                trClone.find('.label3').html(usage_rules);

                var booking_rules = '';
                booking_rules += '<span class="f-db">是否需要预约：'+getValue(bookType,obj.book)+'</span>';
                if(obj.book && obj.book != '0'){
                    booking_rules += '<span class="f-db">预约提前时间：'+dyCom.stringFiltedNull(obj.bookAhead)+getValue(bookAheadUnit,obj.bookAheadUnit)+'</span>';
                    booking_rules += '<span class="f-db">可预约几天内：'+dyCom.stringFiltedNull(obj.bookDuration)+'天</span>';
                    booking_rules += '<span class="f-db">预约是否算使用次数：'+getValue(bookEffectType,dyCom.stringFiltedNull(obj.bookEffective))+'</span>';
                }
                trClone.find('.label4').html(booking_rules);
                trClone.find('.label5').html(dyCom.stringFiltedNull(obj.memo));
                trClone.find('.label6').html(getValue(yearnCardState,dyCom.stringFiltedNull(obj.status)));

                /*追加HTML*/
                $("#cmFreesOfCardType").append(trClone);
            });


        }
        /*初始化分页组件*/
        dyPlugins.Page.init("cmFreesPages",data.totalPage,data.currPage,pageSize,data.totalRows,function(pageData){
            pageIndex = pageData.curr;
            queryCmfreesOfCardtype();
        });

        /*年卡商铺商品设置基本信息页面*/
        $('#cmFreesOfCardType .clickQuery').off('click').on('click',function(){
            var cmfreeid = $(this).data('cmfreeid');
            showcmFreesInfo(cmfreeid);
        });

    }

    /*展示年卡适用商户详情*/
    function showcmFreesInfo(cmfreeid) {

        layer.open({
            id: "selectRepLayer",
            type: 2,
            title: "适用商户",
            shadeClose: false,
            shade: 0.6,
            maxmin: true, //开启最大化最小化按钮
            area: ["90%", "560px"],
            content:ctx+'/mcardtypes/cmfrees/'+encodeURI(cmfreeid)+'?showType='+showType+'&pageType='+pageType+'&token=${sessionScope.token}',
            success: function(ee) {},
            end:function () {
                pageIndex = 0;
                queryCmfreesOfCardtype();
            }
        });
    }

</script>
</body>
</html>
