<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include/include-meta-info.jsp" %>
    <title>适用商户基本信息</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp" %>
    <%--引入私有css文件 自定义选择框--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">

</head>

<body>
<div class="wrapper" id="loading">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul id="operationBut" ></ul>
    </nav>
    <!--工具栏结束-->
    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont"></i>
                  <span class="name-text">适用商户基本信息</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->
    <!--内容-->
    <div class="main-block" id="cmFreesData">
        <div class="m-table-detail m-form-list m-form-nolabel">
            <section class="content f-mt20">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th width="12%">商铺名称：</th>
                        <td>
                            <div class="item-form" id="mcName"></div>
                        </td>
                    </tr>
                    <tr>
                        <th width="12%">商品名称：</th>
                        <td>
                            <div class="item-form" id="cmName"></div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
        <div class="m-table-detail m-form-list m-form-nolabel f-mt10">
            <header class="title"><span>适用规则</span></header>
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th width="12%">可消费总次数：</th>
                        <td colspan="2" class="item-form">
                            <span type="text" class="f-fl f-mr20 f-mt15" id="limitedNumTotal"></span>
                            <span class="f9 f-fl f-mt15">注：0表示不限制</span>
                        </td>
                    </tr>
                    <tr>
                        <th>每月可消费次数：</th>
                        <td colspan="2" class="item-form">
                            <span class="f-fl f-mr20 f-mt15" id="limitedNumMonth"/>
                        </td>
                    </tr>
                    <tr>
                        <th>每天可消费次数：</th>
                        <td colspan="2" class="item-form">
                            <span class="f-fl f-mr20 f-mt15" id="limitedNumDay"></span>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
        <div class="m-table-detail m-form-list m-form-nolabel f-mt10">
                <header class="title"><span>使用预约规则</span></header>
                <section class="content">
                    <table>
                        <tbody class="cardInfoTab m-form-list">
                        <tr>
                            <th width="12%">是否需要预约：</th>
                            <td colspan="2" class="item-form">
                                <span class="f-fl f-mt15" id="isNeedBook"></span>
                            </td>
                        </tr>
                        <tr>
                            <th>预约提前时间：</th>
                            <td colspan="2" class="item-form f-cb">
                                <span class="f-fl f-mr20 f-mt15" id="bookAhead"></span>
                                <span id="bookAheadUnit" class="f-fl f-mt15"></span>
                            </td>
                        </tr>
                        <tr>
                            <th>可预约几天内：</th>
                            <td colspan="2" class="item-form">
                                <span class="f-fl f-mr20 f-mt15" id="bookDuration"></span>
                                <span class="f9 f-fl f-mt15">例如：1表示只能预约今天；7表示可以预约1周内（含今天）</span>
                            </td>
                        </tr>
                        <tr>
                            <th>预约是否算使用次数：</th>
                            <td colspan="2" class="item-form f-cb">
                                <div id="bookEffective" class="f-fl f-mr20 f-mt15"></div>
                                <span class="f9 f-fl f-mt15">注：没有使用预约则不计算次数，使用了则计算次数</span>
                            </td>
                        </tr>
                        <tr>
                            <th>备注：</th>
                            <td colspan="2" class="item-form">
                                <div id="memo" style="width:100%;height: 100px;"></div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
            </div>
    </div>
</div>

</body>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp" %>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp" %>
<!--js引入私有 下拉选择组件-->
<script src="${static_plugins}/select/pc/dist/js/select.js"></script>

<%--引入私有  卡类型状态--%>
<script type="text/javascript" charset="utf-8"  src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<script type="text/javascript" charset="utf-8"  src="${ctx}/static_new_new/js/data/common.js"></script>

<script>
    var cmfreeId = dyCom.getUrlPathNameParams(3);
    /*展示方式 【嵌入展示时，隐藏工具栏和标题栏】*/
    var showType = dyCom.getUrlParams('showType');
    
    $(document).ready(function () {
        if(showType && showType == 'import'){
            $('.wrapper-option').hide();
        }

        getCmfreesInfo();
    });

    function getParams() {
        var paramsStr = '?';
        var paramsJson = [];
        if (token) {
            paramsJson.push('token=' + token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    function getCmfreesInfo() {
        var params = getParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/cmfrees/'+ encodeURI(cmfreeId) + params)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setCmfreesData(data.result);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    function setCmfreesData(obj) {
        var limitedNumTotal='',limitedNumMonth='',limitedNumDay='';
        var limitedNumTotalTxt='',limitedNumMonthTxt='',limitedNumDayTxt='';
        if (obj) {
            //商铺名称
            $("#mcName").html(dyCom.stringFiltedNull(obj.mcName));
            //商品名称
            $("#cmName").html(dyCom.stringFiltedNull(obj.cmName));

            //适用规则
            limitedNumTotal=dyCom.stringFiltedNull(obj.limitedNumTotal);
            limitedNumMonth=dyCom.stringFiltedNull(obj.limitedNumMonth);
            limitedNumDay=dyCom.stringFiltedNull(obj.limitedNumDay);
            limitedNumTotal==0?limitedNumTotalTxt='不限制':limitedNumTotalTxt=limitedNumTotal;
            limitedNumMonth==0?limitedNumMonthTxt='不限制':limitedNumMonthTxt=limitedNumMonth;
            limitedNumDay==0?limitedNumDayTxt='不限制':limitedNumDayTxt=limitedNumDay;
            //可消费总次数
            $("#limitedNumTotal").html(limitedNumTotal);
            //每月可消费次数
            $("#limitedNumMonth").html(limitedNumMonthTxt);
            //每天可消费次数
            $("#limitedNumDay").html(limitedNumDayTxt);
            //是否需要预约
            $("#isNeedBook").html(getValue(bookType,dyCom.stringFiltedNull(obj.book)));
            //预约提前时间
            $("#bookAhead").html(dyCom.stringFiltedNull(obj.bookAhead));
            //预约提前时间单位
            $("#bookAheadUnit").html(getValue(bookAheadUnit,dyCom.stringFiltedNull(obj.bookAheadUnit)));
            //可预约几天内
            $("#bookDuration").html(dyCom.stringFiltedNull(obj.bookDuration));
            //预约是否算使用次数
            $("#bookEffective").html(getValue(bookEffectType,dyCom.stringFiltedNull(obj.bookEffective)));
            //备注
            $("#memo").html(dyCom.stringFiltedNull(obj.memo));
        }

    }


</script>
</html>
