<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>子卡类型列表</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp" %>

    <style type="text/css">
        #operButs{
            position: absolute;
            top:0px;
            left: 10px;
        }
    </style>
</head>
<body>
<div class="wrapper" id="loading">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul id="operationBut"></ul>
    </nav>
    <!--工具栏结束-->
    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconqiapian"></i>
                  <span class="name-text">子卡类型列表</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容-->
    <section id="M-Content" class="wrapper-main f-pA0">
        <%--操作按钮--%>
        <div id="operButs">
            <button type="button" class="u-btn u-btn-primary u-btn-sm" onclick="createChildCardType()">新增子卡类型</button>
        </div>
        <div class="m-table-list" style="margin-top: 40px;">
            <!--数据表格渲染区开始-->
            <section class="content f-mt20">
                <table>
                    <thead>
                    <tr>
                        <th  class="m-table-col-1">No.</th>
                        <th  class="m-table-col-4">子卡名称</th>
                        <th  class="m-table-col-5">子卡简介</th>
                        <th  class="m-table-col-2">卡号前缀</th>
                        <th  class="m-table-col-2">卡号长度</th>
                        <th  class="m-table-col-5">备注</th>
                        <th  class="m-table-col-2">状态</th>
                        <th  class="m-table-col-3">操作</th>
                    </tr>
                    </thead>
                    <tbody id="childTypesOfCardType" class="tbodyCenter cardInfoList"></tbody>
                </table>
            </section>
            <!--数据表格渲染区结束-->
        </div>

        <!--分页开始-->
        <div id="childCardTypesPage" class="f-mt20"></div>
        <!--分页结束-->

    </section>
</div>

<%--table模板--%>
<table id="templateTable" class="f-dn">
    <tr class="clickQuery f-csp">
        <td><div class="f-tac label1"></div></td>
        <td><div class="f-tac label2"></div></td>
        <td><div class="f-tac label3"></div></td>
        <td><div class="f-tac label4"></div></td>
        <td><div class="f-tac label5"></div></td>
        <td><div class="f-tac label6"></div></td>
        <td><div class="f-tac label7"></div></td>
        <td><div class="f-tac label8"></div></td>
    </tr>
</table>

<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp" %>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp" %>
<%--引入 枚举常量--%>
<script type="text/javascript" charset="utf-8"  src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<script type="text/javascript" charset="utf-8"  src="${ctx}/static_new_new/js/data/common.js"></script>

<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>

<script>
    //分页
    var pageSize = 10; //每页多少条
    var pageIndex = 0; //当前页

    /*卡类型id*/
    var typeId = dyCom.getUrlPathNameParams(2);
    /*展示方式 【嵌入展示时，隐藏工具栏和标题栏】*/
    var showType = dyCom.getUrlParams('showType');

    $().ready(function(){
        dyCom.setScrollHeight('#M-Content',-90);

        if(showType && showType == 'import'){
            $('.wrapper-option').hide();
            $('.wrapper-header').hide();
        }

        /*查询指定卡类型的子卡类型列表*/
        queryChildTypesOfCardtype();
        /*条件查询*/
        $('#searchBut').off('click').on('click',function () {
            queryChildTypesOfCardtype();
        });

    });

    function getParams() {
        var paramsStr = '?';
        var paramsJson = [
            'page='+pageIndex,
            'size='+pageSize
        ];
        if (token) {
            paramsJson.push('token=' + token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    /*查询指定卡类型的子卡类型列表*/
    function queryChildTypesOfCardtype() {
        var params = getParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/' + typeId +'/childtypes'+ params)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setChildTypesData(data);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);

    }

    function setChildTypesData(data) {
        /*清理旧数据*/
        $("#childTypesOfCardType").empty();

        if(data && data.result) {
            var list = data.result;
            $.each(list, function (i, obj) {

                /*克隆table 模板*/
                var trClone = $('#templateTable tr').clone();
                trClone.data('childtypeid', obj.childtypeId);
                /*赋值*/
                trClone.find('.label1').html(Number(i+1));
                trClone.find('.label2').html(dyCom.stringFiltedNull(obj.childtypeName));
                trClone.find('.label3').html(dyCom.stringFiltedNull(obj.childcardDesc));
                trClone.find('.label4').html(dyCom.stringFiltedNull(obj.cardNumPrefix));
                trClone.find('.label5').html(dyCom.stringFiltedNull(obj.cardNumLen));
                trClone.find('.label6').html(dyCom.stringFiltedNull(obj.memo));
                trClone.find('.label7').html(getValue(childCardState,dyCom.stringFiltedNull(obj.status)));

                var buts = '';
                var childCardTypeStatus = obj.status;
                if(childCardTypeStatus == '2'){
                    buts += '<button type="button" class="u-btn u-btn-primary-outline u-btn-xs" ' +
                        'onclick="operChildCardType(\'on\',\''+obj.childtypeId+'\')">发布</button>';
                }else if(childCardTypeStatus == '1') {
                    buts += '<button type="button" class="u-btn u-btn-primary-outline u-btn-xs" ' +
                        'onclick="operChildCardType(\'off\',\''+obj.childtypeId+'\')">下架</button>';
                }
                buts += '<button type="button" class="u-btn u-btn-primary-outline u-btn-xs" ' +
                    'onclick="modifyChildCardType(\''+obj.childtypeId+'\')">修改</button>';
                /*if(childCardTypeStatus != '0'){
                 buts += '<button type="button" class="u-btn u-btn-primary-outline u-btn-xs" onclick="operChildCardType(\'del\',\''+obj.childtypeId+'\')">删除</button>';
                 }*/
                trClone.find('.label8').html(buts);

                $("#childTypesOfCardType").append(trClone)
            });


        }
        /*初始化分页组件*/
        dyPlugins.Page.init("childCardTypesPage",data.totalPage,data.currPage,pageSize,data.totalRows,function(pageData){
            pageIndex = pageData.curr;
            queryChildTypesOfCardtype();
        });


        /*优惠商铺商品设置基本信息页面*/
        $('#childTypesOfCardType .clickQuery').off('click').on('click',function(){
            var childtypeid = $(this).data('childtypeid');
            showChildTypeInfo(childtypeid)
        });

    }
    /*展示子卡类型详情*/
    function showChildTypeInfo(childtypeid) {
        layer.open({
            id: "selectRepLayer",
            type: 2,
            title: "子卡详情",
            shadeClose: false,
            shade: 0.6,
            maxmin: true, //开启最大化最小化按钮
            area: ["90%", "560px"],
            content:ctx+'/mcardtypes/childtypes/'+encodeURI(childtypeid)+'?showType='+showType+'&token=${sessionScope.token}',
            success: function(ee) {},
            end:function () {
                pageIndex = 0;
                queryChildTypesOfCardtype();
            }

        });
    }



    /*跳转新增子卡类型页面*/
    function createChildCardType() {
        event.stopPropagation();    //  阻止事件冒泡
        if(showType && showType == 'import'){
            layer.open({
                id: "selectRepLayer",
                type: 2,
                title: "新增子卡类型",
                shadeClose: false,
                shade: 0.6,
                maxmin: true, //开启最大化最小化按钮
                area: ["90%", "560px"],
                content:ctx+'/mcardtypes/childtypes/create?typeId='+encodeURI(typeId)+'&showType='+showType+'&token=${sessionScope.token}',
                success: function(ee) {},
                end:function () {
                    pageIndex = 0;
                    queryChildTypesOfCardtype();
                }

            });
        }else {
            window.location.href = "${ctx}/mcardtypes/childtypes/create?typeId="+encodeURI(typeId);
        }
    }

    /*点击修改子卡类型  跳转页面*/
    function modifyChildCardType(childtypeId) {
        event.stopPropagation();    //  阻止事件冒泡
        if(showType && showType == 'import'){
            layer.open({
                id: "selectRepLayer",
                type: 2,
                title: "修改子卡类型",
                shadeClose: false,
                shade: 0.6,
                maxmin: true, //开启最大化最小化按钮
                area: ["90%", "560px"],
                content:ctx+'/mcardtypes/childtypes/'+encodeURI(childtypeId)+'/modify?showType='+showType+'&token=${sessionScope.token}',
                success: function(ee) {},
                end:function () {
                    pageIndex = 0;
                    queryChildTypesOfCardtype();
                }

            });
        }else {
            window.location.href = "${ctx}/mcardtypes/childtypes/"+encodeURI(childtypeId)+"/modify&showType="+showType;
        }
    }



    /*子卡类型操作*/
    function operChildCardType(oper,childtypeId) {
        event.stopPropagation();    //  阻止事件冒泡

        var opertype = '';
        var msg = '';
        if(oper == 'on'){
            opertype = 'onshelf';
            msg = '发布';
        }else if(oper == 'off'){
            opertype = 'offshelf';
            msg = '下架';
        }else if(oper == 'del'){
            opertype = 'delete';
            msg = '删除';
        }

        var index = layer.confirm('您确定要'+msg+'该子卡类型？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            operSubmitDate(opertype,msg,childtypeId);
            layer.close(index)
        }, function(){});

    }

    /*子卡类型操作，需要的参数*/
    function getChildParams(childtypeId) {
        var paramsObj = {};
        paramsObj.childtypeId = childtypeId;
        return paramsObj;
    }
    function operSubmitDate(opertype,msg,childtypeId) {
        var params = getChildParams(childtypeId);
        var options = {
            url: ctx + '/ajax/post?restPath=' + encodeURIComponent('/mcardsvr/mcardtypes/childtypes/'+opertype+'?token='+token),//请求url
            type: "POST",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:JSON.stringify({appData:params})
        };
        options.callback = function (type, data) {
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if (type == 1) {
                layer.msg(msg+'子卡类型成功');
                location.reload();
            } else {
                layer.msg(data);
            }
        };
        dyCom.ajaxRequest(options);
    }

</script>
</body>
</html>
