<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>子卡类型基本信息</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp" %>

</head>
<body>
<div class="wrapper" id="loading">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul id="operationBut" class="f-fl"></ul>
    </nav>
    <!--工具栏结束-->
    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icondingdan"></i>
                  <span class="name-text">子卡类型基本信息</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容-->
    <div class="main-block" id="childCardData">
        <div class="m-table-detail">
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th class="m-table-col-4">名称：</th>
                        <td class="m-table-col-14" id="childtypeName"></td>
                        <td rowspan="3" class="m-table-col-6" id="cardImg" style="text-align: center !important;"></td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">所属卡类型：</th>
                        <td class="m-table-col-14" id="typeName"></td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">子卡说明：</th>
                        <td class="m-table-col-14 f-pA15">
                            <div id="childcardDesc" style="width:100%;min-height: 100px;"></div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
        <div class="m-table-detail m-form-list m-form-nolabel f-mt10">
            <header class="title"><span>卡号规则</span></header>
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th class="m-table-col-4">卡号前缀：</th>
                        <td class="m-table-col-20" id="cardNumPrefix"></td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">卡号长度：</th>
                        <td class="m-table-col-20" id="cardNumLen"></td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">卡面值：</th>
                        <td class="m-table-col-20" id="cardPrice"></td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">是否带校验位：</th>
                        <td class="m-table-col-20 item-form">
                            <div id="cardNumCheck" class="f-fl f-mr10 f-mt15"></div>
                            <span class="f9 f-fl f-mt15">注：最后1位</span>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">是否支持虚拟卡：</th>
                        <td class="m-table-col-20" id="isVirtualCard"></td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">备注：</th>
                        <td class="m-table-col-20" id="childCardDemo"></td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
</body>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp" %>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp" %>
<%--引入私有  卡类型状态--%>
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<%--引入私有  卡类型状态处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>

<script>
    /*卡类型id*/
    var childtypeId = dyCom.getUrlPathNameParams(3);
    /*展示方式 【嵌入展示时，隐藏工具栏和标题栏】*/
    var showType = dyCom.getUrlParams('showType');

    $(document).ready(function () {

        if(showType && showType == 'import'){
            $('.wrapper-option').hide();
        }

        getChildtypeInfo();

    });

    /*获取ajax需要的参数*/
    function getParams() {
        var paramsStr = '?';
        var paramsJson = [];
        if (token) {
            paramsJson.push('token=' + token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    function getChildtypeInfo() {
        var params = getParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath: encodeURI('/mcardsvr/mcardtypes/childtypes/' + encodeURI(childtypeId) + params)
        };
        var options = {
            url: ctx + '/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data: paramsJson
        };
        options.callback = function (type, data) {
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if (type == 1) {
                //1 数据渲染
                setChildCardInfoData(data.result);
            }else {
                layer.msg(data)


            }
        };
        dyCom.ajaxRequest(options);
    }

    /*渲染子卡类型的基本信息*/
    function setChildCardInfoData(obj) {
        if(obj){
            //主图
            if(dyCom.stringFiltedNull(obj.childtypeId)){
                $("#cardImg").append('<img src="'+dyCom.getImgPath(obj.childtypeId, 'IMG', token) +'" alt="子卡主图" style="width:65%;">')
            }
            //子卡名称
            $("#childtypeName").text(dyCom.stringFiltedNull(obj.childtypeName));
            //卡状态
            var typeStatus = '';
            if(dyCom.stringFiltedNull(obj.status)){
                typeStatus = getChildStatus(obj.status);
            }
            $('#showTypeStatus').html(typeStatus);
            //所属卡类型
            $("#typeName").text(dyCom.stringFiltedNull(obj.typeName));
            //子卡说明
            $("#childcardDesc").text(dyCom.stringFiltedNull(obj.childcardDesc));
            //卡号前缀
            $("#cardNumPrefix").text(dyCom.stringFiltedNull(obj.cardNumPrefix));
            //卡号长度
            $("#cardNumLen").text(dyCom.stringFiltedNull(obj.cardNumLen));
            //卡面值
            if(dyCom.stringFiltedNull(obj.cardPrice)){
                var cardPrice = (Math.round(obj.cardPrice)/100).toFixed(2)+'元';
                $('#cardPrice').html(cardPrice);
            }
            //是否带校验位（最后1位）
            $("#cardNumCheck").text(CardNumCheckStatus(dyCom.stringFiltedNull(obj.cardNumCheck)));
            //是否支持虚拟卡
            $("#isVirtualCard").text(VirtualCardStatus(dyCom.stringFiltedNull(obj.isVirtualCard)));
            //备注
            $("#childCardDemo").text(dyCom.stringFiltedNull(obj.memo));

        }
    }




</script>
</html>
