<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>卡类型基本信息</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <!--下拉框选择组件-->
    <link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul id="toolbarButs"></ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconqiapian"></i>
                  <span class="name-text">卡类型基本信息</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main f-pA0">
        <%--卡类型主图区--%>
        <div class="m-table-detail m-form-list m-form-nolabel">
            <section class="content">
                <table>
                    <tbody>
                    <tr>
                        <td rowspan="2" style="width: 120px;">
                            <div class="item-form item-form-upload f-tac">
                                <img id="mainImg" src="" alt="MAINIMG" style="width:100px;height:auto;">
                            </div>
                        </td>
                        <td class="m-table-col-16">
                            <div class="item-form">
                                <span class="s-lh-2-0" id="typeName"></span>
                                <span class="f-fr s-c-auxiliary s-lh-2-0" id="typeStatus"></span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="m-table-col-24">
                            <div class="item-form">
                                <span class="s-lh-2-0" id="cardPrice"></span>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
        <div class="main-block" id="M-Content"></div>
    </section>
    <!--内容区结束-->
</div>

<div id="cardTypeInfoTemplate" class="f-dn">
    <div class="m-table-detail m-form-list">
        <section class="content">
            <table>
                <tbody>
                <tr>
                    <th class="m-table-col-4">发卡机构</th>
                    <td class="m-table-col-8" id="organName"></td>
                    <th class="m-table-col-4">发行时间</th>
                    <td class="m-table-col-8" id="createTime"></td>
                </tr>
                <tr>
                    <th class="m-table-col-4">简介</th>
                    <td colspan="3" class="m-table-col-20 td-edit">
                        <div class="item-form"  id="cardDesc" style="min-height: 100px;"></div>
                    </td>
                </tr>
                </tbody>
            </table>
        </section>
        <header class="m-title-alone"><span>销售规则</span></header>
        <section class="content">
            <table>
                <tbody>
                <tr>
                    <th class="m-table-col-4">续费时间</th>
                    <td class="m-table-col-8">
                        有效期到期前【<span id="advanceBuyDay"></span>】天可续费
                    </td>
                    <th class="m-table-col-4">每人最多可绑定</th>
                    <td class="m-table-col-8" id="haveNumber"></td>
                </tr>
                </tbody>
            </table>
        </section>
        <header class="m-title-alone"><span>使用规则</span></header>
        <section class="content">
            <table>
                <tbody>
                <tr>
                    <th class="m-table-col-4">有效期方式</th>
                    <td class="m-table-col-8" id="cardExpirateType"></td>
                    <th class="m-table-col-4">有效期</th>
                    <td class="m-table-col-8" id="cardExpirate"></td>
                </tr>
                </tbody>
            </table>
        </section>

    </div>
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 下拉选择组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/select/pc/dist/js/select.js?v=1"></script>
<%--引入 枚举常量--%>
<script type="text/javascript" charset="utf-8"  src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<script type="text/javascript" charset="utf-8"  src="${ctx}/static_new_new/js/data/common.js"></script>
<!--js引入私有 时间选择组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/lay_date-v5.0.9/laydate.js"></script>


<script>
    var typeId = dyCom.getUrlPathNameParams(2);

    /*1.初始化*/
    $().ready(function(){
        getCardTypeDetail()
    });

    function getParams() {
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        return paramsStr;
    }
    /*查询卡类型详情*/
    function getCardTypeDetail() {
        var params = getParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardtypes/' + typeId + params)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setCardTypeData(data.result);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    function setCardTypeData(obj) {
        var cardTypeTemplate = $('#cardTypeInfoTemplate>.m-table-detail').clone();
        if (obj) {
            $('#mainImg').attr('src',dyCom.getImgPath(obj.typeId, 'MAINIMG', token));
            $("#typeName").text(dyCom.stringFiltedNull(obj.typeName));//名称
            $("#typeStatus").text(getValue(cardTypeStatus,dyCom.stringFiltedNull(obj.typeStatus)));//名称
            $("#cardPrice").html("￥"+dyCom.numDiv(dyCom.stringFiltedNull(obj.cardPrice), '100')+"元");//价格

            cardTypeTemplate.find('#organName').text(dyCom.stringFiltedNull(obj.organName));//发行机构
            cardTypeTemplate.find('#createTime').text(dyCom.stringFiltedNull(obj.createTime).substr(0,11));//发行时间
            cardTypeTemplate.find('#cardDesc').text(dyCom.stringFiltedNull(obj.cardDesc));//简介

            cardTypeTemplate.find('#advanceBuyDay').text(dyCom.stringFiltedNull(obj.advanceBuyDay));//续费时间
            if(dyCom.stringFiltedNull(obj.haveNumber)==0){
                cardTypeTemplate.find('#haveNumber').text("不限制");//每人最多可绑定
            }else{
                cardTypeTemplate.find('#haveNumber').text(dyCom.stringFiltedNull(obj.haveNumber)+'张')
            }

            //有效期方式
            var validWay = '';
            if(dyCom.stringFiltedNull(obj.validWay)){
                if(obj.validWay != '0'){
                    validWay = getValue(validWayArray,obj.validWay);
                }else {
                    validWay = getValue(validWayArray,obj.validWay) + '，' +
                        '销售之日起'+obj.autoActivateDay+'天后如未绑定，则自动激活';
                }
                cardTypeTemplate.find('#cardExpirateType').text(validWay);
            }
            cardTypeTemplate.find('#cardExpirate').text(dyCom.stringFiltedNull(obj.validDate) + getValue(validDate,dyCom.stringFiltedNull(obj.validUnit)));//有效期

        }
        $('#M-Content').html(cardTypeTemplate);
    }


</script>
</body>
</html>
