<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>会员卡类型管理</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--多选框/单选框组件--%>
    <link type="text/css" href="${static_plugins}/third_party/iCheck-v1.0.2/skins/square/blue.css"  rel="stylesheet"/>
    <%--下拉框 样式--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">

    <!--卡类型页面样式-->
    <link rel="stylesheet" href="${ctx}/static_new_new/css/view/cardType/cardTypeStyle.css?v=2"/>

</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul id="operationBut"></ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
            <span class="header-name">
              <i class="iconfont iconqiapian"></i>
              <span class="name-text">实体下适用的卡类型</span>
            </span>
            <div class="header-option f-pt10">
                <sapn id="list_icon" data-style="list" class="iconfont iconliebiao1 f-mr10 f-csp" style="font-size: 26px;!important;"></sapn>
                <span id="tile_icon" data-style="tile" class="iconfont iconliebiao2 f-csp i_active" style="font-size: 26px;!important;"></span>
            </div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <div class="main-block">
            <div class="m-table-list">
                <div class="m-search-list">
                    <div class="search-form">
                        <div class="row">
                            <div class="col-md-6 hidden-sm"></div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input placeholder="请输入会员卡类型名称" id="cardTypeName">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item" id="selectStatus"></div>
                            </div>
                        </div>
                    </div>
                    <div class="search-btn">
                        <button type="button" class="u-btn u-btn-primary u-btn-sm" id="searchList">
                            查询
                        </button>
                    </div>
                </div>

                <!--会员卡 table列表 start-->
                <section id="list_contaniner" class="content f-mt20 f-dn">
                    <table>
                        <thead>
                        <tr>
                            <th class="m-table-col-2">No.</th>
                            <th class="m-table-col-2">图片</th>
                            <th class="m-table-col-3">名称</th>
                            <th class="m-table-col-2">价格</th>
                            <th class="m-table-col-6">简介</th>
                            <th class="m-table-col-3">发卡机构</th>
                            <th class="m-table-col-2">状态</th>
                        </tr>
                        </thead>
                        <tbody id="cardTypeList">

                        </tbody>
                    </table>
                </section>
                <!--会员卡 table列表 end-->

                <!--会员卡 信息块列表 start-->
                <section id="tile_contaniner" class="content f-mt20">
                    <ul class="f-cb cardMangeList" id="cardTypeTile"></ul>
                </section>
                <!--会员卡 信息块列表 end-->
            </div>
            <!--分页开始-->
            <div id="pagesList" class="f-mt20"></div>
            <!--分页结束-->
        </div>
    </section>
    <!--内容区结束-->
</div>

<%--table模板--%>
<table id="templateTable" class="f-dn">
    <tr>
        <td><div class="f-tac label1 " ></div></td>
        <td><div class="f-tac label2 clickQuery f-csp"></div></td>
        <td><div class="f-tac label3"></div></td>
        <td><div class="f-tac label4"></div></td>
        <td><div class="f-tac label5"></div></td>
        <td><div class="f-tac label6"></div></td>
        <td><div class="f-tac label7"></div></td>
    </tr>
</table>

<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 多选框/单选框组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/iCheck-v1.0.2/icheck.js"></script>
<%--<!--js引入私有 下拉选择组件-->--%>
<script type="text/javascript" charset="utf-8" src="${static_plugins}/select/pc/dist/js/select.js"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>

<%--引入私有  卡类型状态--%>
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<%--引入私有  卡类型常量回显--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>
<%--引入私有  卡类型数据处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeSetData_pc.js?v=1"></script>

<script>
    /*实体Id*/
    var boId = '${boId}';
    //请求路径
    var getUrl='/mcardsvr/mcardtypes/bo/'+boId+'/mcardtypes/usable';
    /*跳转类型-卡类型详情*/
    var jumpType = 'detail';

    /*1.初始化*/
    $().ready(function(){

        //初始化状态下拉筛选
        selectStatus();
        //加载列表数据
        getDataList(pageIndex,getUrl);

        /*切换 列表展示和信息块展示*/
        $("#list_icon").off('click').on('click',function () {
            $('.header-option').children('span').removeClass('i_active');
            $(this).addClass('i_active');

            $('#list_contaniner').show();
            $('#tile_contaniner').hide();

            getDataList(pageIndex,getUrl);
        });
        $("#tile_icon").off('click').on('click',function () {
            $('.header-option').children('span').removeClass('i_active');
            $(this).addClass('i_active');

            $('#list_contaniner').hide();
            $('#tile_contaniner').show();

            getDataList(pageIndex,getUrl);
        });

    });


</script>
</body>
</html>
