<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include/include-meta-info.jsp" %>
    <title>修改优惠商户</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp" %>
    <%--引入私有css文件 自定义选择框--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">

</head>

<body>
<div class="wrapper" id="loading">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul></ul>
    </nav>
    <!--工具栏结束-->
    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconbianji"></i>
                  <span class="name-text">修改优惠商户</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->
    <!--内容-->
    <div class="main-block" id="modifyCardTypeMcCatalog">
        <div class="m-table-detail m-form-list m-form-nolabel f-mt20">
            <section class="content">
                <table>
                    <tbody>
                    <tr>
                        <th width="12%"><span class="label-required"></span>商铺名称：</th>
                        <td>
                            <div class="item-form">
                                <input type="hidden" id="mcId" name="mcId">
                                <input type="hidden" id="mcName" name="mcName">
                                <span id="show_mcName"></span>
                            </div>
                        </td>
                        <td width="8%">
                            <%--<button onclick="querySupplierMc()" type="button" id="selectShops" class="u-btn u-btn-primary u-btn-sm">
                                选择商铺
                            </button>--%>
                        </td>
                    </tr>
                    <tr>
                        <th width="12%"><span class="label-required"></span>商品名称：</th>
                        <td>
                            <div class="item-form">
                                <input type="hidden" id="cmId" name="cmId">
                                <input type="hidden" id="cmName" name="cmName">
                                <span id="show_cmName"></span>
                            </div>
                        </td>
                        <td>
                            <%--<button onclick="querySupplierCm()" type="button" id="selectCommodity" class="u-btn u-btn-primary u-btn-sm">
                                选择商品
                            </button>--%>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
        <div class="m-table-detail m-form-list m-form-nolabel f-mt10">
            <header class="title"><span>优惠规则</span></header>
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th width="12%"><span class="label-required"></span>优惠方式：</th>
                        <td class="item-form" style="width:20%;display: inline-block;vertical-align: middle;">
                            <input type="number" id="discountPrice" class="required" data-datatype="money"/>
                        </td>
                        <td class="item-form" style="width:68%;display: inline-block;vertical-align: middle;">
                            <div id="discountType" class="required" data-datatype="*"></div>
                        </td>
                    </tr>
                    <tr>
                        <th><span class="label-required"></span>优惠次数：</th>
                        <td colspan="2" class="item-form">
                            <input type="number" id="discountNum" class="inputWidth50 f-mt5 required" data-datatype="n"/>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
        <div class="m-table-detail m-form-list m-form-nolabel f-mt10">
            <header class="title"><span>使用预约规则</span></header>
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th width="12%">是否需要预约：</th>
                        <td colspan="2" class="item-form"><div id="isNeedBook"></div></td>
                    </tr>
                    <tr>
                        <th>预约提前时间：</th>
                        <td colspan="2" class="item-form f-cb">
                            <input type="number" class="inputWidth30 f-fl f-mr20 f-mt5" id="bookAhead"/>
                            <div id="bookAheadUnit" class="f-fl f-mt5"></div>
                        </td>
                    </tr>
                    <tr>
                        <th>可预约几天内：</th>
                        <td colspan="2" class="item-form">
                            <input class="inputWidth50 f-mr10" type="number" id="bookDuration"/>
                            <span class="f9">例如：1表示只能预约今天；7表示可以预约1周内（含今天）</span>
                        </td>
                    </tr>
                    <tr>
                        <th>预约是否算使用次数：</th>
                        <td colspan="2" class="item-form f-cb">
                            <div id="bookEffective" class="f-fl f-mr10 f-mt5"></div>
                            <span class="f9 f-fl f-mt15">注：没有使用预约则不计算次数，使用了则计算次数</span>
                        </td>
                    </tr>
                    <tr>
                        <th width="12%">备注：</th>
                        <td colspan="2" class="item-form"><textarea class="f-mt5" name="" id="memo"></textarea></td>
                    </tr>
                    </tbody>
                </table>
                <div class="u-btn-fixed-placeholder"></div>
                <div class="f-tac u-btn-fixed-b24">
                    <button  id="cancelBut" type="button" class="u-btn u-btn-default step" data-step="2">
                        取消
                    </button>
                    <button id="submitData" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
                        确定
                    </button>
                </div>
            </section>
        </div>
    </div>
</div>

</body>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp" %>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp" %>
<!--js引入私有 下拉选择组件-->
<script src="${static_plugins}/select/pc/dist/js/select.js"></script>
<!--引入私有  卡类型状态-->
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<%--引入私有  卡类型状态处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>
<!--引入私有  创建卡类型业务处理-->
<script src="${ctx}/static_new_new/js/view/cardType/discountShopsEnter.js"></script>
<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>
<script>
    var mccatalogId=dyCom.getUrlParams('mccatalogId');
    var showType=dyCom.getUrlParams('showType');
    var mcId='',cmId='',typeId='';
    /*请求路径*/
    var getUrl='/mcardsvr/mcardtypes/mccatalogs/'+encodeURI(mccatalogId);
    var postUrl='/mcardsvr/mcardtypes/mccatalogs/modify';
    $().ready(function () {
        //数据验证初始化
        dyPlugins.Validate.init("#modifyCardTypeMcCatalog");

        if(showType && showType == 'import'){
            $('.wrapper-option').hide();
        }

        //初始化页面数据
        getDataInfo();

        /*点击提交按钮  提交数据*/
        $("#cancelBut").click(function () {
            if(showType){
                var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
                parent.layer.close(index);
            }else {
                window.history.go(-1)
            }
        });

        /*点击提交按钮  提交数据*/
        $("#submitData").click(function () {
            submitDataInfo();
        });
    });

    /*查询商铺*/
    function querySupplierMc() {
        var supplierBoId = "";

        var childWindow = null;
        layer.open({
            id: "selectRepLayer",
            type: 2,
            title: "选择商铺",
            shadeClose: true,
            shade: 0.6,
            maxmin: true, //开启最大化最小化按钮
            area: ["750px", "560px"],
            content:"<%=baseResourcePath%>/ebmcmgrweb/mcs/choosemc?isMulChoice=false&tabTitleList=0,1&customId="+supplierBoId+"&token=${sessionScope.token}",
            success: function(ee) {
                //初始化完成之后  例如修改的时候 需要处理
                var frameId = document.getElementById("selectRepLayer").getElementsByTagName("iframe")[0].id;
                childWindow = $("#" + frameId)[0].contentWindow;
                // item  必须字段 objType itemId  name
                var dataList = [];
                if($("#mcId").val() && $("#mcName").val()){
                    dataList = [{'mcId':$("#mcId").val(),'mcName':$("#mcName").val()}];
                }
                childWindow.setItemsList(dataList);

            },
            btn: ["确定", "取消"],
            yes: function(index) {
                var datalist = childWindow.getItemsList();
                if(datalist && datalist.length){
                    $("#mcId").val(datalist[0].mcId);
                    mcId=datalist[0].mcId;
                    $("#mcName").val(datalist[0].mcName);
                    $("#show_mcName").html(datalist[0].mcName);
                }

                /*清除已选商品*/
                $("#cmId").val('');
                $("#cmName").val('');
                $("#show_cmName").html('');
                /*关闭弹框*/
                layer.close(index);
            },
            btn2: function(index) {}
        });
    }

    /*查询商品*/
    function querySupplierCm() {
        var mcId = $("#mcId").val();
        if(mcId == ''){
            layer.msg("请先选择年卡适用商铺");
            return false;
        }
        var childWindow = null;
        layer.open({
            id: "selectRepLayer",
            type: 2,
            title: "选择商品",
            shadeClose: true,
            shade: 0.6,
            maxmin: true, //开启最大化最小化按钮
            area: ["750px", "560px"],
            content:"<%=baseResourcePath%>/ebmcmgrweb/cms/choosecm?tabTitleList=4&isMulChoice=false&mcId="+mcId+"&token=${sessionScope.token}",
            success: function(ee) {
                //初始化完成之后  例如修改的时候 需要处理
                var frameId = document
                    .getElementById("selectRepLayer")
                    .getElementsByTagName("iframe")[0].id;
                childWindow = $("#" + frameId)[0].contentWindow;
                var dataList = [];
                if($("#cmId").val() && $("#cmName").val()){
                    dataList = [{'cmId':$("#cmId").val(),'cmName':$("#cmName").val()}];
                }
                // item  必须字段 objType cmId  cmName
                childWindow.setItemsList(dataList);
            },
            btn: ["确定", "取消"],
            yes: function(index) {
                var datalist = childWindow.getItemsList();
                if(datalist && datalist.length){
                    $("#cmId").val(datalist[0].cmId);
                    cmId=datalist[0].cmId;
                    $("#cmName").val(datalist[0].cmName);
                    $("#show_cmName").html(datalist[0].cmName);
                }
                layer.close(index);
            },
            btn2: function(index) {}
        });
    }
</script>
</html>
