<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include/include-meta-info.jsp" %>
    <title>修改会员卡类型</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp" %>
    <%--引入私有css文件 自定义选择框--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">
    <%--引入私有css文件 form表单--%>
    <link href="${static_css}/themes/content/pc/form.css" rel="stylesheet">
    <!--引入私有 卡类型页面样式-->
    <link rel="stylesheet" href="${ctx}/static_new_new/css/view/cardType/cardTypeStyle.css"/>
    <style type="text/css">
        #uploadMainImg{
            width:100%;
        }
        #uploadMainImg li{
            height:100%;
            width:100%;
        }

        /*内容水平居左、垂直居中*/
        .center-vertically{
            justify-content:center;     /*水平居中*/
            align-items:center;
            display:-webkit-flex;/*垂直居中*/
        }
        .f-pa{
            position: absolute !important;
        }

    </style>

</head>

<body>
<div class="wrapper" id="loading">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>
        </ul>
    </nav>
    <!--工具栏结束-->
    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconbianji"></i>
                  <span class="name-text">修改会员卡类型</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->
    <!--内容-->
    <div class="main-block" id="modifyCardType">
        <%--卡类型主图区--%>
        <div class="m-table-detail m-form-list m-form-nolabel">
            <section class="content">
                <table>
                    <tbody>
                    <tr>
                        <td rowspan="2" class="m-table-col-4">
                            <div class="item-form item-form-upload f-tac">
                                <ul id="uploadMainImg" class="upload-images">
                                    <li id="mainImg" class="s-bg-f2f2f2 center-vertically"></li>
                                </ul>
                            </div>
                        </td>
                        <td class="m-table-col-20">
                            <div class="item-form">
                                <span class="label-required f-pa"></span>
                                <input type="text" id="typeName" data-datatype="*" class="required" placeholder="请输入会员卡名称">
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="m-table-col-20">
                            <div class="item-form">
                                <span class="label-required f-pa"></span>
                                <input type="text" id="cardPrice" class="required" data-datatype="money" placeholder="请输入价格">
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
        <div class="m-table-detail m-form-list m-form-nolabel">
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th class="m-table-col-4">发卡机构</th>
                        <td class="m-table-col-8" id="organName"></td>
                        <th class="m-table-col-4">发行时间</th>
                        <td class="m-table-col-8" id="createTime"></td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>简介：</th>
                        <td class="m-table-col-20" colspan="3">
                            <div class="item-form">
                                <textarea name="" id="cardIntro" rows="5" class="required f-mt10" data-datatype="*"></textarea>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
        <div class="m-table-detail m-form-list m-form-nolabel f-mt10">
            <header class="title"><span>销售规则</span></header>
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>续费时间：</th>
                        <td class="m-table-col-20">
                            <div class="item-form">
                                有效期到期前【<input class="required inputWidth30 f-mr10 f-ml10 f-mt5" type="text"
                                              id="cardUpdateTime" data-datatype="n"/>】天可续费
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>每人最多可绑定：</th>
                        <td class="m-table-col-20">
                            <div class="item-form">
                                <input class="required inputWidth50 f-mr10 f-mt5" type="text" id="cardCount" data-datatype="n">
                                <span class="">张</span>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
            <div>
            </div>
        </div>
        <div class="m-table-detail m-form-list m-form-nolabel f-mt10">
            <header class="title"><span>使用规则</span></header>
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>有效期方式：</th>
                        <td class="m-table-col-20 item-form f-cb">
                            <div id="cardExpirateType" class="required inputWidth30 f-mt5 f-fl" data-datatype="*"></div>
                            <div id="validWayFirst" class="f-fl">
                                销售之日起<input class="required inputWidth10 f-mt5 f-mr10 f-ml10"
                                            type="text" data-datatype="n">天后如未绑定，则自动激活
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>有效期：</th>
                        <td class="m-table-col-20 item-form f-cb">
                            <div class="inputWidth30 f-fl f-mr20">
                                <input type="text" id="cardExpirate" class="required" data-datatype="n">
                            </div>
                            <div id="validDateType" class="fl required" data-datatype="*"></div>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <div class="u-btn-fixed-placeholder"></div>
                <div class="f-tac u-btn-fixed-b24">
                    <button  id="cancelBut" type="button" class="u-btn u-btn-default step" data-step="2">
                        取消
                    </button>
                    <button id="submitData" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
                        确定
                    </button>
                </div>
            </section>
        </div>
    </div>
</div>
</body>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp" %>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp" %>

<!--js引入私有 下拉选择组件-->
<script src="${static_plugins}/select/pc/dist/js/select.js"></script>

<!--引入私有  卡类型状态-->
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<!--引入私有  卡类型状态处理-->
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>
<!--引入私有  创建卡类型业务处理-->
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeInfoEnter.js"></script>

<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>

<script>
    /*卡类型Id*/
    var mcId='';
    var typeId = dyCom.getUrlPathNameParams(2);

    /*请求路径*/
    var getUrl='/mcardsvr/mcardtypes/' + encodeURI(typeId);//获取信息
    var postUrl='/mcardsvr/mcardtypes/modify';//提交信息

    var docs = [];
    //上传主图
    function uploadMainImg(){
        //上传组件参数
        var upUrl = baseResourcePath+'/commonsvr/docs/uploadMulti?token='+token;
        //图片附件信息
        var logoUploadOptions = {
            url: upUrl,
            domId: '#mainImg',
            callback:function(type,data){      //回调  type=1 成功  type=0 请求失败 data 返回数据
                if (type == 1 && '10000' == data.status && data.result.length > 0) {
                    //拼装LOGO图片预览图
                    var docInfo = data.result[0];
                    var htmlStr = '<li><img src="<%=baseResourcePath%>'+ docInfo.filePath + '/' + docInfo.fileName +'" style="width: 100%; height: auto;"></li>';
                    $('#uploadMainImg').html(htmlStr);

                    docs.push({docId:docInfo.docId,docType:'MAINIMG',status:1});
                } else if (type == 0) {
                    //上传失败，打印错误信息；
                    layer.msg(data);
                }
            }
        }
        //上传组件初始化
        $('#mainImg').off('click').on('click', function () {
            docs = [];
            dyCom.ajaxUpload(logoUploadOptions);
        });
    }

    $().ready(function () {
        //数据验证初始化
        dyPlugins.Validate.init("#modifyCardType");

        uploadMainImg();

        //加载已有数据
        getDataInfo(getUrl);

        /*点击提交按钮  提交数据*/
        $("#cancelBut").click(function () {
            window.history.go(-1)
        });

        /*点击提交按钮  提交数据*/
        $("#submitData").click(function () {
            submitDataInfo();
        });

    });

</script>
</html>
