<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>新增子卡类型</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp" %>
    <%--引入私有css文件 swipper--%>
    <link href="${static_plugins}/third_party/swiper-v5.2.1/css/swiper.css" rel="stylesheet">
    <%--引入私有css文件 自定义选择框--%>
    <link href="${static_plugins}/select/pc/dist/css/select.css" rel="stylesheet">
    <%--引入私有css文件 form表单--%>
    <link href="${static_css}/themes/content/pc/form.css" rel="stylesheet">
    <!--引入私有 卡类型页面样式-->
    <link rel="stylesheet" href="${ctx}/static_new_new/css/view/cardType/cardTypeStyle.css"/>
    <style type="text/css">
        /*轮播切换时，图片有放大缩小的效果 start*/
        .swiper-slide {
            width: 80%;
            -webkit-transform: scale(0.8);
            -moz-transform: scale(0.8);
            -ms-transform: scale(0.8);
            -o-transform: scale(0.8);
            transform: scale(0.8);
        }
        .swiper-slide-active {
            -webkit-transform: scale(1);
            -moz-transform: scale(1);
            -ms-transform: scale(1);
            -o-transform: scale(1);
            transform: scale(1);
        }
        /*轮播切换时，图片有放大缩小的效果 end*/

        /*轮播切换图片*/
        .swiper-container img {
            display:block;
            width:100%;
            height:150px;
            border-radius: 10px;
        }

        .swiper-container .addBut{
            display:block;
            width:100%;
            height: 150px;
            background-color: #eaeaea;
            border-radius: 15px;
            text-align: center !important;
            padding-top: 20% !important;
            cursor: pointer;
        }
        .closeIcon{
            position: absolute;
            top:0;
            right: -17px;
        }

    </style>
</head>

<body>
<div class="wrapper" id="loading">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>
        </ul>
    </nav>
    <!--工具栏结束-->
    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconbianji"></i>
                  <span class="name-text">新增子卡类型</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->
    <!--内容-->
    <div class="main-block" id="createChildCardType">
        <div class="m-table-detail m-form-list m-form-nolabel">
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>名称：</th>
                        <td class="m-table-col-14">
                            <div class="item-form">
                                <input type="text" id="childtypeName" data-datatype="*" class="required">
                            </div>
                        </td>
                        <td rowspan="3" class="m-table-col-6">
                            <div class="swiper-container">
                                <div id="picUrl" class="swiper-wrapper">
                                    <div id="uploadImgBtn" class="swiper-slide">
                                        <span class="iconfont iconjiahao f-fs36 s-c-primary addBut"></span>
                                    </div>
                                </div>
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>所属卡类型：</th>
                        <td class="m-table-col-14">
                            <div class="item-form">
                                <input type="hidden" id="typeId"/>
                                <input type="hidden" id="typeName"/>
                                <span id="show_typeName"></span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>子卡描述：</th>
                        <td class="m-table-col-14">
                            <div class="item-form">
                                <textarea name="" id="childcardDesc" rows="5" class="f-mt10 required" data-datatype="*"></textarea>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </section>
        </div>
        <div class="m-table-detail m-form-list m-form-nolabel">
            <header class="title"><span>卡号规则</span></header>
            <section class="content">
                <table>
                    <tbody class="cardInfoTab m-form-list">
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>卡号前缀：</th>
                        <td class="m-table-col-20">
                            <div class="item-form">
                                <input type="text" id="cardNumPrefix" class="inputWidth50 f-mr10 f-mt5 required" data-datatype="*"/>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4"><span class="label-required"></span>卡号长度：</th>
                        <td class="m-table-col-20">
                            <div class="item-form">
                                <input type="text" id="cardNumLen" class="inputWidth50 f-mr10 f-mt5 required" data-datatype="n"/>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">卡面值：</th>
                        <td class="m-table-col-20">
                            <div class="item-form">
                                <input type="text" id="cardPrice" class="inputWidth50 f-mr10 f-mt5"/>元
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">是否带校验位：</th>
                        <td class="m-table-col-20 item-form">
                            <div id="cardNumCheck" class="f-fl f-mr10 f-mt5"></div>
                            <span class="f9 f-fl f-mt15">注：最后1位</span>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">是否支持虚拟卡：</th>
                        <td class="m-table-col-20 item-form">
                            <div id="isVirtualCard" class="f-fl"></div>
                        </td>
                    </tr>
                    <tr>
                        <th class="m-table-col-4">备注：</th>
                        <td class="m-table-col-20">
                            <div class="item-form">
                                <textarea id="childCardDemo" class="fl"></textarea>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>

                <div class="u-btn-fixed-placeholder"></div>
                <div class="f-tac u-btn-fixed-b24">
                    <button  id="cancelBut" type="button" class="u-btn u-btn-default step" data-step="2">
                        取消
                    </button>
                    <button id="submitData" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
                        确定
                    </button>
                </div>
            </section>
        </div>
    </div>
</div>
</body>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp" %>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp" %>
<!--引入私有  图片轮播-->
<script src="${static_plugins}/third_party/swiper-v5.2.1/js/swiper.js" type="text/javascript" charset="utf-8"></script>
<!--js引入私有 下拉选择组件-->
<script src="${static_plugins}/select/pc/dist/js/select.js"></script>
<%--引入私有  卡类型状态--%>
<script src="${ctx}/static_new_new/js/data/cardTypeConstant.js"></script>
<%--引入私有  卡类型状态处理--%>
<script src="${ctx}/static_new_new/js/view/cardType/cardTypeShowConstant.js"></script>
<!--引入私有  创建卡类型业务处理-->
<script src="${ctx}/static_new_new/js/view/cardType/childCardTypeEnter.js"></script>

<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>

<script>
    /*商铺类型Id*/
    var typeId = dyCom.getUrlParams('typeId');
    var showType=dyCom.getUrlParams('showType');

    /*请求路径*/
    var postUrl='/mcardsvr/mcardtypes/childtypes/create';
    $().ready(function () {
        if(showType && showType == 'import'){
            $('.wrapper-option').hide();
        }

        //数据验证初始化
        dyPlugins.Validate.init("#createChildCardType");

        //初始化是否带校验位下拉筛选
        cardNumCheck();
        //初始化是否支持虚拟卡下拉筛选
        virtualCard();

        /*获取所属会员卡类型的基本信息【用于回显所属会员卡类型】*/
        getCardTypeInfo(typeId);

        /*图片轮播*/
        var swiper = new Swiper('.swiper-container', {
            direction: 'horizontal',
            loop: false,
            slidesPerView: "auto",
            centeredSlides:true,
            watchSlidesProgress: true,
            roundLengths:true,
            autoHeight:true,
            spaceBetween:-10,
            observer:true,//修改swiper自己或子元素时，自动初始化swiper
            observeParents:true,//修改swiper的父元素时，自动初始化swiper
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev'
            }
        });

        /*触发图片上传*/
        $('#uploadImgBtn').off('click').on('click',function () {
            dyCom.ajaxUpload(mainUploadOptions);
        })

        /*点击提交按钮  提交数据*/
        $("#cancelBut").click(function () {
            if(showType){
                var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
                parent.layer.close(index);
            }else {
                window.history.go(-1)
            }
        });

        /*点击提交按钮  提交数据*/
        $("#submitData").click(function () {
            submitDataInfo();
        });
    });

    /*获取ajax需要的参数*/
    function getParentCardTypeParams() {
        var paramsStr = '?';
        var paramsJson = [];
        if (token) {
            paramsJson.push('token=' + token);
        }
        paramsStr += paramsJson.join('&');
        return paramsStr;
    }
    /*获取所属会员卡类型的基本信息*/
    function getCardTypeInfo(typeId) {
        var ctParams = getParentCardTypeParams(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath: encodeURI('/mcardsvr/mcardtypes/' + typeId + ctParams)
        };
        var options = {
            url: ctx + '/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data: paramsJson
        };
        options.callback = function (type, data) {
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if (type == 1 && data.result) {
                var obj = data.result;
                /*回显所属卡类型 */
                $('#typeId').val(dyCom.stringFiltedNull(obj.typeId));
                $('#typeName').val(dyCom.stringFiltedNull(obj.typeName));
                $('#show_typeName').html(dyCom.stringFiltedNull(obj.typeName));

            }else{
                layer.msg(data);
            }
        };
        dyCom.ajaxRequest(options);
    }

    /*图片上传*/
    var docList=[];
    var upUrl = baseResourcePath+'/commonsvr/docs/uploadMulti?token=' + token;
    var mainUploadOptions = {
        url: upUrl,
        domId: '#uploadImgBtn',
        callback:function(type,data){      //回调  type=1 成功  type=0 请求失败 data 返回数据
            if (type == 1) {
                if (type == 1 && '10000' == data.status && data.result.length > 0) {
                    for (var i = 0, len = data.result.length; i < len; i++) {
                        var docInfo = data.result[i];

                        var htmlStr = '<div class="swiper-slide f-pr" id="' + docInfo.docId + '"><img src="'+baseResourcePath+ docInfo.filePath + '/' + docInfo.fileName +'">';
                        htmlStr += '<input type="hidden" class="img" value="' + docInfo.docId + '">';
                        htmlStr += '<span class="iconfont iconguanbi closeIcon" data-id="'+docInfo.docId+'">';
                        htmlStr += '</div>';

                        /*在添加图片按钮前追加*/
                        $('#uploadImgBtn').before(htmlStr);

                        docList.push({"docId":docInfo.docId,"docType":"MAINIMG"});

                    }
                    //添加删除图片的事件
                    $('#picUrl .iconqingchu').off('click').on('click', function () {
                        $('#' + $(this).data('id')).remove();
                    });

                }
            } else if (type == 0) {
                //上传失败，打印错误信息；
                layer.msg(data);
            }
        }
    };
</script>
</html>
