<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<c:set var="static_js" value="${pageContext.request.contextPath}/static/js"/>
<c:set var="static_css" value="${pageContext.request.contextPath}/static/css"/>
<c:set var="static_images" value="${pageContext.request.contextPath}/static/images"/>
<c:set var="dist_bootstrap" value="${pageContext.request.contextPath}/dist/lib/bootstrap/"/>
<c:set var="dist_jquery" value="${pageContext.request.contextPath}/dist/lib/jquery"/>
<c:set var="dist_styles" value="${pageContext.request.contextPath}/dist/styles"/>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="edge"/>
    <meta name="viewport"
          content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no"/>
    <title>卡订单管理-退卡申请页面</title>
    <link href="${static_css}/bootstrap.min.css" rel="stylesheet">
    <link href="${static_css}/common.css" rel="stylesheet">
</head>

<body>
<div class="body-div" id="loading">
    <div class="btn-group-menu">
        <div class="btn-group">

        </div>
    </div>
    <!--下部-->
    <div class="main-content">
        <div class="title">
        	<span>
        		退款申请
        	</span>
        </div>
        <div class="col-xs-12 swlDetail">
            <form action="${ctx}/mcardorders/refund/apply/submit">
                <div class="row-fluid">
                    <div class="span12">
                        <table>
                            <tr><td>订单信息</td></tr>
                            <tr>
                                <td>订单编号</td>
                                <td></td>
                                <td>订单状态</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>订单总金额</td>
                                <td></td>
                                <td>订单描述</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>购买人</td>
                                <td></td>
                                <td>下单时间</td>
                                <td></td>
                            </tr>

                        </table>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span12">
                        <table>
                            <tr><td>购买卡列表</td></tr>
                            <c:forEach items="" var="mcardInfo">
                                <tr>
                                    <td>
                                            ${mcardInfo.cardNum}
                                    </td>
                                    <td>
                                            ${mcardInfo.cardStatus}
                                    </td>
                                </tr>

                            </c:forEach>
                        </table>
                    </div>
                </div>
                <div class="row-fluid">
                    <submit class="btn btn-primary btn-lg ">申请退卡</submit>
                </div>
            </form>
        </div>
    </div>

</div>
</body>
<script src="${dist_jquery}/jquery.js" type="text/javascript" charset="utf-8"></script>
<script src="${dist_bootstrap}/bootstrap.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
    //鼠标经过按钮变色
    function currentMenuBtn() {
        $(".menu-btn").mouseover(function () {
            $(this).children().css("background-color", "#8EB4E3");
        });
        $(".menu-btn").mouseout(function () {
            $(this).children().css("background-color", "#bdbfbe");
        });
    }
    currentMenuBtn();
</script>

</html>
