<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>订单管理-订单详情</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />
    <!--表格组件-->
    <link rel="stylesheet" href="${static_plugins}/table/pc/dist/css/table.css" />
    <style>
        .s-bscB-dee3e6{
            border-bottom: solid 1px #dee3e6;
        }
        .m-header-extend {
            padding-bottom: 10px;
            border-bottom: solid 1px #dee3e6;
        }

        .m-header-extend .header-border {
            height: 20px;
            padding-left: 15px;
            border-left: solid 4px #0aabf6;
        }
        .m-header-extend .header-title {
            width: 100%;
            color: #0aabf6;
            font-size: 14px;
            line-height: 20px;
            overflow: hidden;
            word-wrap: normal;
            white-space: nowrap;
            text-overflow: ellipsis;
            content: "...";
        }
    </style>
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul id="optionBtns">

        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icondingdan"></i>
                  <span class="name-text">订单详情管理</span>
                  <span id="promptMsg" class="name-text f-ml20" style="color: red;"></span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <!--业务模块-->
        <div class="main-block">
            <div class="m-table-detail">
                <header class="title"><span>订单基本信息</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">订单编号</th>
                            <td class="m-table-col-8" id="order-orderId"></td>
                            <th class="m-table-col-4">商品数量</th>
                            <td class="m-table-col-8" id="order-orderCmNum"></td>
                        </tr>
                        <tr>
                            <th>订单状态</th>
                            <td id="order-orderStatus"></td>
                            <th rowspan="3">订单描述</th>
                            <td rowspan="3" id="order-orderDes"></td>
                        </tr>
                        <tr>
                            <th>订单类型</th>
                            <td>
                                <span id="order-orderBiztype"></span>-
                                <span id="order-orderType"></span>-
                                <span id="order-saleType"></span>
                            </td>
                        </tr>
                        <tr>
                            <th>下单时间</th>
                            <td id="order-createDate"></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="m-title-alone"><span>订单详细信息</span></header>
                <div>
                    <div class="row">
                        <div class="col-md-4 col-sm-6 col-xs-12 f-mb15">
                            <div class="s-bsc-dee3e6 s-bg-f2f2f2 f-pA10">
                                <header class="m-header-extend">
                                    <div class="header-border">
                                        <div class="header-title">
                                            买家信息
                                        </div>
                                    </div>
                                </header>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-6">
                                        <lable class="">姓名：</lable>
                                        <span id="order-userName"></span>
                                    </div>
                                    <div class="col-md-6 f-tar">
                                        <lable>手机：</lable>
                                        <span id="order-mobile"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="s-bsc-dee3e6 s-bg-f2f2f2 f-pA10" style="margin-top: 10px;">
                                <header class="m-header-extend">
                                    <div class="header-border">
                                        <div class="header-title">
                                            卖家信息
                                        </div>
                                    </div>
                                </header>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">实体：</lable>
                                        <span id="order-saleBoName"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable>网点：</lable>
                                        <span id="order-saleOrganName"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable>人员：</lable>
                                        <span id="order-saleAccountName"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="s-bsc-dee3e6 s-bg-f2f2f2 f-pA10" style="margin-top: 10px;">
                                <header class="m-header-extend">
                                    <div class="header-border">
                                        <div class="header-title">
                                            商家信息
                                        </div>
                                    </div>
                                </header>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">实体：</lable>
                                        <span id="order-partnerName"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">商铺：</lable>
                                        <span id="order-mcName"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="s-bsc-dee3e6 s-bg-f2f2f2 f-pA10" style="margin-top: 10px;">
                                <header class="m-header-extend">
                                    <div class="header-border">
                                        <div class="header-title">
                                            物流信息
                                        </div>
                                    </div>
                                </header>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">配送方式：</lable>
                                        <span id="order-lgSendtype"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">期望配送时间：</lable>
                                        <span id="order-lgSenddate"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-6">
                                        <lable class="">收件人：</lable>
                                        <span id="order-lgRecipient"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <lable class="">手机号：</lable>
                                        <span id="order-lgPhone"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">收件地址：</lable>
                                        <span id="order-pcc"></span>
                                    </div>
                                    <div class="col-md-12 f-mt10">
                                        <lable class="">&#12288;&#12288;&#12288;&#12288;&#12288;</lable>
                                        <span id="order-addrress"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">发货人：</lable>
                                        <span id="order-lgSenderName"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">快递公司：</lable>
                                        <span id="order-lgExpressName"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">快递单号：</lable>
                                        <span id="order-lgExpressNum"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6 col-xs-12 f-mb15">
                            <div class="s-bsc-dee3e6 s-bg-f2f2f2 f-pA10">
                                <header class="m-header-extend">
                                    <div class="header-border">
                                        <div class="header-title">
                                            订单金额
                                        </div>
                                    </div>
                                </header>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">订单金额：</lable>
                                        <span id="order-orderAmount"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">商品金额：</lable>
                                        <span id="order-cmBill"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">运费：</lable>
                                        <span id="order-carriage"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">优惠金额：</lable>
                                        <span id="order-favAmount"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">附加费用：</lable>
                                        <span id="order-feeAdditional"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">附加费用说明：</lable>
                                        <span id="order-feeAdditionalDesc"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6 col-xs-12 f-mb15">
                            <div class="s-bsc-dee3e6 s-bg-f2f2f2 f-pA10">
                                <header class="m-header-extend">
                                    <div class="header-border">
                                        <div class="header-title">
                                            支付信息
                                        </div>
                                    </div>
                                </header>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">支付方式：</lable>
                                        <span id="order-payMethod"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">支付渠道：</lable>
                                        <span id="order-payChannel"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">支付结果：</lable>
                                        <span id="order-paymentResult"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">支付记录：</lable>
                                        <span id="order-recordId"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">支付时间：</lable>
                                        <span id="order-recordTime"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">支付金额：</lable>
                                        <span id="order-payMoney"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6 col-xs-12 f-mb15">
                            <div class="s-bsc-dee3e6 s-bg-f2f2f2 f-pA10">
                                <header class="m-header-extend">
                                    <div class="header-border">
                                        <div class="header-title">
                                            发票信息
                                        </div>
                                    </div>
                                </header>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">发票类型：</lable>
                                        <span id="order-receiptType"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">发票抬头：</lable>
                                        <span id="order-receiptName"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">税号：</lable>
                                        <span id="order-receiptTaxnum"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">邮箱：</lable>
                                        <span id="order-receiptDesc"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6 col-xs-12 f-mb15">
                            <div class="s-bsc-dee3e6 s-bg-f2f2f2 f-pA10">
                                <header class="m-header-extend">
                                    <div class="header-border">
                                        <div class="header-title">
                                            退款信息
                                        </div>
                                    </div>
                                </header>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">手续费：</lable>
                                        <span id="order-factorage"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">退款原因：</lable>
                                        <span id="order-refundReason"></span>
                                    </div>
                                </div>
                                <div class="row s-bscB-dee3e6 f-pb10 f-pt10">
                                    <div class="col-md-12">
                                        <lable class="">退款时间：</lable>
                                        <span id="order-refundTime"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <header class="m-title-alone"><span>订单明细</span></header>
                <section class="content f-mt20" id="orderDetailList"></section>
                <header class="m-title-alone" id="send-title" style="display: none;"><span>发货明细</span></header>
                <div id="deliverList" class="content f-mt20" style="display: none;" data-height="400"></div>
            </div>
        </div>
        <!--业务模块结束-->
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有-->
<!--js引入私有 多选框组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/iCheck-v1.0.2/icheck.min.js"></script>
<!--js引入私有 表格组件 依赖于 多选框组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/table/pc/dist/js/table.js"></script>
<%--引入常量数据--%>
<script src="${ctx}/static_new_new/js/data/order_constant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>

<script>

    //订单ID
    var orderId = dyCom.getUrlPathNameParams(2);

    /*兼容和谐酒业 赠品发货 功能*/
    /*卖家实体Id*/
    var sale_bo_id = 'f4c20762ccfc561b45d27f78d2b453ea';
    if(currEnvValue && currEnvValue =='test'){
        sale_bo_id = 'cfbb4ba6ba3785590e1515e988d149fd';
    }
    /*订单类型*/
    var order_biz_type = 'mcard';
    /*订单状态*/
    var order_status = '8';



    /*1.初始化*/
    $().ready(function(){
        //获取订单基本信息
        getOrderInfoAjax();
    });

    /* 2.业务方法  */
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        return paramsStr;
    }
    /* 2.业务方法  */
    function getOrderInfoAjax(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

        var paramsJson = {
            restPath:encodeURI('/ordersvr/orders/'+orderId+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //获取订单详情
                if (data.result) {

                    var orderObj = data.result;

                    /*渲染订单详情数据*/
                    setOrderInfoData(orderObj);
                    /*获取订单明细*/
                    queryOrderDetailAjax(orderObj);

                    /*卖家商户Id*/
                    var saleBoId = orderObj.saleBoId;
                    /*订单类型*/
                    var orderBiztype = orderObj.orderBiztype;
                    /*订单状态*/
                    var orderStatus = orderObj.orderStatus;
                    /*渲染操作按钮*/
                    setOptionBtns(saleBoId,orderBiztype,orderStatus);
                    /*渲染订单提示信息*/
                    setPromptMsg(saleBoId,orderBiztype,orderStatus);
                }
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    function setOrderInfoData(info) {
        if (info) {
            for (var key in info) {
                $('#order-'+key).html(info[key]);
            }
            //处理枚举值信息
            //订单商品数量
            var numStr = '';
            var orderCmNum1 = dyCom.stringFiltedNull(info.orderCmNum1);
            if(orderCmNum1){
                numStr += '共'+orderCmNum1+'种商品，'
            }
            var orderCmNum2 = dyCom.stringFiltedNull(info.orderCmNum2);
            if(orderCmNum2){
                numStr += '共'+orderCmNum2+'件'
            }
            $('#order-orderCmNum').html(numStr);

            //订单状态状态
            var statusStr = getValue(orderStatus, info.orderStatus);
            $('#order-orderStatus').html(statusStr);
            //订单业务类型
            var orderBiztypeStr = getValue(orderBizType, info.orderBiztype);
            $('#order-orderBiztype').html(orderBiztypeStr);
            //订单类型
            var orderTypeStr = getValue(orderType, info.orderType);
            $('#order-orderType').html(orderTypeStr);
            //销售类型
            var saleTypeStr = getValue(orderSaleType, info.saleType);
            $('#order-saleType').html(saleTypeStr);
            //发票类型
            var receiptTypeStr = getValue(invoiceType, info.receiptType);
            $('#order-receiptType').html(receiptTypeStr);
            //配送方式
            var lgSendtypeStr = getValue(lgSendType, info.lgSendtype);
            $('#order-lgSendtype').html(lgSendtypeStr);

            var pcc = '';
            var province = dyCom.stringFiltedNull(info.lgProvince);
            if(province){
                pcc += province;
            }
            var city = dyCom.stringFiltedNull(info.lgCity);
            if(city){
                pcc += city;
            }
            var county = dyCom.stringFiltedNull(info.lgCounty);
            if(county){
                pcc += county;
            }
            $('#order-pcc').html(pcc);

            //收货地址
            var addrress = dyCom.stringFiltedNull(info.lgAddrress);
            if(addrress){
                pcc += addrress;
            }
            $('#order-addrress').html(addrress);

            //订单金额
            $('#order-orderAmount').html(dyCom.numberFormat(info.orderAmount/100, 2, '.'));
            //商品金额
            $('#order-cmBill').html(dyCom.numberFormat(info.cmBill/100, 2, '.'));
            //运费
            $('#order-carriage').html(dyCom.numberFormat(info.carriage/100, 2, '.'));
            //附加费用
            $('#order-feeAdditional').html(dyCom.numberFormat(info.feeAdditional/100, 2, '.'));
            //优惠金额
            $('#order-favAmount').html(dyCom.numberFormat(info.favAmount/100, 2, '.'));
            //支付金额
            $('#order-payMoney').html(dyCom.numberFormat(info.payMoney/100, 2, '.'));
        }
    }

    /**
     * 获取订单明细
     */
    function queryOrderDetailAjax(orderInfo) {
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

        var urlStr = '';
        if('eb' == orderInfo.orderBiztype) {
            urlStr = '/ebsvr/eborders/'+orderId+'/details'+svrParamsString;
        }else if('mcard' == orderInfo.orderBiztype) {
            urlStr = '/mcardsvr/mcardorders/'+orderId+'/details'+svrParamsString;
            //如果是会员订单，需要展示发卡明细，然后查询发卡明细列表
            $('#send-title').show();
            $('#deliverList').show();

            //查询发卡明细列表
            queryMcardSendAjax();

        }else {
            return;
        }
        var paramsJson = {
            restPath:urlStr
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setOrderDetailList(orderInfo.orderBiztype, data);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    function setOrderDetailList(type,dataList) {
        if(!dataList.result){
            dataList.result = [];
        }
        var colsList =[
            {
                type: "numbers",
                field: "nums",
                title: "NO.",
                width: 50
            }, //序列号
            { field: "cm", width: 150, title: "卡类型",callback: function(cdata) {
                var name = "<span class='f-toe f-db'>";
                if(dyCom.stringFiltedNull(cdata.typeName)){
                    name += cdata.typeName;
                }
                if(dyCom.stringFiltedNull(cdata.childtypeName)){
                    name += '--';
                    name += cdata.childtypeName;
                }
                name += "</span>";
                return name;
            }},
            { field: "skuName", width: 150, title: "是否为虚拟卡", callback: function(cdata) {
                var isVirtualCard = "<span class='f-toe f-db'>";
                if(dyCom.stringFiltedNull(cdata.isVirtualCard)){
                    if(cdata.isVirtualCard === '1'){
                        isVirtualCard += '电子卡';
                    }else {
                        isVirtualCard += '实体卡';
                    }

                }
                isVirtualCard += "</span>";
                return isVirtualCard;
            }},
            { field: "buyPrice", width: 150, title: "单价", callback: function(cdata) {
                return "<span class='f-toe f-db'>"+dyCom.numberFormat(cdata.cardPrice/100, 2, '.')+"</span>"
            }},
            { field: "buyQuantity", width: 100, title: "购买数量", callback: function(cdata) {
                return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.buyNumber)+"</span>"
            }}
        ];
        if('eb' == type){
            colsList =[
                {
                    type: "numbers",
                    field: "nums",
                    title: "NO.",
                    width: 50
                }, //序列号
                { field: "cm", width: 150, title: "商品",callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+ dyCom.stringFiltedNull(cdata.cmName)+"</span>"
                }},
                { field: "skuName", width: 150, title: "SKU", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.skuName)+"</span>"
                }},
                { field: "buyPrice", width: 150, title: "单价", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.buyPrice)+"</span>"
                }},
                { field: "buyQuantity", width: 100, title: "购买数量", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.buyQuantity)+"</span>"
                }}
            ];

        }

        var tableOption = {
            elem: "#orderDetailList",
            data: dataList.result,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            width: "100%",
            height: "auto",  //结合isNoFullScreen使用
            isNoFullScreen:true, //不全屏计算高度  height 必须设置auto
            trData: [],
            cols: colsList,
            init: function() {
                //初始化方法
            }
        };
        dyPlugins.Table.createTable(tableOption, 0);
    }

    /*
     查询发卡明细列表
     */
    function queryMcardSendAjax() {
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardorders/'+orderId+'/delivers'+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setMCardOrderDeliverDetailList(data);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    function setMCardOrderDeliverDetailList(dataList) {
        if(!dataList.result){
            dataList.result = [];
        };

        var tableOption = {
            elem: "#deliverList",
            data: dataList.result,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            width: "100%",
            height: "100",
            trData: [],
            cols: [
                {
                    type: "numbers",
                    field: "nums",
                    title: "NO.",
                    width: 50
                }, //序列号
                { field: "typeName", width: 250, title: "卡类型",callback: function(cdata) {
                    var name = "<span class='f-toe f-db'>";
                    if(dyCom.stringFiltedNull(cdata.typeName)){
                        name += cdata.typeName;
                    }
                    if(dyCom.stringFiltedNull(cdata.childtypeName)){
                        name += '--';
                        name += cdata.childtypeName;
                    }
                    name += "</span>";
                    return name;

                }},
                { field: "deliverQuantity", width: 100, title: "是否为虚拟卡", callback: function(cdata) {
                    var isVirtualCard = "<span class='f-toe f-db'>";
                    if(dyCom.stringFiltedNull(cdata.isVirtualCard)){
                        if(cdata.isVirtualCard === '1'){
                            isVirtualCard += '电子卡';
                        }else {
                            isVirtualCard += '实体卡';
                        }

                    }
                    isVirtualCard += "</span>";
                    return isVirtualCard;
                }},
                { field: "deliverQuantity", width: 100, title: "发货数量", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.deliverQuantity)+"</span>"
                }},
                { field: "cardNum", width: 200, title: "卡号", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.cardNum)+"</span>"
                }}
            ],
            init: function() {
                //初始化方法

            }
        };
        dyPlugins.Table.createTable(tableOption, 0);
    }

    //渲染操作按钮
    function setOptionBtns(saleBoId,orderBiztype,orderStatus){
        if(!orderStatus){
            return false;
        }
        //操作
        //{'id':3,label:'支付',url:'',role:['0']},
        var optionBtnList = [
            {'id':1,label:'取消',url:'/mcardorders/cancel',role:['9']},
            {'id':2,label:'确认',url:'/mcardorders/verify',role:['9']},
            {'id':4,label:'发货',url:'/mcardorders/deliver',role:['2']},
//            {'id':5,label:'收货确认',url:'/mcardorders/receipt',role:['8']},
            {'id':6,label:'取货验证',url:'/mcardorders/pickup',role:['2']},
//            {'id':7,label:'退款',url:'/mcardorders/refund/apply',role:['2','8','3']},
//            {'id':8,label:'退款确认',url:'/mcardorders/refund/verify',role:['4']},
        ];
        var btnHtml = '';
        /*兼容 和谐酒业 赠品发货*/
        if(saleBoId == sale_bo_id && orderBiztype == order_biz_type && orderStatus == order_status){
            btnHtml += '<li><a href="'+ctx+'/mcardorders/deliver?orderId='+orderId+'">发货</a></li>';
            btnHtml += '<li><a href="'+ctx+'/mcardorders/pickup?orderId='+orderId+'">取货验证</a></li>';
        }

        $(optionBtnList).each(function (i,n) {
            var arrayRole = n.role;
            if(arrayRole.length && arrayRole.indexOf(orderStatus)>-1){
                btnHtml += '<li><a href="'+ctx+n.url+'?orderId='+orderId+'">'+n.label+'</a></li>';
            }
        });

        $('#optionBtns').html(btnHtml);
    }

    /*渲染订单提示信息*/
    function setPromptMsg(saleBoId,orderBiztype,orderStatus){
        var prompt = '';

        /*兼容 和谐酒业*/
        if(saleBoId == sale_bo_id){
            if(orderBiztype == 'mcard'){//卡订单
                if(orderStatus == '2'){//已支付
                    prompt = '当前订单为卡订单，请及时对实体卡券和赠品（小康红坛酒）进行发货！';
                }else if(orderStatus == '8'){//已发货
                    prompt = '当前订单为卡订单，虚拟卡已通过短信形式发货给买家，请及时对赠品（小康红坛酒）进行发货！';
                }else if(orderStatus == '3'){//已完成
                    prompt = '订单已发货，请做好客户售后服务！';
                }
            }else {//商品订单
                if(orderStatus == '2'){//已支付
                    prompt = '当前订单为商品订单，请及时对商品和赠卡进行发货！';
                }else if(orderStatus == '8'){//已发货
                    prompt = '当前订单为商品订单，已发货，请做好客户售后服务！';
                }else if(orderStatus == '3'){//已完成
                    prompt = '当前订单为商品订单，已发货，请做好客户售后服务！';
                }
            }

        }

        /*显示提示文字*/
        $('#promptMsg').html(prompt);

    }

</script>
</body>
</html>
