<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<c:set var="static_js" value="${pageContext.request.contextPath}/static/js"/>
<c:set var="static_css" value="${pageContext.request.contextPath}/static/css"/>
<c:set var="static_images" value="${pageContext.request.contextPath}/static/images"/>
<c:set var="dist_bootstrap" value="${pageContext.request.contextPath}/dist/lib/bootstrap/"/>
<c:set var="dist_jquery" value="${pageContext.request.contextPath}/dist/lib/jquery"/>
<c:set var="dist_styles" value="${pageContext.request.contextPath}/dist/styles"/>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="edge"/>
    <meta name="viewport"
          content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no"/>
    <title>会员卡管理-卡升级</title>
    <link href="${static_css}/bootstrap.min.css" rel="stylesheet">
    <link href="${static_css}/common.css" rel="stylesheet">
</head>

<body>
<div class="body-div" id="loading">

    <!--下部-->
    <div class="main-content">
        <div class="title">
        	<span>
        		卡升级
        	</span>
        </div>
        <div class="col-xs-12 swlDetail">
            <div class="col-xs-12 data-range">
                <div class="widget-box">
                    <form action="" method="post">
                        <div
                                style="background-color: #FFFFFF;border: 1px solid #DEDEDE;width: 98%;margin-left: auto;margin-right: auto;margin-top: 10px;">
                            <div
                                    style="background-color: #CC00FF;margin-top: 10px;margin-left: 5px;margin-right: 5px;"
                                    align="center">
                                <div style="width: 100%; height: 10px;"></div>
                                <span
                                        style="font-size: 20px;color: #FFFFFF;font-weight: bold;letter-spacing: 1px;">旅游卡升级</span><br/>
                                <div style="width: 100%; height: 10px;"></div>
                            </div>
                            <div style="width: 98%;" align="center">
                                <c:if test="${actionBean.cardUpgradeList != null}">
                                    <c:forEach var="card" items="${actionBean.cardUpgradeList}">
                                        <div align="center" style="width: 100%;margin: 5px;font-size: 16px;">
                                            <table class="table table-bordered" style="width: 98%">
                                                <tr style="height: 40px;">
                                                    <td style="height: 40px;font-size: 18px; width:32%;" align="right">
                                                        卡号：
                                                    </td>
                                                    <td style="height: 40px;font-size: 18px; width:68%;">
                                                            ${card.cardNum}
                                                    </td>
                                                </tr>
                                                <tr style="height: 40px;">
                                                    <td style="height: 40px;font-size: 18px; width:32%;" align="right">
                                                        卡类型：
                                                    </td>
                                                    <td style="height: 40px;font-size: 18px; width:68%;">
                                                            ${card.cardTypeName}
                                                    </td>
                                                </tr>
                                                <tr style="height: 40px;">
                                                    <td style="height: 40px;font-size: 18px; width:32%;" align="right">
                                                        卡类型：
                                                    </td>
                                                    <td style="height: 40px;font-size: 18px; width:68%;">
                                                        <c:if test="${card.cardStatus == '0' }">待售</c:if>
                                                        <c:if test="${card.cardStatus == '01' }">已售待支付</c:if>
                                                        <c:if test="${card.cardStatus == '1' }">待绑定</c:if>
                                                        <c:if test="${card.cardStatus == '2' }">正常</c:if>
                                                        <c:if test="${card.cardStatus == '3' }">挂失</c:if>
                                                        <c:if test="${card.cardStatus == '4' }">过期</c:if>
                                                        <c:if test="${card.cardStatus == '5' }">损坏</c:if>
                                                        <c:if test="${card.cardStatus == '6' }">冻结</c:if>
                                                        <c:if test="${card.cardStatus == '9' }">待售</c:if>
                                                    </td>
                                                </tr>
                                                <tr style="height: 40px;">
                                                    <td style="height: 40px;font-size: 18px; width:32%;" align="right">
                                                        有效期：
                                                    </td>
                                                    <td style="height: 40px;font-size: 18px; width:68%;">
                                                            ${card.validity}
                                                    </td>
                                                </tr>
                                                <tr style="height: 40px;">
                                                    <td style="height: 40px;font-size: 18px; width:32%;" align="right">
                                                        姓名：
                                                    </td>
                                                    <td style="height: 40px;font-size: 18px; width:68%;">
                                                            ${card.userName}
                                                    </td>
                                                </tr>
                                                <tr style="height: 40px;">
                                                    <td style="height: 40px;font-size: 18px;vertical-align: middle;width:32%;"
                                                        align="right">手机号：
                                                    </td>
                                                    <td style="height: 40px;font-size: 18px; width:68%;">
                                                            ${card.mobile}
                                                        <c:if test="${card.mobile == null  &&card.cardStatus == '2'}">
                                                            <text name="mobile" onblur="getMobile()" style="height: 40px;font-size: 15px;border: 1px solid #DEDEDE;" id="mobile"/><br/>
                                                            <lable style="font-size: 15px; color:red;">
                                                                请录入正确手机号，否则会影响会员卡使用。
                                                            </lable>
                                                        </c:if>
                                                    </td>
                                                </tr>
                                                <tr style="height: 40px;">
                                                    <td style="height: 40px;font-size: 18px; width:32%;" align="right">
                                                        证件类型：
                                                    </td>
                                                    <td style="height: 40px;font-size: 18px; width:68%;">
                                                        <c:if test="${card.certificateType != null && card.certificateType !='' }">
                                                            <c:if test="${card.certificateType == '10' }">身份证</c:if>
                                                            <c:if test="${card.certificateType == 'C' }">港澳通行证</c:if>
                                                            <c:if test="${card.certificateType == 'G' }">台胞证</c:if>
                                                            <c:if test="${card.certificateType == 'B' }">护照</c:if>
                                                        </c:if>
                                                    </td>
                                                </tr>
                                                <tr style="height: 40px;">
                                                    <td style="height: 40px;font-size: 18px; width:32%;" align="right">
                                                        证件号：
                                                    </td>
                                                    <td style="height: 40px;font-size: 18px; width:68%;">
                                                            ${card.certificateNumber}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <c:if test="${card.upgradeStrategies != null &&card.cardStatus == '2'}">
                                                        <td colspan="2">
                                                            <div align="center" style="margin: 5px;font-size: 16px;">
                                                                <c:forEach var="strategy"
                                                                           items="${card.upgradeStrategies}">
                                                                    <div align="center"
                                                                         style="margin: 10px;font-size: 16px;">
                                                                        <table class="table table-bordered"
                                                                               style="width: 100%">
                                                                            <tr style="height: 40px;">
                                                                                <td style="height: 35px;font-size: 15px;width:39%;vertical-align: middle;"
                                                                                    align="right">升级卡类型：
                                                                                </td>
                                                                                <td style="height: 35px;font-size: 15px;width:61%;">
                                                                                        ${strategy.typeName}
                                                                                </td>
                                                                            </tr>
                                                                            <tr style="height: 40px;">
                                                                                <td style="height: 35px;font-size: 15px;width:39%;vertical-align: middle;"
                                                                                    align="right">费用：
                                                                                </td>
                                                                                <td style="height: 35px;font-size: 15px;width:61%;">
                                                                                        ${strategy.upgradePrice/100}元
                                                                                </td>
                                                                            </tr>
                                                                            <tr style="height: 40px;">
                                                                                <td colspan="2" align="center">
                                                                                    <submit name="upgrade"
                                                                                            onclick="window.location='CardUpgrade.action?upgradeOrderDo&cardId=${card.cardId}&upgradeTypeId=${strategy.typeId}&mobileParam='+getMobile();"
                                                                                            style="width: 50%; height: 40px;font-size: 20px;background-color: #CC00FF;border: 0px;color: #FFFFFF;">
                                                                                        升级</submit>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                </c:forEach>
                                                            </div>
                                                        </td>
                                                    </c:if>

                                                </tr>
                                                <c:if test="${card.cardStatus == '1'}">
                                                    <tr>
                                                        <td colspan="2" align="center">
                                                            <font color="red">待绑定旅游卡请先进行绑定，再进行旅游卡升级！</font>
                                                        </td>
                                                    </tr>
                                                </c:if>

                                            </table>
                                        </div>
                                    </c:forEach>
                                </c:if>
                                <div align="center">
                                    <button name="inputCardNum" style="width: 40%; height: 40px;font-size: 20px;background-color: #CC00FF;border: 0px;color: #FFFFFF; " onclick="history.go(-1)">返回</button>
                                </div>
                            </div>

                            <div style="width: 100%; height: 50px;"></div>
                            <br>
                            <div class="container "
                                 style="width: 98%;background-color: #EDEEF0;margin-top: 10px;margin-left: auto;margin-right: auto;margin-bottom: 10px;"
                                 align="left">
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

</div>
</body>
<script src="${dist_jquery}/jquery.js" type="text/javascript" charset="utf-8"></script>
<script src="${dist_bootstrap}/bootstrap.min.js" type="text/javascript" charset="utf-8"></script>
</html>
