<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>B2B销售</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--引入私有css文件 下拉框-->
    <link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />

    <style>
        .m-search-list .search-form {
            width: calc(100% - 125px);
        }
        .s-c-red {
            color: red;
        }
    </style>
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>

        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icondingdan"></i>
                  <span class="name-text">B2B销售下单</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main main-block">
        <!--业务模块-->
        <div class="m-grid">
            <div class="row f-mt15">
                <div class="col-md-6">
                    <div class="s-bg-f2f2f2" style="height: 730px; overflow-y: auto;">
                        <div class="main-block">
                            <div class="m-table-list">
                                <div class="m-search-list">
                                    <div class="search-form">
                                        <div class="row">
                                            <div class="col-md-6 col-sm-6 col-xs-12">
                                                <div class="form-item">
                                                    <input placeholder="请输入会员卡名称" id="childtypeName">
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-sm-6 col-xs-12">
                                                <div class="form-item f-fl" style="width: calc(50% - 2.5px);">
                                                    <input placeholder="请输入最低价格" id="minPrice">
                                                </div>
                                                <div class="form-item f-fl f-ml5" style="width: calc(50% - 2.5px);">
                                                    <input placeholder="请输入最高价格" id="maxPrice">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6 col-sm-6 col-xs-12">
                                                <div class="form-item">
                                                    <div id="selectTypeScope"></div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-sm-6 col-xs-12">
                                                <div class="form-item">
                                                    <div id="selectAgency" class="f-dn"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="search-btn">
                                        <button type="button" class="u-btn u-btn-primary u-btn-sm" id="searchSubmit">
                                            搜索
                                        </button><br>
                                        <%--TODO 扫码添加商品--%>
                                        <%--<button type="button" class="u-btn u-btn-primary u-btn-sm f-mt5" id="scanCodeAddtype">
                                            扫描添加商品
                                        </button>--%>
                                    </div>
                                </div>
                                <section class="content f-mt20">
                                    <table>
                                        <thead>
                                        <tr>
                                            <th class="m-table-col-2">No.</th>
                                            <th class="m-table-col-8">商品图片</th>
                                            <th class="m-table-col-12">商品信息</th>
                                            <th class="m-table-col-2">操作</th>
                                        </tr>
                                        </thead>
                                        <tbody id="dataList">

                                        </tbody>
                                    </table>
                                </section>
                                <!--分页开始-->
                                <div id="pagesList" class="f-mt20"></div>
                                <!--分页结束-->
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6" style="border-left: solid 1px #0aabf6;">
                    <div class="s-bg-f2f2f2">
                        <div class="main-block">
                            <div class="m-table-list" style="height: 420px; overflow-y: auto;">
                                <header class="title"><span>已选商品</span></header>
                                <section class="content f-mt20">
                                    <table>
                                        <thead>
                                        <tr>
                                            <th class="m-table-col-1">No.</th>
                                            <th class="m-table-col-8">商品图片</th>
                                            <th class="m-table-col-11">商品信息</th>
                                            <th class="m-table-col-4">操作</th>
                                        </tr>
                                        </thead>
                                        <tbody id="shoppingList">

                                        </tbody>
                                    </table>
                                    <div style="z-index: 20; position: absolute; right: 50px; top: 450px;">
                                        <span>总计：</span>￥<span id="totalPrice" class="s-c-red"></span>
                                    </div>
                                </section>
                            </div>
                            <div class="m-form-list f-mt15">
                                <header class="title"><span class="f-fs22">销售信息</span></header>
                                <div class="list-item">
                                    <div class="item-label">
                                        <span>销售人员</span>
                                    </div>
                                    <div class="item-form">
                                        <input type="hidden" id="saleAccountId">
                                        <div class="single-line-text" id="saleAccountName">${tokenInfo.userName}</div>
                                    </div>
                                </div>
                                <div class="list-item">
                                    <div class="item-label">
                                        <span>分销商</span>
                                    </div>
                                    <div class="item-form">
                                        <input placeholder="请选择" id="userName" readonly>
                                    </div>
                                </div>
                                <div class="list-item">
                                    <div class="item-label">
                                        <span>联系方式</span>
                                    </div>
                                    <div class="item-form">
                                        <input placeholder="请输入" id="mobile">
                                    </div>
                                </div>
                                <div class="list-item">
                                    <div class="item-label">
                                        <span>收货地址</span>
                                    </div>
                                    <div class="item-form">
                                        <input placeholder="请输入" id="lgAddrress">
                                    </div>
                                </div>
                                <div class="list-item">
                                    <button type="button" class="u-btn u-btn-primary u-btn-md" id="submitOrder">
                                        下单
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--业务模块结束-->
    </section>
    <!--内容区结束-->
</div>
<%--待选商品列表模板 开始--%>
<div id="templateWait">
    <table>
        <tbody>
        <tr>
            <td>
                <div class="f-tac no"></div>
            </td>
            <td>
                <div class="f-tac">
                    <img class="typeImage" style="width: 200px; height: auto;">
                </div>
            </td>
            <td>
                <div class="f-tal typeInfo"></div>
            </td>
            <td>
                <div class="f-tac option"></div>
            </td>
        </tr>
        </tbody>
    </table>
</div>
<%--待选商品列表模板 结束--%>
<%--商品名字模板 开始--%>
<div id="template-childtypeName" class="main-block f-dn">
    <div class="m-grid">
        <div><span class="childtypeName">商品名字</span></div>
        <div class="f-mt5"><span>供销商：</span><span class="agencyName"></span></div>
        <div class="f-cb f-mt5">
            <div class="f-fl"><span>虚拟卡：</span><span class="isVirtualCard"></span></div>
            <div class="f-fr"><span>单价：</span>￥<span class="cardPrice s-c-red"></span></div>
        </div>
    </div>
</div>
<%--商品名字模板 结束--%>
<%--购物车商品模板 开始--%>
<div id="templateShopping" class="main-block f-dn">
    <div class="m-grid">
        <div><span class="childtypeName">商品名字</span></div>
        <div class="f-mt5"><span>供销商：</span><span class="agencyName"></span></div>
        <div class="f-cb f-mt5">
            <div class="f-fr f-mr15"><span>合计：</span>￥<span class="subtotal s-c-red"></span></div>
            <div class="f-fr f-mr15"><span>单价：</span>￥<span class="cardPrice s-c-red"></span></div>
        </div>
    </div>
</div>
<%--购物车商品模板 结束--%>
<%--数量加减模板 开始--%>
<div id="templateAddSubtract" class="f-dn">
    <div style="position: relative; margin-top: 40px;">
        <button type="button" class="u-btn u-btn-default-outline u-btn-xs" id="add">
            +
        </button>
        <input type="number" class="typeNumber" style="width: 35px;" id="typeNumber">
        <button type="button" class="u-btn u-btn-default-outline u-btn-xs" id="subtract">
            -
        </button>
    </div>
</div>
<%--数量加减模板 结束--%>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 时间组件-->
<!--js引入私有 下拉选择组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/select/pc/dist/js/select.js?v=1"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>
<%--js引入私有 静态资源--%>
<script type="text/javascript" charset="utf-8"  src="${pageContext.request.contextPath}/static_new_new/js/data/mcardConstant.js"></script>
<script type="text/javascript" charset="utf-8"  src="${pageContext.request.contextPath}/static_new_new/js/data/common.js"></script>

<script>
    //分页
    var pageSize = 8; //每页多少条
    var pageIndex = 0; //当前页

    /*1.初始化*/
    $().ready(function(){
        //初始化商品范围
        initTypeScope();

        //查询分销商列表
        queryAgencyList();

        //查询销售的商品列表
        queryTypeList();

        //搜索按钮事件监听
        $('#searchSubmit').off('click').on('click',function(){
            queryTypeList();
        });
        //下单按钮事件
        $('#submitOrder').off('click').on('click', function () {
            submitOrder();
        });

        //选择客户时触发选择分销商组件
        $('#userName').off('click').on('click', function () {
            stakeholdersRepositoryitems();
        });
    });
    /* 2.业务方法  */
    //查询分销商参数
    function queryAgencyParam() {
        //处理参数
        var paramsStr = '?';

        //处理分页
        var paramsJson = [
            'page=0',
            'size=100'
        ];

        if(token){
            paramsJson.push('token='+token);
        }

        //拼装参数
        paramsStr += paramsJson.join('&');

        //返回
        return paramsStr;
    }
    //查询分销商列表
    function queryAgencyList(){
        var svrParamsString = queryAgencyParam(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/ebsvr/agencys/ag/mine/agencys' +svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setAgencySelect(data.result);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充分销商下拉框
    function setAgencySelect(dataList) {
        if (dataList) {
            var agencyList = [];
            $.each(dataList, function (i, obj) {
                var agencyItem = {
                    'id': obj.supplierBoId,
                    'value': obj.supplierBoName
                }
                agencyList.push(agencyItem);
            });

            //初始化供应商下拉框
            var option = {
                domId: "#selectAgency",
                selectName: "供应商",
                keyName: "value",
                valueName: "id",
                selectedValue: ""
            };
            option.callback = function(selectObj) {
            };
            dyPlugins.selectModel.init(option, agencyList);
        }
    }

    //查询商品列表参数
    function queryTypeParam() {
        //处理参数
        var paramsStr = '?';
        var childtypeNameParam = $('#childtypeName').val();       //商品名称
        //接口暂不支持售价区间条件选择

        //处理分页
        var paramsJson = [
            'page=' + pageIndex,
            'size=' + pageSize
        ];

        if(token){
            paramsJson.push('token='+token);
        }
        if (childtypeNameParam) {
            paramsJson.push('childtypeName='+childtypeNameParam);
        }

        //查询可以进行销售的子卡类型
        paramsJson.push('typeStatus=11');       //卡类型状态：11 正常
        paramsJson.push('status=11');           //子卡状态：11 正常

        //拼装参数
        paramsStr += paramsJson.join('&');

        //返回
        return paramsStr;
    }
    //查询商品列表
    function queryTypeList() {
        var svrParamsString = queryTypeParam(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

        //根据商品范围动态调整接口地址
        var typeScope = $('#selectTypeScope select').val();
        var paramsJson = {
            restPath: ''
        };
        if ('1' == typeScope) {
            paramsJson.restPath = encodeURI('/mcardsvr/mcardtypes/sp/mine/childtypes' +svrParamsString);
        }else {
            paramsJson.restPath = encodeURI('/mcardsvr/mcardtypes/ag/mine/childtypes' +svrParamsString);
        }

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setTypeList(data.result);

                //2 分页处理
                if (data.totalPage) {
                    dyPlugins.Page.init("pagesList",data.totalPage,data.currPage,data.pageSize,data.totalRows,function(data){
                        pageIndex = data.curr;
                        queryTypeList();
                    });
                }
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充商品列表
    function setTypeList(dataList) {
        //清空商品列表
        $("#dataList").html('');
        if(dataList){
            var num = 0;        //序号
            $.each(dataList, function (i, obj) {
                /*克隆table 模板*/
                var itemClone = $('#templateWait tr').clone();
                /*赋值*/
                //编号
                num = num+1;
                itemClone.find('.no').html(num);

                //商品图片
                itemClone.find('.typeImage').attr('src', '<%=baseResourcePath%>/rbweb/files/owner/'+obj.childtypeId+'/IMG?token='+token);

                //拼装商品信息展示块
                var typeClone = $('#template-childtypeName>.m-grid');

                //商品名字
                typeClone.find('.childtypeName').text(dyCom.stringFiltedNull(obj.childtypeName));
                //分销商
                var agencyName = '';
                var self = $('#selectTypeScope select').val();
                if ('1' == self) {
                    agencyName = '自营-' + dyCom.stringFiltedNull(obj.cardType.mcName);
                }else {
                    agencyName = '非自营-' + dyCom.stringFiltedNull(obj.cardType.mcName);
                }
                typeClone.find('.agencyName').text(agencyName);
                //是否虚拟卡
                var virtualCard = getValue(isVirtualCard, obj.isVirtualCard);
                typeClone.find('.isVirtualCard').text(virtualCard);

                //价格
                var price = dyCom.numDiv(dyCom.stringFiltedNull(obj.cardPrice), '100');
                typeClone.find('.cardPrice').text(price);
                itemClone.find('.typeInfo').html(typeClone.html());

                //商品ID
                var btnHtml = '<button type="button" class="u-btn u-btn-primary-outline u-btn-xs">添加</button>';
                var btnObj = $(btnHtml).data('id', obj.childtypeId);
                var typeJson = JSON.stringify(obj);
                btnObj.data('info', typeJson);
                //将不可销售的子卡类型添加按钮置灰，且不可点击
                if ('11' != obj.status) {
                    btnObj.attr('disabled', 'disabled');
                    btnObj.removeClass('u-btn-primary-outline');
                    btnObj.addClass('u-btn-disabled-outline');
                }
                itemClone.find('.option').append(btnObj);

                /*追加HTML*/
                $("#dataList").append(itemClone);
            });
            //点击添加按钮，选中商品
            $('#dataList tr button').off('click').on('click',function(){
                var typeInfo = $(this).data('info');
                addShopping(typeInfo);
            })
        }else {
            $("#dataList").html('<tr><td colspan="5"><div class="f-tac">暂无数据</div></td></tr>');
        }
    }
    //加入购物车
    function addShopping(typeJson) {
        if (typeJson) {
            var obj = JSON.parse(typeJson);

            var num = $("#shoppingList>tr").length;

            //商品添加的校验
            var flag = addRepetition(obj)
            if (flag == false) {
                /*克隆table 模板*/
                var itemClone = $('#templateWait tr').clone();
                /*赋值*/
                //编号
                num = num+1;
                itemClone.find('.no').html(num);

                //商品图片
                itemClone.find('.typeImage').attr('src', '<%=baseResourcePath%>/rbweb/files/owner/'+obj.childtypeId+'/IMG?token='+token);

                //拼装商品信息展示块
                var typeClone = $('#templateShopping>.m-grid');

                //商品名字
                typeClone.find('.childtypeName').text(dyCom.stringFiltedNull(obj.childtypeName));
                //分销商
                var agencyName = '';
                var self = $('#selectTypeScope select').val();
                if ('1' == self) {
                    agencyName = '自营-' + dyCom.stringFiltedNull(obj.cardType.mcName);
                }else {
                    agencyName = '非自营-' + dyCom.stringFiltedNull(obj.cardType.mcName);
                }
                typeClone.find('.agencyName').text(agencyName);

                //价格
                var price = dyCom.numDiv(dyCom.stringFiltedNull(obj.cardPrice), '100');
                typeClone.find('.cardPrice').text(price);

                //小计
                typeClone.find('.subtotal').text(price);
                itemClone.find('.typeInfo').html(typeClone.html());

                //移除按钮
                var btnHtml = '<button type="button" class="u-btn u-btn-primary-outline u-btn-xs remove">移除</button>';
                var btnObj = $(btnHtml).data('id', obj.childtypeId);
                var typeJson = JSON.stringify(obj);
                btnObj.data('info', typeJson);
                itemClone.find('.option').append(btnObj);

                //商品数量变更
                var addSubtractTemplate = $('#templateAddSubtract>div').clone();
                addSubtractTemplate.find('.typeNumber').val(1);
                itemClone.find('.option').append(addSubtractTemplate);

                //商品ID
                itemClone.data('id', obj.childtypeId);
                //卡类型ID
                itemClone.data('typeid', obj.typeId);
                //商铺ID
                itemClone.data('mcid', obj.cardType.mcId);
                //商铺名称
                itemClone.data('mcname', obj.cardType.mcName);

                /*追加HTML*/
                $("#shoppingList").append(itemClone);

                //添加数量按钮事件
                $('#shoppingList .option #add').off('click').on('click', function () {
                    var dom = $(this).nextAll('.typeNumber');
                    var total = dom.val();
                    dom.val(++total);
                    //计算小计金额
                    totalPrice(total, $(this));
                    //更新总计金额
                    sumPrice();
                });
                //减少数量按钮事件
                $('#shoppingList .option #subtract').off('click').on('click', function () {
                    var dom = $(this).prevAll('.typeNumber');
                    var total = dom.val();
                    if (total > 1) {
                        total--;
                    }
                    dom.val(total);
                    //计算小计金额
                    totalPrice(total, $(this));
                    //更新总计金额
                    sumPrice();
                });
                //移除商品按钮事件
                $('#shoppingList .option .remove').off('click').on('click', function () {
                    //移除tr元素
                    $(this).parent().parent().parent().remove();
                    //更新购物车序号
                    updateNo();
                    //更新总计金额
                    sumPrice();
                });
            } else if (flag == 'mcId') {
                //商铺不一致，提示用户无法同时下单
                layer.msg('当前选中的商品：【' + obj.childtypeName + '】,与已选商品不是一个店铺的，无法同时下单！');
            }
            //更新总计金额
            sumPrice();
        }
    }
    //计算小计价格
    function totalPrice(total, dom) {
        var trDom = dom.parent().parent().parent().parent();
        //单价
        var price = trDom.find('.cardPrice').text();

        //计算小计金额
        var totalPrice = dyCom.numMulti(total, price);
        //填充小计金额
        trDom.find('.subtotal').text(totalPrice);

    }
    //计算总计金额
    function sumPrice() {
        var sumPrice = 0;
        $('#shoppingList>tr').each(function (i, obj) {
            var subtotal = $(obj).find('.subtotal').text();
            sumPrice = dyCom.numAdd(sumPrice, subtotal);
        });
        $('#totalPrice').text(sumPrice);
    }
    //商品添加购物车校验
    function addRepetition(typeInfo) {
        var flag = false;       //标记商品是否重复
        $('#shoppingList>tr').each(function (i, obj) {
            //判断商品ID是否重复
            if (typeInfo.childtypeId == $(obj).data('id')) {
                //修改标记
                flag = true;
                //触发加一按钮
                $(obj).find('#add').trigger('click');
                //结束遍历
                return false;
            }
            //判断商铺是否一致
            if (typeInfo.cardType.mcId != $(obj).data('mcid')) {
                flag = 'mcId';
            }
        });
        //返回结果
        return flag;
    }
    //更新购物车序号
    function updateNo() {
        $('#shoppingList>tr').each(function (i, obj) {
            var no = i + 1;
            $(obj).find('.no').text(no);
        });
    }

    //获取提交订单参数
    function getOrderParam() {
        var mcId = $('#shoppingList>tr:first-child').data('mcid');

        //遍历已选商品
        var typeList = [];
        $('#shoppingList>tr').each(function (i, obj) {
            var typeInfo = {
                typeId: $(obj).data('typeid'),
                childtypeId: $(obj).data('id'),
                buyNumber: $(obj).find('#typeNumber').val()
            }
            typeList.push(typeInfo);
        });
        //填充订单信息
        var paramsStr = {
            'buyerId': $('#buyerId').val(),
            'userName': $('#userName').val(),
            'mobile': $('#mobile').val(),
            'mcId': mcId,
            'mcName': $('#shoppingList>tr:first-child').data('mcname'),
            'lgAddrress': $('#lgAddrress').val(),
            'orderDetails': typeList
        };
        return paramsStr;
    }
    //下单操作
    function submitOrder() {
        var svrParamsString = getOrderParam(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

        //ajax请求配置
        var optionsAjax = {
            url: ctx + '/ajax/post?restPath=' + encodeURIComponent('/mcardsvr/mcardorders/saleB2B?token=' + token) + '&token=' + token,  //请求url
            type: "post",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data: JSON.stringify({appData: svrParamsString})
        }
        optionsAjax.callback = function (type, data) {
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if (type == 1) {
                layer.msg('下单成功！', function () {
                    //TODO 下单成功后的支付设计待确认
                    location.href = ctx + '/mcardorders/saleB2B';
                });
            } else {
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    //初始化商品范围
    function initTypeScope() {
        //商品范围枚举值
        var typeScopeList = [
            {
                id: '1',
                value: '自营'
            },
            {
                id: '0',
                value: '非自营'
            }
        ];
        //初始化商品范围下拉框
        var option = {
            domId: "#selectTypeScope",
            selectName: "商品范围",
            keyName: "value",
            valueName: "id",
            selectedValue: "1"
        };
        option.callback = function(selectObj) {
            if (0 == selectObj.value) {
                $('#selectAgency').removeClass('f-dn');
            } else if (1 == selectObj.value) {
                $('#selectAgency').addClass('f-dn');
            }
        };
        dyPlugins.selectModel.init(option, typeScopeList);
        //移除请选择的option
        $('#selectTypeScope .dyui-select-tips').remove();
    }

    //父页面需要调用的方法 弹出层
    function stakeholdersRepositoryitems(){
        var childWindow = null;
        layer.open({
            id:'selectRepLayer',
            type: 2,
            title: '选中分销商',
            shadeClose: true,
            shade: 0.6,
            maxmin: true, //开启最大化最小化按钮
            area: ['750px', '660px'],
            content: ctx_rbweb + '/stakeholders/COARS?tabTitleList=10&token='+token,
            success:function(ee){
                //初始化完成之后  例如修改的时候 需要处理
                var frameId=document.getElementById('selectRepLayer').getElementsByTagName("iframe")[0].id;
                childWindow = $('#'+frameId)[0].contentWindow;
                /*回显内容  必要的项 {curTempType,decisionMaker,curTempId,curTempName,organ:{organId:,organName}} organ 只有是组织下的人员才会有
                childWindow.setItemsList([]);*/

            },
            btn: ['确定', '取消'],
            yes: function (index) {
                var datalist = childWindow.getItemsList();
                if (datalist && datalist.length > 0) {
                    //填充分销商名字
                    var buyerId = datalist[0].customerId;
                    $('#buyerId').val(buyerId);
                    $('#userName').val(datalist[0].customerName);
                    //查询分销商信息填充客户手机号、地址等信息
                    queryCustomerList(buyerId);
                }
                console.log(datalist);
                layer.close(index);
            },
            btn2: function (index) {

            }
        });
    }

    //查询商品列表参数
    function queryCustomerParam() {
        //处理参数
        var paramsStr = '?';

        var paramsJson = [];

        if(token){
            paramsJson.push('token='+token);
        }
        //拼装参数
        paramsStr += paramsJson.join('&');

        //返回
        return paramsStr;
    }
    //查询实体信息
    function queryCustomerList(boId) {
        var svrParamsString = queryCustomerParam(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

        var paramsJson = {
            restPath: encodeURI('/rbsvr/customers/'+ boId +svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setCustomerInfo(data.result);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充分销商信息
    function setCustomerInfo(info) {
        if (info) {
            //联系电话
            $('#mobile').val(info.contactPerson);
            //联系地址
            $('#lgAddrress').val(info.address);
        }
    }
</script>
</body>
</html>