<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<c:set var="static_js" value="${pageContext.request.contextPath}/static/js"/>
<c:set var="static_css" value="${pageContext.request.contextPath}/static/css"/>
<c:set var="static_images" value="${pageContext.request.contextPath}/static/images"/>
<c:set var="dist_bootstrap" value="${pageContext.request.contextPath}/dist/lib/bootstrap/"/>
<c:set var="dist_jquery" value="${pageContext.request.contextPath}/dist/lib/jquery"/>
<c:set var="dist_styles" value="${pageContext.request.contextPath}/dist/styles"/>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="edge" />
    <meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no" />
    <title>会员卡管理-卡续费</title>
    <link href="${static_css}/bootstrap.min.css" rel="stylesheet">
    <link href="${static_css}/common.css" rel="stylesheet">
    <style type="text/css">
        .nav>li{
            width:12%;
        }
        .nav-tabs>li>a {
            background-color: #C8DAF1;
            height: 30px;
            line-height: 30px;
        }
        .nav-tabs>li.active>a, .nav-tabs>li.active>a:focus, .nav-tabs>li.active>a:hover {
            color: #ffffff;
            background-color: #0070C1;
            height: 30px;
            line-height: 30px;
        }

    </style>
</head>

<body>
<div class="body-div" id="loading">

    <!--下部-->
    <div class="main-content">
        <div class="title">
        	<span>
        		卡续费
        	</span>
        </div>
        <div class="col-xs-12 swlDetail">
            <div class="col-xs-12 data-range">
                <div class="widget-box">
                    <div class="widget-content nopadding">
                        <div class="rf-p-hdr panelGridLeft">会员卡续费</div>
                        <div class="rf-p-b">
                            <span class="font_red"></span>
                            <table
                                    style="width:100%;border:0px;cellspacing:0px; cellpadding:0;">
                                <tr>
                                    <td colspan="4" align="center" bgcolor="#FFFFFF" height="1"></td>
                                </tr>
                                <tr>
                                    <td colspan="4" align="center" bgcolor="#D6E6FB" height="30"
                                        style="font-size: 15px;font-weight: bold;">会员卡信息</td>
                                </tr>
                                <tr>
                                    <td colspan="4" align="center" bgcolor="#FFFFFF" height="1"></td>
                                </tr>

                                <tr>

                                    <td width="20%" class="richtable_col_left1">卡号：</td>
                                    <td width="30%" class="richtable_col_right1">${card.cardNum}</td>
                                    <td width="20%" class="richtable_col_left1">卡状态：</td>
                                    <td width="30%" class="richtable_col_right1">${card.cardStatus}</td>
                                </tr>
                                <tr>
                                    <td width="20%" class="richtable_col_left1">激活时间：</td>
                                    <td width="30%" class="richtable_col_right1">
                                        ${card.activateTime}
                                    </td>
                                    <td width="20%" class="richtable_col_left1">有效期：</td>
                                    <td width="30%" class="richtable_col_right1">
                                        <c:if test="${card.validStartDate != null}">
                                            value="${card.validStartDate}
                                        </c:if>-
                                        <c:if test="${card.validEndDate != null}">
                                            ${card.validEndDate}
                                        </c:if>
                                    </td>

                                </tr>
                                <tr>
                                    <td width="20%" class="richtable_col_left1">是否已绑定：</td>
                                    <td width="30%" class="richtable_col_right1"><c:if test="${card.isBind!=null }"><c:choose>
                                        <c:when test="${card.isBind==0}">未绑定</c:when>
                                        <c:otherwise>已绑定</c:otherwise>
                                    </c:choose></c:if>
                                    </td>
                                    <td width="20%" class="richtable_col_left1">是否为实名：</td>
                                    <td width="30%" class="richtable_col_right1"><c:if test="${card.isRealName!=null }"><c:choose>
                                        <c:when test="${card.isRealName==0}">不是实名</c:when>
                                        <c:otherwise>是实名</c:otherwise>
                                    </c:choose></c:if>
                                    </td>
                                </tr>
                                <tr>
                                    <td width="20%" class="richtable_col_left1">用户名称：</td>
                                    <td width="30%" class="richtable_col_right1">${card.userName}</td>
                                    <td width="20%" class="richtable_col_left1">用户手机号：</td>
                                    <td width="30%" class="richtable_col_right1">${card.mobile}</td>
                                </tr>
                                <tr>
                                    <td width="20%" class="richtable_col_left1">是否为虚拟卡：</td>
                                    <td width="30%" class="richtable_col_right1"><c:if test="${card.isVirtualCard!=null }"><c:choose>
                                        <c:when
                                                test="${card.isVirtualCard==0}">实体卡</c:when>
                                        <c:otherwise>虚拟卡</c:otherwise>
                                    </c:choose></c:if>
                                    </td>
                                </tr>
                            <tr>
                                <td colspan="4" align="center" bgcolor="#FFFFFF" height="1"></td>
                            </tr>
                                <tr>
                                    <td colspan="4" align="center" bgcolor="#D6E6FB" height="30"
                                        style="font-size: 15px;font-weight: bold;">续费信息</td>
                                </tr>
                                <tr>
                                    <td width="20%" class="richtable_col_left1">卡类型名称：</td>
                                    <td width="30%" class="richtable_col_right1">
                                        ${actionBean.editFfMcardType.typeName}
                                    </td>
                                    <td width="20%" class="richtable_col_left1">卡面值：</td>
                                    <td width="30%" class="richtable_col_right1">
                                        <fmt:formatNumber
                                                value="${actionBean.editFfMcardType.cardPrice/100}"
                                                pattern="#.##" minFractionDigits="2"/> 元
                                    </td>
                                </tr>
                                <tr>
                                    <td width="20%" class="richtable_col_left1">续费时间：</td>
                                    <td width="30%" class="richtable_col_right1">
                                        ${actionBean.editFfMcardType.validDate}
                                        <c:choose>
                                            <c:when test="${actionBean.editFfMcardType.validUnit=='Y'}">年</c:when>
                                            <c:when test="${actionBean.editFfMcardType.validUnit=='Q'}">季</c:when>
                                            <c:when test="${actionBean.editFfMcardType.validUnit=='M'}">月</c:when>
                                            <c:when test="${actionBean.editFfMcardType.validUnit=='D'}">天</c:when>
                                        </c:choose>
                                    </td>
                                    <td width="20%" class="richtable_col_left1">失效日期：</td>
                                    <td width="30%" class="richtable_col_right1">
                                        <stripes:text name="endDateStr" onclick="WdatePicker()"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4" class="panelGridCenter">
                                        <button type="submit" onclick="renewal()">续  费</button>&nbsp;&nbsp;
                                        <button type="button" onclick="history.go(-1)">返回</button>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

</div>
</body>
<script src="${dist_jquery}/jquery.js" type="text/javascript" charset="utf-8"></script>
<script src="${dist_bootstrap}/bootstrap.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
    //鼠标经过按钮变色
    function currentMenuBtn() {
        $(".menu-btn").mouseover(function(){
            $(this).children().css("background-color","#8EB4E3");
        });
        $(".menu-btn").mouseout(function(){
            $(this).children().css("background-color","#bdbfbe");
        });
    }
    currentMenuBtn();
</script>
<script type="text/javascript">
    function renewal() {
        window.location.href = "${ctx}/ordermgr/orderinfos/11111/222222/tochange";
    }
    
</script>
</html>
