<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>订单管理-取货验证</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />
    <!--表格组件-->
    <link rel="stylesheet" href="${static_plugins}/table/pc/dist/css/table.css" />
    <%--单选框组件样式--%>
    <link rel="stylesheet" type="text/css" href="${static_plugins}/third_party/iCheck-v1.0.2/skins/flat/blue.css"/>
    <style>
        .s-bscB-dee3e6{
            border-bottom: solid 1px #dee3e6;
        }
        .m-header-extend {
            padding-bottom: 10px;
            border-bottom: solid 1px #dee3e6;
        }

        .m-header-extend .header-border {
            height: 20px;
            padding-left: 15px;
            border-left: solid 4px #0aabf6;
        }
        .m-header-extend .header-title {
            width: 100%;
            color: #0aabf6;
            font-size: 14px;
            line-height: 20px;
            overflow: hidden;
            word-wrap: normal;
            white-space: nowrap;
            text-overflow: ellipsis;
            content: "...";
        }
        /*placeholder 颜色*/
        .red::-webkit-input-placeholder{
            color:red;
        }
        .red::-moz-placeholder{   /* Mozilla Firefox 19+ */
            color:red;
        }
        .red:-moz-placeholder{    /* Mozilla Firefox 4 to 18 */
            color:red;
        }
        .red:-ms-input-placeholder{  /* Internet Explorer 10-11 */
            color:red;
        }

        .f-input{
            width: 100%;
            font-size: 14px;
            line-height: 30px;
            padding: 0px 8px;
            border: 1px solid #dee3e6;
            color: #333333;
            outline: none;
            margin-top: 3px;
        }
    </style>
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul id="optionBtns">

        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont icondingdan"></i>
                  <span class="name-text">取货验证</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <!--业务模块-->
        <div id="formValidate" class="main-block">
            <div class="m-table-detail m-form-list m-form-nolabel">
                <header class="title"><span>订单信息</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">
                                订单号
                            </th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="orderId">

                                </div>
                            </td>
                            <th class="m-table-col-4">状态</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="orderStatus">

                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">
                                销售机构
                            </th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="saleBoName">

                                </div>
                            </td>
                            <th class="m-table-col-4">订单金额</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="orderAmount">

                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>买家信息</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">
                                配送方式
                            </th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="showLgSendtype"></div>
                            </td>
                            <th class="m-table-col-4">买家</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" >
                                    <span id="userName"></span>&#12288;&#12288;
                                    <span id="mobile"></span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th class="m-table-col-4">
                                期望配送时间
                            </th>
                            <td class="m-table-col-20 td-edit" colspan="3">
                                <div class="item-form" id="lgSenddate"></div>
                            </td>
                        </tr>
                        <tr class="expressage f-dn">
                            <th class="m-table-col-4">
                                收货人
                            </th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="lgRecipient"></div>
                            </td>
                            <th class="m-table-col-4">收货手机号</th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form" id="lgPhone"></div>
                            </td>
                        </tr>
                        <tr class="expressage f-dn">
                            <th class="m-table-col-4">
                                收货地址
                            </th>
                            <td class="m-table-col-8 td-edit" colspan="3">
                                <div class="item-form">
                                    <span id="lgProvince"></span>&#12288;
                                    <span id="lgCity"></span>&#12288;
                                    <span id="lgCounty"></span>&#12288;
                                    <span id="lgAddrress"></span>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>发货信息</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">
                                发货人
                            </th>
                            <td class="m-table-col-8 td-edit">
                                <input type="hidden" value="${tokenInfo.accountId}"  id="lgSenderId">
                                <div class="item-form" id="lgSenderName">${tokenInfo.userName}</div>
                            </td>
                            <th class="m-table-col-4"></th>
                            <td class="m-table-col-8 td-edit">
                                <div class="item-form"></div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="m-title-alone"><span>订单明细</span></header>
                <section class="content" id="orderDetailList" data-height="300"></section>
                <header id="send-title" class="m-title-alone f-dn" ><span>发货明细</span></header>
                <div id="deliverList" class="content f-mt20 f-dn" data-height="400"></div>
            </div>
        </div>
        <!--业务模块结束-->
    </section>
    <div class="u-btn-fixed-placeholder"></div>
    <div class="f-tac u-btn-fixed-b24">
        <button type="button" class="u-btn u-btn-default step" data-step="2" onclick="history.go(-1)">
            取消
        </button>
        <button id="deliver" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
            完成取货验证
        </button>
    </div>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有-->
<!--js引入私有 多选框组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/third_party/iCheck-v1.0.2/icheck.min.js"></script>
<!--js引入私有 表格组件 依赖于 多选框组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/table/pc/dist/js/table.js"></script>
<%--引入常量数据--%>
<script src="${ctx}/static_new_new/js/data/order_constant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>
<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>
<script>

    /*订单ID*/
    var orderId = dyCom.getUrlParams('orderId');
    /*已支付 订单枚举值*/
    var os2 = '2';
    /*已发货 订单枚举值*/
    var os8 = '8';
    /*订单状态*/
    var oStatus = '';

    /*订单业务类型*/
    var oBiztype = '';
    /*邮寄 枚举值*/
    var inItSendType = '1';
    /*订单配送方式*/
    var sendtype = '';

    /*虚拟卡枚举值*/
    var initVirtual = '1';

    /*1.初始化*/
    $().ready(function(){
        //数据验证初始化
        dyPlugins.Validate.init("#formValidate");

        //获取订单基本信息
        getOrderInfoAjax();

        /*当订单状态 不等于 已支付 或 已发货时，不显示 发货按钮*/
        if(oStatus && (oStatus != os2 ||  oStatus != os8)){
            $('#deliver').hide();
        }
        //确认按钮绑定事件
        $('#deliver').off('click').on('click', function () {
            deliverSubmit();
        })

    });

    /* 2.业务方法  */
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        return paramsStr;
    }
    /* 2.业务方法  */
    function getOrderInfoAjax(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

        var paramsJson = {
            restPath:encodeURI('/ordersvr/orders/'+orderId+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //获取订单详情
                if (data.result) {
                    //1 数据渲染
                    setOrderInfoData(data.result);
                    var orderObj = data.result;
                    /*订单业务类型*/
                    oBiztype = orderObj.orderBiztype;
                    //订单状态状态
                    oStatus = orderObj.orderStatus;
                    //获取订单明细
                    queryOrderDetailAjax();
                    //查询发卡明细列表
                    queryMcardSendAjax();
                }
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    function setOrderInfoData(info) {
        if (info) {
            for (var key in info) {
                $('#'+key).html(info[key]);
                $('#'+key).val(info[key]);
            }
            //订单状态状态
            var statusStr = getValue(orderStatus, info.orderStatus);
            $('#orderStatus').html(statusStr);

            //订单金额
            $('#orderAmount').html(dyCom.numberFormat(info.orderAmount/100, 2, '.'));
            //配送方式
            var lgSendtypeStr = getValue(lgSendType, info.lgSendtype);
            $('#showLgSendtype').html(lgSendtypeStr);

            sendtype = info.lgSendtype;
            //如果需要邮寄显示，收件人信息
            if (sendtype && sendtype == inItSendType) {
                $('.expressage').removeClass('f-dn');
            }

        }
    }


    /**
     * 获取订单明细
     */
    function queryOrderDetailAjax() {
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

        var urlStr = '';
        if('eb' == oBiztype) {
            urlStr = '/ebsvr/eborders/'+orderId+'/details'+svrParamsString;
        }else if('mcard' == oBiztype) {
            urlStr = '/mcardsvr/mcardorders/'+orderId+'/details'+svrParamsString;
            //如果是会员订单，需要展示发卡明细，然后查询发卡明细列表
            $('#send-title').show();
            $('#deliverList').show();

        }else {
            return;
        }
        var paramsJson = {
            restPath:urlStr
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setOrderDetailList(oBiztype, data);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    function setOrderDetailList(type,dataList) {
        if(!dataList.result){
            dataList.result = [];
        }

        var colsList =[
            {
                type: "numbers",
                field: "nums",
                title: "NO.",
                width: 50
            }, //序列号
            { field: "cm", width: 150, title: "卡类型",callback: function(cdata) {
                var name = "<span class='f-toe f-db'>";
                if(dyCom.stringFiltedNull(cdata.typeName)){
                    name += cdata.typeName;
                }
                if(dyCom.stringFiltedNull(cdata.childtypeName)){
                    name += '--';
                    name += cdata.childtypeName;
                }
                name += "</span>";
                return name;
            }},
            { field: "skuName", width: 150, title: "是否为虚拟卡", callback: function(cdata) {
                var isVirtualCard = "<span class='f-toe f-db'>";
                if(dyCom.stringFiltedNull(cdata.isVirtualCard)){
                    if(cdata.isVirtualCard === initVirtual){
                        isVirtualCard += '电子卡';
                    }else {
                        isVirtualCard += '实体卡';
                    }

                }
                isVirtualCard += "</span>";
                return isVirtualCard;
            }},
            { field: "buyPrice", width: 150, title: "单价", callback: function(cdata) {
                return "<span class='f-toe f-db'>"+dyCom.numberFormat(cdata.cardPrice/100, 2, '.')+"</span>"
            }},
            { field: "buyQuantity", width: 100, title: "购买数量", callback: function(cdata) {
                return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.buyNumber)+"</span>"
            }}

        ];

        /*输入卡号的dom节点*/
        var cardNumsDom = { field: "cardNum", width: 150, title: "卡号", callback: function(cdata) {
            var cardNumStr = '';
            var buyNumber = dyCom.stringFiltedNull(cdata.buyNumber);
            if(buyNumber) {
                for (var i = 0; i < buyNumber; i++) {
                    cardNumStr += '<div><div><input class="f-input red required" placeholder="请输入卡号" data-datatype="n12"></div></div>';
                }
            }
            return cardNumStr;
        }};
        /*当订单状态 不等于 已发货时，显示输入卡号*/
        if(oStatus && oStatus != os8){
            colsList.push(cardNumsDom)
        }

        if('eb' == type){
            colsList =[
                {
                    type: "numbers",
                    field: "nums",
                    title: "NO.",
                    width: 50
                }, //序列号
                { field: "cm", width: 150, title: "商品",callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+ dyCom.stringFiltedNull(cdata.cmName)+"</span>"
                }},
                { field: "skuName", width: 150, title: "SKU", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.skuName)+"</span>"
                }},
                { field: "buyPrice", width: 150, title: "单价", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.buyPrice)+"</span>"
                }},
                { field: "buyQuantity", width: 100, title: "购买数量", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.buyQuantity)+"</span>"
                }}
            ];

        }

        var tableOption = {
            elem: "#orderDetailList",
            data: dataList.result,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            width: "100%",
            height: "auto",  //结合isNoFullScreen使用
            isNoFullScreen:true, //不全屏计算高度  height 必须设置auto
            trData: [{ typeid: "typeId" }, { childtypeid: "childtypeId" }],
            cols: colsList,
            init: function() {
                //数据验证初始化
                dyPlugins.Validate.init("#formValidate");
            }
        };
        dyPlugins.Table.createTable(tableOption, 0);


    }

    /*
     查询发卡明细列表
     */
    function queryMcardSendAjax() {
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcardorders/'+orderId+'/delivers'+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setMCardOrderDeliverDetailList(data);
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    function setMCardOrderDeliverDetailList(dataList) {
        if(!dataList.result){
            dataList.result = [];
        };

        var tableOption = {
            elem: "#deliverList",
            data: dataList.result,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            width: "100%",
            height: "100",
            trData: [],
            cols: [
                {
                    type: "numbers",
                    field: "nums",
                    title: "NO.",
                    width: 50
                }, //序列号
                { field: "typeName", width: 250, title: "卡类型",callback: function(cdata) {
                    var name = "<span class='f-toe f-db'>";
                    if(dyCom.stringFiltedNull(cdata.typeName)){
                        name += cdata.typeName;
                    }
                    if(dyCom.stringFiltedNull(cdata.childtypeName)){
                        name += '--';
                        name += cdata.childtypeName;
                    }
                    name += "</span>";
                    return name;

                }},
                { field: "deliverQuantity", width: 100, title: "是否为虚拟卡", callback: function(cdata) {
                    var isVirtualCard = "<span class='f-toe f-db'>";
                    if(dyCom.stringFiltedNull(cdata.isVirtualCard)){
                        if(cdata.isVirtualCard === initVirtual){
                            isVirtualCard += '电子卡';
                        }else {
                            isVirtualCard += '实体卡';
                        }

                    }
                    isVirtualCard += "</span>";
                    return isVirtualCard;
                }},
                { field: "deliverQuantity", width: 100, title: "发货数量", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.deliverQuantity)+"</span>"
                }},
                { field: "cardNum", width: 200, title: "卡号", callback: function(cdata) {
                    return "<span class='f-toe f-db'>"+dyCom.stringFiltedNull(cdata.cardNum)+"</span>"
                }}
            ],
            init: function() {
                //初始化方法

            }
        };
        dyPlugins.Table.createTable(tableOption, 0);
    }


    //参数
    function getParam() {

        var paramsObj = {
            orderId: orderId,
            lgSendtype: sendtype,
        };

        /*当订单状态 不等于 已发货时，显示输入卡号*/
        if(oStatus && oStatus != os8) {
            /*订单明细集合*/
            var orderDetails = [];
            /*卡订单时，录入发货明细信息*/
            if (oBiztype && oBiztype == 'mcard') {
                // 遍历 订单明细 tr
                $('#orderDetailList .dyui-table-body tr').each(function (i) {

                    /*卡类型Id*/
                    var typeId = $(this).data('typeid');
                    var childtypeId = $(this).data('childtypeid');

                    // 获取发货卡数量
                    var buyNumber = $(this).children('td:eq(4)').find('span:last').text();

                    // 获取发货卡号明细
                    $(this).children('td:eq(5)').find('input').each(function (j, obj) {
                        /*订单明细对象*/
                        var cardObj = {};
                        cardObj.typeId = dyCom.stringFiltedNull(typeId);
                        cardObj.childtypeId = dyCom.stringFiltedNull(childtypeId);
                        cardObj.deliverQuantity = '1';
                        cardObj.cardNum = dyCom.stringFiltedNull($(obj).val());

                        orderDetails.push(cardObj);
                    });

                });
            }
            paramsObj.orderDeliverDetails = orderDetails;
        }
        return paramsObj;
    }

    //取货验证订单提交
    function deliverSubmit() {
        var clickFlag = $("#deliver").data("click");
        if (!clickFlag) {
            return false;
        }
        //提交之前验证
        $("#deliver").data("click", false); //设置不可点击提交按钮
        //提交验证 errTime 返回 0的时候 说明验证都通过 >0 说明 有errTime处有信息问题
        var errTime = dyPlugins.Validate.checkAll();
        if (errTime > 0) {
            $("#deliver").data("click", true); //设置可以点击
        }else{
            var paramsStr = getParam(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条

            //ajax请求配置
            var optionsAjax = {
                url: ctx+'/ajax/post?restPath='+encodeURI('/mcardsvr/mcardorders/pickup?token='+token)+'&token='+token,  //请求url
                type: "post",         //请求类型 默认get
                async: true,            //异步|同步加载 默认异步
                dataType: "json",      //数据类型      默认json
                data:JSON.stringify({appData:paramsStr})
            };
            optionsAjax.callback = function(type,data){
                $("#deliver").data("click", true); //设置可以点击
                //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
                //返回结果处理
                if(type==1){
                    layer.msg('取货验证成功！',function(){
                        window.location.href = "${ctx}/mcardorders/"+orderId+"/manage";
                    });
                }else{
                    layer.msg(data);
                }
            };
            dyCom.ajaxRequest(optionsAjax);
        }
    }


</script>
</body>
</html>
