<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<c:set var="static_js" value="${pageContext.request.contextPath}/static/js"/>
<c:set var="static_css" value="${pageContext.request.contextPath}/static/css"/>
<c:set var="static_images" value="${pageContext.request.contextPath}/static/images"/>
<c:set var="dist_bootstrap" value="${pageContext.request.contextPath}/dist/lib/bootstrap/"/>
<c:set var="dist_jquery" value="${pageContext.request.contextPath}/dist/lib/jquery"/>
<c:set var="dist_styles" value="${pageContext.request.contextPath}/dist/styles"/>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="edge"/>
    <meta name="viewport"
          content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no"/>
    <title>会员卡管理-赠卡</title>
    <link href="${static_css}/bootstrap.min.css" rel="stylesheet">
    <link href="${static_css}/common.css" rel="stylesheet">
    <style type="text/css">
        .nav > li {
            width: 12%;
        }

        .nav-tabs > li > a {
            height: 30px;
            line-height: 30px;
        }

        .nav-tabs > li.active > a, .nav-tabs > li.active > a:focus, .nav-tabs > li.active > a:hover {
            color: #ffffff;
            background-color: #0070C1;
            height: 30px;
            line-height: 30px;
        }
        *{
            margin: 0;
            border: 0;
        }
        .d2, .d3{
            height: 400px;
            width: 300px;

            border: solid 1px #000000;
        }
        .d1{
            height: 100px;
            width: 800px;

            border: solid 1px #000000;
        }

        .d1{
            margin: 0 auto;
        }
        .d3{
            display: inline-block;
            margin-left: -10px;
        }
        .d2{
            display: inline-block;
            margin-left: 10%;
        }
    </style>
</head>

<body>
<div class="body-div" id="loading">
    <div class="btn-group-menu">
        <div class="btn-group">

        </div>
    </div>
    <!--下部-->
    <div class="main-content">
        <div class="title">
        	<span>
        		赠卡激活
        	</span>
        </div>
        <div class="col-xs-12 swlDetail">
            <div class="col-xs-12 data-range">
                <table cellpadding="0" cellspacing="0"
                       class="table table-striped table-bordered table-hover table-condensed">
                    <tr>
                        <td>
                            <form>
                                <div class="rf-p">
                                    <div class="rf-p-b">
                                        <span class="font_red"></span>
                                        <div class="d3">
                                            <table style="border: 1px" class="table table-bordered table-striped table-hover">
                                                <tr>
                                                    <td align="left" colspan="2">选择商品</td>
                                                </tr>
                                                <c:forEach var="card" items="${mcardList }" varStatus="">
                                                    <tr>
                                                        <td><img src="${static_images}/logo-70.png"/></td>
                                                        <td>
                                                            <p>${card.typeName}/${card.childtypeName}</p>
                                                            <p>库存：实体卡${card.entityNum}张 虚拟卡${card.virtualNum}张</p>
                                                            <p>￥<fmt:formatNumber
                                                                    value="${card.cardPrice/100}"
                                                                    type="number" pattern="#,##0.00"/>元 </p>
                                                        </td>
                                                    </tr>
                                                </c:forEach>
                                            </table>
                                        </div>
                                        <div class="d2">
                                            <table style="border: 1px" class="table table-bordered table-striped table-hover">
                                                <tr>
                                                    <td align="right">姓名：</td>
                                                    <td align="left"><input type="text" id="userName" name="userName"></td>
                                                </tr>
                                                <tr>
                                                    <td align="right">手机号：</td>
                                                    <td align="left"><input type="text" id="mobile" name="mobile"></td>
                                                </tr>
                                                <tr>
                                                    <td align="right">证件类型：</td>
                                                    <td align="left">
                                                        <select name="certificateType" style="width: 100%;height: 35px;" id="certificateType">
                                                            <option value="10">身份证</option>
                                                            <option value="C">港澳通行证</option>
                                                            <option value="G">台胞证</option>
                                                            <option value="B">护照</option>
                                                        </select>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="right">证件号码：</td>
                                                    <td align="left"><input type="text" id="certificateNumber" name="certificateNumber"></td>
                                                </tr>
                                                <tr>
                                                    <td align="right">赠送时绑定</td>
                                                    <td align="left"><input type="radio" name="bind" value="1">所赠送的卡自动绑定到当前购买者</td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="d1">
                                        <button type="submit" style=".menu-btn" onclick="cardGift()">赠卡下单</button>
                                        <input type="button" value="返回" onclick="backSaleCardList()" />
                                    </div>
                                </div>
                            </form>
                        </td>
                    </tr>
                </table>
            </div>
            <!--商品列表结束-->
        </div>
    </div>

</div>
</body>
<script src="${dist_jquery}/jquery.js" type="text/javascript" charset="utf-8"></script>
<script src="${dist_bootstrap}/bootstrap.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
    //鼠标经过按钮变色
    function currentMenuBtn() {
        $(".menu-btn").mouseover(function () {
            $(this).children().css("background-color", "#8EB4E3");
        });
        $(".menu-btn").mouseout(function () {
            $(this).children().css("background-color", "#bdbfbe");
        });
    }
    currentMenuBtn();
</script>
<script type="text/javascript">
    function cardGift() {
        window.location.href = "${ctx}/cardmgr/cardinfos/11111/gift/one";
    }
    function backSaleCardList() {
    }
</script>
</html>
