<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/common/include/include-taglib.jsp" %>
<c:set var="ctx_rbweb" value="/rbweb"/>

<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include/include-meta-info.jsp" %>
    <title>订单管理-发货</title >
    <%@ include file="/WEB-INF/jsp/common/include/include-css.jsp" %>
    <link href="${static_css}/temp/common.css" rel="stylesheet">
    <style type="text/css">

        .table>tbody>tr>td {
            height: 30px;
            line-height: 30px;
        }
        table>thead>tr>th {
            background-color: #E0ECF8;
            text-align: center;
        }
    </style>
</head>

<body id="loading">
<div class="content-main">
    <div class="btn-group-menu" style="height: 4%;"></div>
    <div class="title-level1">
        <span>
            订单发货
        </span>
    </div>
    <!--下部-->
    <div class="row content-container">
        <div class="col-md-12" style="height: 100%;padding-top: 1%;">
            <form id="deliver" name="deliver" action="${ctx}/mcardorders/deliver/submit" method="post" style="height:100%;">
                <input type="hidden" id="orderId" name="orderId" value="${orderInfo.orderId}">
                <div class="row" style="height: 45%;">
                    <div class="col-md-6" style="padding: 0;">
                        <table class="table table-bordered">
                            <tr>
                                <td class="table_title" colspan="4">订单信息</td>
                            </tr>
                            <tr>
                                <td class="table_title" style="width:18%;">订单号：</td>
                                <td class="table_input" style=" width:35%;">
                                    ${orderInfo.orderId}
                                </td>
                                <td class="table_title" style="width:18%;">状态：</td>
                                <td class="table_input" style=" width:32%;">
                                    <c:choose>
                                        <c:when test="${orderInfo.orderStatus == '9'}">待确认</c:when>
                                        <c:when test="${orderInfo.orderStatus == '0'}">待支付</c:when>
                                        <c:when test="${orderInfo.orderStatus == '1'}">已取消</c:when>
                                        <c:when test="${orderInfo.orderStatus == '2'}">已支付</c:when>
                                        <c:when test="${orderInfo.orderStatus == '3'}">已完成</c:when>
                                        <c:when test="${orderInfo.orderStatus == '4'}">申请退款</c:when>
                                        <c:when test="${orderInfo.orderStatus == '5'}">退款中</c:when>
                                        <c:when test="${orderInfo.orderStatus == '6'}">已退款</c:when>
                                        <c:when test="${orderInfo.orderStatus == '7'}">退款失败</c:when>
                                        <c:when test="${orderInfo.orderStatus == '8'}">已发货</c:when>
                                    </c:choose>
                                </td>
                            </tr>
                            <tr>
                                <td class="table_title" style="width:18%;">销售机构：</td>
                                <td class="table_input" style=" width:32%;">
                                    ${orderInfo.saleOrganName}
                                </td>
                                <td class="table_title" style="width:18%;">订单金额：</td>
                                <td class="table_input" style=" width:32%;">
                                    <fmt:formatNumber value="${orderInfo.orderAmount/100}" type="number" pattern="#,##0.00"/>
                                </td>
                            </tr>
                            <tr>
                                <td class="table_title" style="width:18%;">买家姓名：</td>
                                <td class="table_input" style=" width:32%;">
                                    ${orderInfo.lgRecipient}
                                </td>
                                <td class="table_title" style="width:18%;">手机号码：</td>
                                <td class="table_input" style=" width:32%;">
                                    ${orderInfo.lgPhone}
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6" style="padding-right: 0;">
                        <table class="table table-bordered">
                            <tr>
                                <td class="table_title" colspan="4">配送信息</td>
                            </tr>
                            <tr>
                                <td class="table_title" style="width:18%;">配送方式：</td>
                                <td class="table_input" style=" width:82%;" colspan="3">
                                    <label class="radio-inline">
                                        <input type="radio"  value="1" name="lgSendtype" <c:if test="${orderInfo.lgSendtype == '1'}">checked="checked"</c:if>>邮寄
                                    </label>
                                    <label class="radio-inline">
                                        <input type="radio"  value="2" name="lgSendtype" <c:if test="${orderInfo.lgSendtype == '2'}">checked="checked"</c:if>>自取
                                    </label>
                                    <label class="radio-inline">
                                        <input type="radio"  value="3" name="lgSendtype" <c:if test="${orderInfo.lgSendtype == '3'}">checked="checked"</c:if>>电子配送
                                    </label>
                                </td>
                            </tr>
                            <tr>
                                <td class="table_title" style="width:18%;">收货人：</td>
                                <td class="table_input" style=" width:32%;">
                                    <input id="lgRecipient" name="lgRecipient" value="${orderInfo.lgRecipient}">
                                </td>
                                <td class="table_title" style="width:18%;">物流公司：</td>
                                <td class="table_input" style=" width:32%;">
                                    <input type="text" id="lgExpressName" name="lgExpressName" style="border: 1px solid #0e9aef; width:100%;" placeholder="当选择邮寄时要录入快递公司">
                                </td>
                            </tr>
                            <tr>
                                <td class="table_title" style="width:18%;">收货手机号：</td>
                                <td class="table_input" style=" width:32%;">
                                    <input id="lgPhone" name="lgPhone" value="${orderInfo.lgPhone}">
                                </td>
                                <td class="table_title" style="width:18%;">物流单号：</td>
                                <td class="table_input" style=" width:32%;">
                                    <input type="text" id="lgExpressNum" name="lgExpressNum" style="border: 1px solid #0e9aef; width:100%;" placeholder="当选择邮寄时要录入快递单号">
                                </td>
                            </tr>
                            <tr>
                                <td class="table_title" style="width:18%;">收货地址：</td>
                                <td class="table_input" style=" width:82%;" colspan="3">
                                    <input id="lgAddrress" name="lgAddrress" value="${orderInfo.lgAddrress}">
                                </td>
                            </tr>
                            <tr>
                                <td class="table_title" style="width:18%;">收货邮编：</td>
                                <td class="table_input" style=" width:82%;" colspan="3">
                                    <input id="lgZipcode" name="lgZipcode">
                                </td>
                            </tr>
                        </table>

                    </div>
                </div>
                <!--订单明细【商品列表】开始-->
                <div class="row" style="height: 50%; overflow-y: auto;">
                    <div class="col-md-12" style="height:100%;padding:0;">
                        <table cellpadding="0" cellspacing="0" class="table table-striped table-hover table-condensed">
                            <thead>
                            <tr>
                                <th style="width: 30%;">卡类型</th>
                                <th style="width: 10%;">发卡机构</th>
                                <th style="width: 15%;">是否为虚拟卡</th>
                                <th style="width: 5%;">卡面值</th>
                                <th style="width: 5%;">卡余额</th>
                                <th style="width: 5%;">卡状态</th>
                                <th style="width: 5%;">数量</th>
                                <th style="width: 25%;">卡号</th>
                            </tr>
                            </thead>
                            <tbody>
                            <c:choose>
                                <c:when test="${not empty mcardOrderDetails}">
                                    <c:forEach items="${mcardOrderDetails}" var="mcardOrderDetail" varStatus="vs">
                                        <tr>
                                            <td style="text-align: left;">
                                                <div class="row">
                                                    <input type="hidden" id="orderDetailList[${vs.index}].typeId" name="orderDetailList[${vs.index}].typeId" value="${mcardOrderDetail.typeId}">
                                                    <input type="hidden" id="orderDetailList[${vs.index}].childtypeId" name="orderDetailList[${vs.index}].childtypeId" value="${mcardOrderDetail.childtypeId}">
                                                    <div class="col-md-2" style="padding: 3px;">
                                                        <a href=""><img src="${ctx_rbweb}/files/owner/${mcardOrderDetail.detailId}/MAINIMG?token=${sessionScope.token}" alt="MAINIMG" style="width: 100%;height:auto;"></a>
                                                    </div>
                                                    <div class="col-md-10">
                                                        <a href="">${mcardOrderDetail.typeName}</a>/<a href="">${mcardOrderDetail.childtypeName}</a>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                发卡机构
                                            </td>
                                            <td>
                                                <c:choose>
                                                    <c:when test="${mcardOrderDetail.isVirtualCard == '0'}" >实体卡</c:when>
                                                    <c:when test="${mcardOrderDetail.isVirtualCard == '1'}" >虚拟卡</c:when>
                                                </c:choose>
                                            </td>
                                            <td>
                                                <fmt:formatNumber type="number" maxFractionDigits="2" value="${mcardOrderDetail.cardPrice/100}" pattern="#,##0.00"/>
                                            </td>
                                            <td>

                                            </td>
                                            <td>
                                                <p>${mcardOrderDetail.status}</p>
                                            </td>
                                            <td>
                                                <p>${mcardOrderDetail.buyNumber}</p>
                                                <input type="hidden" id="orderDetailList[${vs.index}].buyNumber" name="orderDetailList[${vs.index}].buyNumber" value="${mcardOrderDetail.buyNumber}">
                                            </td>
                                            <td>
                                                <c:choose>
                                                    <c:when test="${mcardOrderDetail.buyNumber > '1'}">
                                                        <input type="text" style="width: 45%;height: inherit;border: 1px solid #0e9aef;" id="orderDetailList[${vs.index}].cardNum" name="orderDetailList[${vs.index}].cardNum" placeholder="请输入起始卡号">
                                                        -
                                                        <input type="text" style="width: 45%;height: inherit;border: 1px solid #0e9aef;" id="orderDetailList[${vs.index}].cardNum2" name="orderDetailList[${vs.index}].cardNum2" placeholder="请输入截止卡号">
                                                    </c:when>
                                                    <c:otherwise>
                                                        <input type="text" style="width: 100%;height: inherit;border: 1px solid #0e9aef;" id="orderDetailList[${vs.index}].cardNum" name="orderDetailList[${vs.index}].cardNum" placeholder="请输入卡号">
                                                    </c:otherwise>
                                                </c:choose>
                                            </td>
                                        </tr>
                                    </c:forEach>
                                </c:when>
                            </c:choose>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!--商品列表结束-->
                <div class="row" style="height:5%;">
                    <div class="col-md-12" style="height:100%;text-align: center;">
                        <button class="btn btn-primary" type="submit">发货</button>
                        <button class="btn btn-primary" type="button"  onclick="history.go(-1)">返回</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
</body>
<%@ include file="/WEB-INF/jsp/common/include/include-js.jsp" %>
<script type="text/javascript">
    //鼠标经过按钮变色
    function currentMenuBtn() {
        $(".menu-btn").mouseover(function () {
            $(this).children().css("background-color", "#8EB4E3");
        });
        $(".menu-btn").mouseout(function () {
            $(this).children().css("background-color", "#bdbfbe");
        });
    }
    currentMenuBtn();
</script>
</html>
