<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<c:set var="static_js" value="${pageContext.request.contextPath}/static/js"/>
<c:set var="static_css" value="${pageContext.request.contextPath}/static/css"/>
<c:set var="static_images" value="${pageContext.request.contextPath}/static/images"/>
<c:set var="dist_bootstrap" value="${pageContext.request.contextPath}/dist/lib/bootstrap/"/>
<c:set var="dist_jquery" value="${pageContext.request.contextPath}/dist/lib/jquery"/>
<c:set var="dist_styles" value="${pageContext.request.contextPath}/dist/styles"/>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>B2B销售</title>
    <link href="${static_css}/bootstrap.min.css" rel="stylesheet">
    <link href="${static_css}/common.css" rel="stylesheet">
</head>

<body>
<div class="body-div" id="loading">
    <!-- 工具栏 -->
    <div class="btn-group-menu">
        &nbsp;
    </div>
    <!--内容-->
    <div class="main-content">
        <form action="">
        <!--标题开始-->
        <div class="container-fluid">
            <div class="row-fluid">
                <div class="span12">
                    B2B销售
                </div>
            </div>
            <div class="row-fluid">
                <c:forEach items="${mcardTypeList}" var="mcardType">
                    <div class="span6">
                        <div class="row-fluid">
                            <div class="span12">
                                <div class="row-fluid">
                                    <div class="span6">
                                        <img src="${mcardType.picUrl}">
                                    </div>
                                    <div class="span6">
                                        <table>
                                            <tr>
                                                <td>${mcardType.typeName}</td>
                                            </tr>
                                            <tr>
                                                <td>库存</td>
                                            </tr>
                                            <tr>
                                                <td>￥${mcardType.cardPrice}元</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </c:forEach>
                <div class="span6">
                    分销商信息
                </div>
            </div>
            <div class="row-fluid">
                <div class="span12">
                    <button class="btn btn-block" type="button">B2B销售下单</button>
                </div>
            </div>
        </div>
        </form>
    </div>

</div>
</body>
<script src="${dist_jquery}/jquery.js" type="text/javascript" charset="utf-8"></script>
<script src="${dist_bootstrap}/bootstrap.min.js" type="text/javascript" charset="utf-8"></script>

</html>
