<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>指定卡类型适用的卡管理</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--下拉框选择组件-->
    <link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>
            <!--TODO-->
        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconliebiao1"></i>
                  <span class="name-text">指定卡类型适用的卡管理</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <!--业务模块-->
        <div class="main-block">
            <div class="m-table-list">
                <div class="m-search-list">
                    <div class="search-form">
                        <div class="row">
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input id="cardNum" placeholder="请输入卡号">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input id="typeName" placeholder="请输入卡类型">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <div id="selectVirtualCardList"></div>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <div id="selectCardStatusList"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="search-btn">
                        <button id="searchSubmit" type="button" class="u-btn u-btn-primary u-btn-sm">
                            查询
                        </button>
                    </div>
                </div>
                <section class="content f-mt20">
                    <table>
                        <thead>
                        <tr>
                            <th class="m-table-col-1">No.</th>
                            <th class="m-table-col-3">卡号</th>
                            <th class="m-table-col-4">卡类型</th>
                            <th class="m-table-col-2">卡面值</th>
                            <th class="m-table-col-2">虚拟卡</th>
                            <th class="m-table-col-3">销售时间</th>
                            <th class="m-table-col-3">销售机构</th>
                            <th class="m-table-col-4">有效期</th>
                            <th class="m-table-col-2">状态</th>
                        </tr>
                        </thead>
                        <tbody id="dataList">

                        </tbody>
                    </table>
                </section>
                <!--分页开始-->
                <div id="pagesList" class="f-mt20"></div>
                <!--分页结束-->
            </div>
        </div>
        <!--业务模块结束-->
    </section>
    <!--内容区结束-->
</div>

<%--table模板--%>
<table id="templateTable" class="f-dn">
    <tr>
        <td><div class="f-tac label1 " ></div></td>
        <td><div class="f-tac label2 clickQuery f-csp"></div></td>
        <td><div class="f-tac label3"></div></td>
        <td><div class="f-tac label4"></div></td>
        <td><div class="f-tac label5"></div></td>
        <td><div class="f-tac label6"></div></td>
        <td><div class="f-tac label7"></div></td>
        <td><div class="f-tac label8"></div></td>
        <td><div class="f-tac label9"></div></td>
    </tr>
</table>

<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 下拉选择组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/select/pc/dist/js/select.js?v=1"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>
<%--js引入私有 枚举值信息及公共方法--%>
<script src="${ctx}/static_new_new/js/data/mcardConstant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>

<script>
    //分页
    var pageSize = 10; //每页多少条
    var pageIndex = 0; //当前页

    var typeId = dyCom.getUrlPathNameParams(3)
    /*1.初始化*/
    $().ready(function(){
        //搜索按钮事件监听
        $('#searchSubmit').off('click').on('click',function(){
            // console.log("点击查询");
            queryMcardList();
        });
        //初始化列表数据
        queryMcardList();

        //状态下拉选择初始化
        setCardStatusListToSelelct();
        //是否虚拟卡下拉选择初始化
        setVirtualCardListToSelelct();
    });
    /* 2.业务方法  */
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        var cardNum = $('#cardNum').val();
        var typeName = $('#typeName').val();
        var selectVirtualCard = $('#selectVirtualCardList select').val();
        var selectCardStatus = $('#selectCardStatusList select').val();

        var paramsJson = [
            'page='+pageIndex ,
            'size='+pageSize
        ];
        if(cardNum){
            paramsJson.push('cardNum='+cardNum);
        }
        if(typeName){
            paramsJson.push('typeName='+typeName);
        }

        if(selectVirtualCard){
            paramsJson.push('isVirtualCard='+selectVirtualCard);
        }
        if(selectCardStatus){
            paramsJson.push('cardStatus='+selectCardStatus);
        }

        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');

        return paramsStr;
    }
    //查询会员卡列表
    function queryMcardList(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards/cardtype/'+typeId+'/mcards'+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setDataList(data);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充数据
    function setDataList(data) {
        $("#dataList").html('');

        if(data && data.result){
            var list = data.result;
            $.each(list, function (i, obj) {
                /*克隆table 模板*/
                var trClone = $('#templateTable tr').clone();
                trClone.data('cardnum', obj.cardNum);
                /*赋值*/
                var no = i+1;
                trClone.find('.label1').html(no);
                trClone.find('.label2').html(dyCom.stringFiltedNull(obj.cardNum));
                trClone.find('.label3').html('');//dyCom.stringFiltedNull(obj.typeId)
                var cardPrice = dyCom.numDiv(dyCom.stringFiltedNull(obj.cardPrice), '100');
                trClone.find('.label4').html(cardPrice + '元');
                var virtualCard = getValue(isVirtualCard, dyCom.stringFiltedNull(obj.isVirtualCard))
                trClone.find('.label5').html(virtualCard);
                trClone.find('.label6').html(dyCom.stringFiltedNull(obj.saleTime));
                trClone.find('.label7').html('');//dyCom.stringFiltedNull(obj.applyOrganId)

                var time = '';
                if(dyCom.stringFiltedNull(obj.validStartDate)){
                    time +=  obj.validStartDate;
                }
                if(dyCom.stringFiltedNull(obj.validEndDate)){
                    time += '--' + obj.validEndDate
                }
                trClone.find('.label8').html(time);
                var cardStatus = getValue(cardStatusList, dyCom.stringFiltedNull(obj.cardStatus))
                trClone.find('.label9').html(cardStatus);


                /*追加HTML*/
                $("#dataList").append(trClone);
            });
            /*基本信息 点击事件*/
            $('#dataList tr').off('click').on('click',function(){
                var cardNum = $(this).data('cardnum');
                window.location.href = ctx+'/mcards/'+cardNum+'/manage?token='+token;
            })
        }

        //2 分页处理
        dyPlugins.Page.init("pagesList",data.totalPage,data.currPage,data.pageSize,data.totalRows,function(data){
            pageIndex = data.curr;
            queryMcardList();
        });
    }
    //状态下拉选择初始化
    function setCardStatusListToSelelct() {
        var optionStatus = {
            domId: "#selectCardStatusList",
            selectName: "卡状态",
            keyName: "value",
            valueName: "id",
            selectedValue: ""
        };
        optionStatus.callback = function(selectObj) {
            console.log(selectObj);
        };
        dyPlugins.selectModel.init(optionStatus, cardStatusList);
    }
    //是否虚拟卡下拉选择初始化
    function setVirtualCardListToSelelct() {
        var optionStatus = {
            domId: "#selectVirtualCardList",
            selectName: "是否是虚拟卡",
            keyName: "value",
            valueName: "id",
            selectedValue: ""
        };
        optionStatus.callback = function(selectObj) {
            console.log(selectObj);
        };
        dyPlugins.selectModel.init(optionStatus, isVirtualCard);
    }
</script>
</body>
</html>