<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>我运营管理下的卡</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--下拉框选择组件-->
    <link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>
            <!--TODO-->
        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconliebiao1"></i>
                  <span class="name-text">我运营管理下的卡</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <!--业务模块-->
        <div class="main-block">
            <div class="m-table-list">
                <div class="m-search-list">
                    <div class="search-form">
                        <div class="row">
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input id="cardNumParam" placeholder="请输入卡号">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <input id="typeNameParam" placeholder="请输入卡类型">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <div id="selectVirtualCardList"></div>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="form-item">
                                    <div id="selectCardStatusList"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="search-btn">
                        <button id="searchSubmit" type="button" class="u-btn u-btn-primary u-btn-sm">
                            查询
                        </button>
                    </div>
                </div>
                <section class="content f-mt20">
                    <table>
                        <thead>
                        <tr>
                            <th class="m-table-col-1">No.</th>
                            <th class="m-table-col-3">卡号</th>
                            <th class="m-table-col-3">卡类型</th>
                            <th class="m-table-col-1">卡面值</th>
                            <th class="m-table-col-1">虚拟卡</th>
                            <th class="m-table-col-2">销售时间</th>
                            <th class="m-table-col-2">销售机构</th>
                            <th class="m-table-col-5">绑定</th>
                            <th class="m-table-col-4">有效期</th>
                            <th class="m-table-col-2">状态</th>
                        </tr>
                        </thead>
                        <tbody id="dataList">

                        </tbody>
                    </table>
                </section>
                <!--分页开始-->
                <div id="pagesList" class="f-mt20"></div>
                <!--分页结束-->
            </div>
        </div>
        <!--业务模块结束-->
    </section>
    <!--内容区结束-->
</div>
<div id="template" class="main-block f-dn">
    <table>
        <tbody>
        <tr>
            <td>
                <div class="f-tac no">01</div>
            </td>
            <td>
                <div class="f-tal cardNum">王虎</div>
            </td>
            <td>
                <div class="f-tac typeName">--</div>
            </td>
            <td>
                <div class="f-tac cardPrice">1990-03-04</div>
            </td>
            <td>
                <div class="f-tac isVirtualCard">1990-03-04</div>
            </td>
            <td>
                <div class="f-tac saleTime">1990-03-04</div>
            </td>
            <td>
                <div class="f-tac applyOrganId">1990-03-04</div>
            </td>
            <td>
                <div class="f-tac userInfo">1990-03-04</div>
            </td>
            <td>
                <div class="f-tac validDate">1990-03-04</div>
            </td>
            <td>
                <div class="f-tac cardStatus">1990-03-04</div>
            </td>
        </tr>
        </tbody>
    </table>
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 下拉选择组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/select/pc/dist/js/select.js?v=1"></script>
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>
<%--js引入私有 枚举值信息及公共方法--%>
<script src="${ctx}/static_new_new/js/data/mcardConstant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>

<script>
    //分页
    var pageSize = 10; //每页多少条
    var pageIndex = 0; //当前页
    /*1.初始化*/
    $().ready(function(){
        //搜索按钮事件监听
        $('#searchSubmit').off('click').on('click',function(){
            // console.log("点击查询");
            queryMcardList();
        });
        //初始化列表数据
        queryMcardList();

        //状态下拉选择初始化
        setCardStatusListToSelelct();
        //是否虚拟卡下拉选择初始化
        setVirtualCardListToSelelct();
    });
    /* 2.业务方法  */
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        var cardNumParam = $('#cardNumParam').val();
        var typeNameParam = $('#typeNameParam').val();
        var selectCardStatus = $('#selectCardStatusList select').val();
        var selectVirtualCard = $('#selectVirtualCardList select').val();

        var paramsJson = [
            'page='+pageIndex ,
            'size='+pageSize
        ];

        if(token){
            paramsJson.push('token='+token);
        }
        if(typeNameParam){
            paramsJson.push('typeName='+typeNameParam);
        }
        if(cardNumParam){
            paramsJson.push('cardNum='+cardNumParam);
        }
        if(selectCardStatus || selectCardStatus===0){
            paramsJson.push('status='+selectCardStatus);
        }
        if(selectVirtualCard || selectVirtualCard===0){
            paramsJson.push('isVirtualCard='+selectVirtualCard);
        }

        paramsStr += paramsJson.join('&');
        // console.log(paramsStr);
        return paramsStr;
    }
    //查询会员卡列表
    function queryMcardList(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards/operator/mine/mcards'+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setDataList(data.result);
                if (data.totalPage) {
                    //2 分页处理
                    dyPlugins.Page.init("pagesList",data.totalPage,data.currPage,data.pageSize,data.totalRows,function(data){
                        pageIndex = data.curr;
                        queryMcardList();
                    });
                }
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充数据
    function setDataList(dataList) {
        if(dataList){
            $("#dataList").html('');
            $.each(dataList, function (i, obj) {
                // console.log(obj);
                /*克隆table 模板*/
                var itemClone = $('#template>table>tbody>tr').clone();
                console.log(itemClone);
                /*赋值*/
                var no = i+1;
                itemClone.find('.no').html(no);
                itemClone.find('.cardNum').html(dyCom.stringFiltedNull(obj.cardNum));
                itemClone.find('.typeName').html(dyCom.stringFiltedNull(obj.typeId));
                var cardPrice = dyCom.numDiv(dyCom.stringFiltedNull(obj.cardPrice), '100');
                itemClone.find('.cardPrice').html(cardPrice + '元');
                var virtualCard = getValue(isVirtualCard, dyCom.stringFiltedNull(obj.isVirtualCard))
                itemClone.find('.isVirtualCard').html(virtualCard);
                itemClone.find('.saleTime').html(dyCom.stringFiltedNull(obj.saleTime));
                itemClone.find('.applyOrganId').html(dyCom.stringFiltedNull(obj.applyOrganId));
                var userInfoHtml = '<span>';
                userInfoHtml += (dyCom.stringFiltedNull(obj.userName))? dyCom.stringFiltedNull(obj.userName)+'-':'';
                userInfoHtml += (dyCom.stringFiltedNull(obj.mobile))? dyCom.stringFiltedNull(obj.mobile)+'-':'';
                var certificateType = getValue(certificateTypeList, dyCom.stringFiltedNull(obj.certificateType))
                userInfoHtml += (certificateType)? certificateType+'-':'';
                userInfoHtml += (dyCom.stringFiltedNull(obj.certificateNumber))? dyCom.stringFiltedNull(obj.certificateNumber):'';
                userInfoHtml += '</span>'

                itemClone.find('.userInfo').html(userInfoHtml);
                itemClone.find('.validDate').html(dyCom.stringFiltedNull(obj.validStartDate) + '--' + dyCom.stringFiltedNull(obj.validEndDate));
                var cardStatus = getValue(cardStatusList, dyCom.stringFiltedNull(obj.cardStatus))
                itemClone.find('.cardStatus').html(cardStatus);
                itemClone.data('cardNum', obj.cardNum);

                /*追加HTML*/
                $("#dataList").append(itemClone);
            });
            // console.log($("#dataList"));
            /*基本信息 点击事件*/
            $('#dataList tr').off('click').on('click',function(){
                var cardNum = $(this).data('cardNum');
                window.location.href = ctx+'/mcards/'+cardNum+'/detail?token='+token;
            })
        }else {
            $("#dataList").html('<tr><td colspan="9"><div class="f-tac">暂无数据</div></td></tr>');
        }
    }
    //状态下拉选择初始化
    function setCardStatusListToSelelct() {
        var optionStatus = {
            domId: "#selectCardStatusList",
            selectName: "卡状态",
            keyName: "value",
            valueName: "id",
            selectedValue: ""
        };
        optionStatus.callback = function(selectObj) {
            console.log(selectObj);
        };
        dyPlugins.selectModel.init(optionStatus, cardStatusList);
    }
    //是否虚拟卡下拉选择初始化
    function setVirtualCardListToSelelct() {
        var optionStatus = {
            domId: "#selectVirtualCardList",
            selectName: "是否是虚拟卡",
            keyName: "value",
            valueName: "id",
            selectedValue: ""
        };
        optionStatus.callback = function(selectObj) {
            console.log(selectObj);
        };
        dyPlugins.selectModel.init(optionStatus, isVirtualCard);
    }
</script>
</body>
</html>