<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>卡管理</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--TODO-->
    <%--<link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />--%>
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul id="optionContiner">
            <%--<li>
                <a id="bind">绑定</a>
            </li>
            <li>
                <a id="modify">修改绑定</a>
            </li>
            <li>
                <a id="unbind">卡解绑</a>
            </li>
            <li>
                <a id="gift">赠送有效期</a>
            </li>
            <li>
                <a id="freeze">冻结/解冻</a>
            </li>--%>
        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconliebiao1"></i>
                  <span class="name-text">卡管理</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <div class="main-block">
            <div class="m-table-detail">
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">卡号</th>
                            <td class="m-table-col-8" id="cardNum"></td>
                            <th class="m-table-col-4">状态</th>
                            <td class="m-table-col-8" id="cardStatus"></td>
                        </tr>
                        <tr>
                            <th>卡类型</th>
                            <td id="typeName"></td>
                            <th>发行机构</th>
                            <td id="applyOrgan"></td>
                        </tr>
                        <tr>
                            <th>虚拟卡</th>
                            <td id="isVirtualCard"></td>
                            <th>制卡时间</th>
                            <td id="createDate"></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>销售</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">面值</th>
                            <td class="m-table-col-8" id="cardPrice"></td>
                            <th class="m-table-col-4">渠道</th>
                            <td class="m-table-col-8" id="applyBoName"></td>
                        </tr>
                        <tr>
                            <th>销售时间</th>
                            <td id="saleTime"></td>
                            <th>网点</th>
                            <td id="applyOrganName"></td>
                        </tr>
                        <tr>
                            <th>销售方式</th>
                            <td id="applyMode"></td>
                            <th>销售员</th>
                            <td id="applyAccountName"></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>绑定</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">姓名</th>
                            <td class="m-table-col-8" id="userName"></td>
                            <th class="m-table-col-4">证件类型</th>
                            <td class="m-table-col-8" id="certificateType"></td>
                        </tr>
                        <tr>
                            <th>手机号</th>
                            <td id="mobile"></td>
                            <th>证件号</th>
                            <td id="certificateNumber"></td>
                        </tr>
                        <tr>
                            <th>激活时间</th>
                            <td id="activateTime"></td>
                            <th></th>
                            <td></td>
                        </tr>
                        <tr>
                            <th>有效期</th>
                            <td id="validDate"></td>
                            <th></th>
                            <td></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>用卡记录</span></header>
                <div class="m-table-list">
                    <section class="content f-mt20">
                        <table>
                            <thead>
                            <tr>
                                <th class="m-table-col-1">No.</th>
                                <th class="m-table-col-2">流水类型</th>
                                <th class="m-table-col-3">流水时间</th>
                                <th class="m-table-col-1">金额</th>
                                <th class="m-table-col-5">商铺</th>
                                <th class="m-table-col-5">商品</th>
                                <th class="m-table-col-1">数量</th>
                                <th class="m-table-col-1">状态</th>
                                <th class="m-table-col-5">备注</th>
                            </tr>
                            </thead>
                            <tbody id="dataList">

                            </tbody>
                        </table>
                    </section>
                    <!--分页开始-->
                    <div id="pagesList" class="f-mt20"></div>
                    <!--分页结束-->
                </div>
            </div>
        </div>
    </section>
    <!--内容区结束-->
</div>

<div id="template" class="main-block f-dn">
    <table>
        <tbody>
        <tr>
            <td>
                <div class="f-tac no">01</div>
            </td>
            <td>
                <div class="f-tal recordType">--</div>
            </td>
            <td>
                <div class="f-tac recordTime">--</div>
            </td>
            <td>
                <div class="f-tac recordAmount">--</div>
            </td>
            <td>
                <div class="f-tac mcName">--</div>
            </td>
            <td>
                <div class="f-tac cmName">--</div>
            </td>
            <td>
                <div class="f-tac consumeNum">--</div>
            </td>
            <td>
                <div class="f-tac status">--</div>
            </td>
            <td>
                <div class="f-tac memo">--</div>
            </td>

        </tr>
        </tbody>
    </table>
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 时间组件-->
<!--js引入私有 分页组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/laypage.js"></script>
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/pages/pc/dist/js/init-page.js"></script>
<%--js引入私有 枚举值信息及公共方法--%>
<script src="${ctx}/static_new_new/js/data/mcardConstant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>

<script>
    //会员卡卡号
    var cardNum = '${cardNum}';
    //role角色：1 发行机构；2 销售机构（代理机构也算作销售机构）
    var role = dyCom.getUrlParams('role');
    //会员卡卡ID
    var cardId = '';
    //分页
    var pageSize = 10; //每页多少条
    var pageIndex = 0; //当前页
    //管理功能列表
    var optionList = [
        {
            num : 0,
            text: '绑定',
            flag: 'bind',
            status: ['1']
        },
        {
            num : 1,
            text: '修改绑定',
            flag: 'modify',
            status: ['2']
        },
        {
            num : 2,
            text: '卡解绑',
            flag: 'unbind',
            status: ['2']
        },
        {
            num : 3,
            text: '赠送有效期',
            flag: 'gift',
            status: ['1', '2', '4']
        },
        {
            num : 4,
            text: '冻结',
            flag: 'freeze',
            status: ["0", "01", "1", "2", "3", "4", "5", "6"]
        }
    ];
    /*1.初始化*/
    $().ready(function(){
        //查询会员卡信息
        getCardInfo();
        //查询用卡记录
        queryCardRecordList();
    });
    /* 2.业务方法  */
    //根据角色和卡的状态显示不同的工具栏操作按钮
    function initOptionBtn(cardStatus, isFrozen) {
        //操作列表
        var optionHtml = '';
        for (var i = 0, len = optionList.length; i < len; i++) {
            //查看会员卡状态是否符合当前的操作，如果符合加入操作列表
            var statusIndex = optionList[i].status.indexOf(cardStatus);
            if (role == '1' && '-1' != statusIndex) {
                optionHtml+= '<li><a id="' + optionList[i].flag + '">' + optionList[i].text + '</a></li>';
            } else if (role == '2' && '-1' != statusIndex && optionList[i].flag != 'gift') {
                //销售机构不能赠送有效期
                optionHtml+= '<li><a id="' + optionList[i].flag + '">' + optionList[i].text + '</a></li>';
            }
        }
        // console.log(optionHtml);
        $('#optionContiner').html(optionHtml);
        //绑定功能事件
        $('#bind').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/bind?cardNum='+cardNum+'&role='+ role;
        });
        //修改绑定功能事件
        $('#modify').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/modify?cardNum='+cardNum+'&role='+ role;
        });
        //解绑卡功能事件
        $('#unbind').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/unbind?cardNum='+cardNum+'&cardId='+cardId+'&role='+ role;
        });
        //赠送有效期事件
        $('#gift').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/giftValidTime?cardNum='+cardNum+'&role='+ role;
        });
        //冻结/解冻事件
        $('#freeze').off('click').on('click', function () {
            window.location.href = ctx+'/mcards/freeze?cardNum='+cardNum+'&role='+ role;
        });
        //维护冻结/解冻按钮的名字
        if ('1' == isFrozen) {
            $('#freeze').text('解冻');
        }
    }
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        // console.log(paramsStr);
        return paramsStr;
    }
    //查询会员卡信息
    function getCardInfo(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards/'+cardNum+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setInfoData(data.result);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充基本信息的数据
    function setInfoData(info) {
        if (info) {
            //遍历实体对象下的属性
            for (var key in info) {
                var tempKey = dyCom.stringFiltedNull(info[key]);
                $('#'+key).html(tempKey);
            }
            //处理枚举值信息
            //状态
            var cardStatus = getValue(cardStatusList, dyCom.stringFiltedNull(info.cardStatus))
            $('#cardStatus').html(cardStatus);
            //虚拟卡
            var virtualCard = getValue(isVirtualCard, dyCom.stringFiltedNull(info.isVirtualCard))
            $('#isVirtualCard').html(virtualCard);
            //面值
            var cardPrice = dyCom.numDiv(dyCom.stringFiltedNull(info.cardPrice), '100');
            $('#cardPrice').html(cardPrice + '元');
            //销售方式
            var applyMode = getValue(applyModeList, dyCom.stringFiltedNull(info.applyMode))
            $('#applyMode').html(applyMode);
            //证件类型
            var certificateType = getValue(certificateTypeList, dyCom.stringFiltedNull(info.certificateType))
            $('#certificateType').html(certificateType);
            //有效期
            $('#validDate').html(dyCom.stringFiltedNull(info.validStartDate) + '--' + dyCom.stringFiltedNull(info.validEndDate));
            //给卡ID赋值
            cardId = info.cardId;
            //根据会员卡状态初始化工具栏按钮
            initOptionBtn(info.cardStatus, info.isFrozen);
        }
    }
    //获取查询用卡记录的参数
    function getRecordParamsSting() {
        var paramsStr = '?';
        var paramsJson = [
            'page='+pageIndex ,
            'size='+pageSize
        ];
        if(token){
            paramsJson.push('token='+token);
        }
        paramsStr += paramsJson.join('&');
        // console.log(paramsStr);
        return paramsStr;
    }
    //查询用卡记录列表
    function queryCardRecordList() {
        var svrParamsString = getRecordParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/userecords/card/' + cardNum + '/userecords'+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setDataList(data.result);

                if (data.totalPage) {
                    //2 分页处理
                    dyPlugins.Page.init("pagesList", data.totalPage, data.currPage, data.pageSize, data.totalRows, function (data) {
                        pageIndex = data.curr;
                        queryCardRecordList();
                    });
                }
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }

    //填充数据
    function setDataList(dataList) {
        if(dataList){
            $("#dataList").html('');
            $.each(dataList, function (i, obj) {
                // console.log(obj);
                /*克隆table 模板*/
                var itemClone = $('#template>table>tbody>tr').clone();
                // console.log(itemClone);
                /*赋值*/
                var no = i+1;
                itemClone.find('.no').html(no);
                var recordType = getValue(recordTypeList, dyCom.stringFiltedNull(obj.recordType))
                itemClone.find('.recordType').html(recordType);
                itemClone.find('.recordTime').html(dyCom.stringFiltedNull(obj.recordTime));
                var recordAmount = dyCom.numDiv(dyCom.stringFiltedNull(obj.recordAmount), '100');
                itemClone.find('.recordAmount').html(recordAmount + '元');
                itemClone.find('.mcName').html(dyCom.stringFiltedNull(obj.mcName));
                itemClone.find('.cmName').html(dyCom.stringFiltedNull(obj.cmName));
                itemClone.find('.consumeNum').html(dyCom.stringFiltedNull(obj.consumeNum));
                var status = getValue(reacordStatusList, obj.status);
                itemClone.find('.status').html(status);
                /*追加HTML*/
                $("#dataList").append(itemClone);
            });
            //如果卡用过，不能进行解绑操作
            if (dataList.length > 0) {
                $('#unbind').parent().remove();
            }
        }else {
            $("#dataList").html('<tr><td colspan="9"><div class="f-tac">暂无数据</div></td></tr>');
        }
    }

</script>
</body>
</html>