<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>卡售后管理-赠送有效期</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--下拉框选择组件-->
    <link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>
            <!--TODO-->
        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont"></i>
                  <span class="name-text">卡售后管理-赠送有效期</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <!--业务模块-->
        <div class="main-block">
            <div class="m-table-detail">
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">卡号</th>
                            <td class="m-table-col-8" id="cardNum"></td>
                            <th class="m-table-col-4">状态</th>
                            <td class="m-table-col-8" id="cardStatus"></td>
                        </tr>
                        <tr>
                            <th>卡类型</th>
                            <td id="typeName"></td>
                            <th>发行机构</th>
                            <td id="applyOrgan"></td>
                        </tr>
                        <tr>
                            <th>虚拟卡</th>
                            <td id="isVirtualCard"></td>
                            <th>制卡时间</th>
                            <td id="createDate"></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>销售</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">面值</th>
                            <td class="m-table-col-8" id="cardPrice"></td>
                            <th class="m-table-col-4">渠道</th>
                            <td class="m-table-col-8" id="applyBoName"></td>
                        </tr>
                        <tr>
                            <th>销售时间</th>
                            <td id="saleTime"></td>
                            <th>网点</th>
                            <td id="applyOrganName"></td>
                        </tr>
                        <tr>
                            <th>销售方式</th>
                            <td id="applyMode"></td>
                            <th>销售员</th>
                            <td id="applyAccountName"></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>绑定</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">姓名</th>
                            <td class="m-table-col-8" id="userName"></td>
                            <th class="m-table-col-4">证件类型</th>
                            <td class="m-table-col-8" id="certificateType"></td>
                        </tr>
                        <tr>
                            <th>手机号</th>
                            <td id="mobile"></td>
                            <th>证件号</th>
                            <td id="certificateNumber"></td>
                        </tr>
                        <tr>
                            <th>激活时间</th>
                            <td id="activateTime"></td>
                            <th></th>
                            <td></td>
                        </tr>
                        <tr>
                            <th>有效期</th>
                            <td id="validDate"></td>
                            <th></th>
                            <td></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>赠送有效期</span></header>
                <div class="m-table-detail m-form-list m-form-nolabel">
                    <section class="content">
                        <table>
                            <tbody>
                            <tr>
                                <th class="m-table-col-4">赠送时长</th>
                                <td class="m-table-col-20 td-edit">
                                    <div class="item-form">
                                        <input id="validDateParam" type="number" class="f-fl" style="width: 100px; line-height: 36px;">
                                        <div id="selectValidUnit" class="f-fl" style="width: 110px; margin-left: 50px;"></div>
                                    </div>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </section>
                </div>
                <div class="u-btn-fixed-placeholder"></div>
                <div class="f-tac u-btn-fixed-b24">
                    <button type="button" class="u-btn u-btn-default step" data-step="2" onclick="history.go(-1)">
                        取消
                    </button>
                    <button id="submit" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
                        提交
                    </button>
                </div>
            </div>
        </div>
        <!--业务模块结束-->
    </section>
    <!--内容区结束-->
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 下拉选择组件-->
<script type="text/javascript" charset="utf-8"  src="${static_plugins}/select/pc/dist/js/select.js?v=1"></script>
<%--js引入私有 枚举值信息及公共方法--%>
<script src="${ctx}/static_new_new/js/data/mcardConstant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>
<!--引入表单验证-->
<script src="${static_js}/validate/validate.js" type="text/javascript" charset="utf-8"></script>

<script>
    //会员卡卡号
    var cardNum = dyCom.getUrlParams('cardNum');
    //role角色：1 发行机构；2 销售机构（代理机构也算作销售机构）
    var role = dyCom.getUrlParams('role');
    /*1.初始化*/
    $().ready(function(){
        //查询会员卡信息
        getCardInfo();

        $('#submit').off('click').on('click', function () {
            giftSubmit();
        });

        //初始化时长单位下拉框
        setValidUnitToSelelct();
    });
    /* 2.业务方法  */
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        // console.log(paramsStr);
        return paramsStr;
    }
    //查询会员卡信息
    function getCardInfo(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards/'+cardNum+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setInfoData(data.result);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充基本信息的数据
    function setInfoData(info) {
        if (info) {
            //遍历实体对象下的属性
            for (var key in info) {
                var tempKey = dyCom.stringFiltedNull(info[key]);
                $('#'+key).html(tempKey);
                $('#'+key).val(tempKey);
            }
            //处理枚举值信息
            //状态
            var cardStatus = getValue(cardStatusList, dyCom.stringFiltedNull(info.cardStatus))
            $('#cardStatus').html(cardStatus);
            //虚拟卡
            var virtualCard = getValue(isVirtualCard, dyCom.stringFiltedNull(info.isVirtualCard))
            $('#isVirtualCard').html(virtualCard);
            //面值
            var cardPrice = dyCom.numDiv(dyCom.stringFiltedNull(info.cardPrice), '100');
            $('#cardPrice').html(cardPrice + '元');
            //销售方式
            var applyMode = getValue(applyModeList, dyCom.stringFiltedNull(info.applyMode))
            $('#applyMode').html(applyMode);
            //证件类型
            var certificateType = getValue(certificateTypeList, dyCom.stringFiltedNull(info.certificateType))
            $('#certificateType').html(certificateType);
            //有效期
            $('#validDate').html(dyCom.stringFiltedNull(info.validStartDate) + '--' + dyCom.stringFiltedNull(info.validEndDate));
            //会员卡ID
            $('#cardNumShow').html(dyCom.stringFiltedNull(info.cardNum));
            //证件类型下拉选择初始化
            setCertificateTypeToSelelct(info.certificateType);
        }
    }

    //证件类型下拉选择初始化
    function setCertificateTypeToSelelct(selectedValue) {
        var optionStatus = {
            domId: "#selectCertificateType",
            selectName: "证件类型",
            keyName: "value",
            valueName: "id",
            selectedValue: selectedValue
        };
        optionStatus.callback = function(selectObj) {
            console.log(selectObj);
        };
        dyPlugins.selectModel.init(optionStatus, certificateTypeList);
    }
    //获取用户参数
    function getUserInfoParam() {
        var paramsStr = {
            cardNum: cardNum
        };
        //证件类型
        var selected = $('#selectValidUnit select').val();
        paramsStr.validUnit = selected;
        paramsStr.validDate = $('#validDateParam').val();
        return paramsStr;
    }
    //绑定提交
    function giftSubmit() {
        //防止多次提交
        var clickFlag = $("#submit").data("click");
        if (!clickFlag) {
            return false;
        }
        //提交之前验证
        $("#submit").data("click", false); //设置不可点击提交按钮
        //提交验证 errTime 返回 0的时候 说明验证都通过 >0 说明 有errTime处有信息问题
        var errTime = dyPlugins.Validate.checkAll();
        console.log(errTime + "错误次数");
        if (errTime > 0) {
            $("#submit").data("click", true); //设置可以点击
        }else{
            var svrParamsString = getUserInfoParam(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
            console.log(svrParamsString);
            //ajax请求配置
            var optionsAjax = {
                url: ctx+'/ajax/post?restPath='+encodeURI('/mcardsvr/mcards/giftValidTime?token='+token)+'&token='+token,  //请求url
                type: "post",         //请求类型 默认get
                async: true,            //异步|同步加载 默认异步
                dataType: "json",      //数据类型      默认json
                data:JSON.stringify({appData:svrParamsString})
            }
            optionsAjax.callback = function(type,data){
                //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
                //返回结果处理
                if(type==1){
                    layer.msg('赠送成功！',function(){
                        window.location.href = ctx+'/mcards/'+cardNum+'/manage?token='+token+'&role='+ role;
                    });
                }else{
                    layer.msg(data);
                }
            }
            dyCom.ajaxRequest(optionsAjax);
        }
    }

    //证件类型下拉选择初始化
    function setValidUnitToSelelct() {
        var optionStatus = {
            domId: "#selectValidUnit",
            selectName: "单位",
            keyName: "value",
            valueName: "id",
            selectedValue: ""
        };
        optionStatus.callback = function(selectObj) {
            console.log(selectObj);
        };
        dyPlugins.selectModel.init(optionStatus, validUnitList);
    }
</script>
</body>
</html>