<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include/include-meta-info.jsp" %>
    <title>会员卡管理-赠卡</title>
    <%@ include file="/WEB-INF/jsp/common/include/include-css.jsp" %>
    <!--弹出窗口所需css-->
    <link href="${static_plugins}/attention/drag/style.css" rel="stylesheet">

    <style>
        .table-label-layout {
            background-color: #ffffff;
            width:35%;
            text-align: right;
            font-size: 15px;
            padding-left: 0;
        }
        .table-value-layout {
            background-color: #ffffff;
            font-size: 15px;
            padding-left: 0;
        }

        /*内容水平居左、垂直居中*/
        .left-vertically{
            justify-content:flex-start;/*水平居左*/
            align-items:center;
            display:-webkit-flex;/*!*垂直居中*!*/
        }

        .padding-0 {
            padding: 0;
        }
    </style>
</head>

<body>
    <div class="container-fluid padding-0">
        <form action="${ctx}/mcards/giftCard/submit" name="cardType" id="cardType" method="post" style="width: 100%;height:100%;" onsubmit="return validate_form(this);">
            <div class="row">
                <div class="col-md-12 left-vertically" style="background-color: #C7D9F1; height: 40px; font-size: 20px;">
                    批量赠卡
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 padding-0" style="background-color: #C7D9F1;">
                   <table class="table table-layout" style="margin-bottom: 0;">
                       <tr>
                           <td class="table-label-layout">卡类型：</td>
                           <td class="table-value-layout">
                               <select id="typeId" name="typeId" style="width: 300px;">
                                    <option value="ff80808166eda476016ad3638cba3ff0">锦绣潇湘天下洞庭法治卡</option>
                               </select>
                           </td>
                       </tr>
                       <tr>
                           <td class="table-label-layout">赠送数量：</td>
                           <td class="table-value-layout">
                               <input id="buyNumber" name="buyNumber" type="text"onkeyup="this.value=this.value.replace(/[^\d]/g,'') " onafterpaste="this.value=this.value.replace(/[^\d]/g,'') " style="width: 80px;">
                               <span style="color: red; padding-left: 10px;">每次赠送不超过100人</span>
                           </td>
                       </tr>
                       <tr>
                           <td class="table-label-layout">赠送人：</td>
                           <td class="table-value-layout">
                               <textarea id="accepts" name="accepts" placeholder="这里录入赠送人的手机号码，以;分隔，不要以;结尾。" style="width: 626px; height: 132px;"
                                         onkeyup="(this.v=function(){this.value=this.value.replace(/[^0-9;]+/,'');}).call(this)"></textarea>
                           </td>
                       </tr>
                   </table>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12" style="text-align: center; background-color: #ffffff; padding-bottom: 20px;">
                    <button type="submit" class="btn btn-primary" style="width: 120px;">确&nbsp;&nbsp;&nbsp;&nbsp;定</button>
                </div>
            </div>
        </form>
    </div>
</body>
<%@ include file="/WEB-INF/jsp/common/include/include-js.jsp" %>
<script type="text/javascript">
    function validate_form(thisform) {

        with (thisform)
        {
            var acceptArray = accepts.value.split(";");
            if (acceptArray == null || acceptArray.length == 0) {
                alert("请录入赠送人的手机号码，以;分隔！");
                accepts.focus();
                return false;
            }
            if (buyNumber.value == null || buyNumber.value == "undefind") {
                alert("请录入赠卡数量！");
                buyNumber.focus();
                return false;
            }
            if (100 < parseInt(buyNumber.value)) {
                alert("每次赠送不超过100人！");
                buyNumber.focus();
                return false;
            }
            if (parseInt(buyNumber.value) != acceptArray.length) {
                alert("请录入与赠卡数量相同的手机号！");
                accepts.focus();
                return false;
            }
            for (var i = 0; i < acceptArray.length; i++) {
                if (!/^\d{11}$/.test(acceptArray[i])) {
                    alert(acceptArray[i]+"不是手机号，请重新录入！");
                    accepts.focus();
                    return false;
                }
            }
            return true;
        }
    }


</script>
</html>
