<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/common/include_new_new/include-taglib.jsp" %>
<%
    String baseResourcePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
%>
<!DOCTYPE html>
<html>
<head>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/include-meta-info.jsp" %>
    <title>卡管理</title>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-css.jsp" %>
    <%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-header-js.jsp"%>
    <%--引入私有css文件--%>
    <!--TODO-->
    <%--<link rel="stylesheet" href="${static_plugins}/select/pc/dist/css/select.css" />--%>
</head>
<body>
<div class="wrapper">
    <!--工具栏开始-->
    <nav class="wrapper-option">
        <ul>

        </ul>
    </nav>
    <!--工具栏结束-->

    <!--标题栏开始-->
    <header class="wrapper-header">
        <div class="header-main">
                <span class="header-name">
                  <i class="iconfont iconliebiao1"></i>
                  <span class="name-text">卡管理</span>
                </span>
            <div class="header-option"></div>
        </div>
    </header>
    <!--标题栏结束-->

    <!--内容区开始-->
    <section class="wrapper-main">
        <div class="main-block">
            <div class="m-table-detail">
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">卡号</th>
                            <td class="m-table-col-8" id="cardNum"></td>
                            <th class="m-table-col-4">状态</th>
                            <td class="m-table-col-8" id="cardStatus"></td>
                        </tr>
                        <tr>
                            <th>卡类型</th>
                            <td id="typeName"></td>
                            <th>发行机构</th>
                            <td id="applyOrgan"></td>
                        </tr>
                        <tr>
                            <th>虚拟卡</th>
                            <td id="isVirtualCard"></td>
                            <th>制卡时间</th>
                            <td id="createDate"></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>销售</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">面值</th>
                            <td class="m-table-col-8" id="cardPrice"></td>
                            <th class="m-table-col-4">渠道</th>
                            <td class="m-table-col-8" id="applyBoName"></td>
                        </tr>
                        <tr>
                            <th>销售时间</th>
                            <td id="saleTime"></td>
                            <th>网点</th>
                            <td id="applyOrganName"></td>
                        </tr>
                        <tr>
                            <th>销售方式</th>
                            <td id="applyMode"></td>
                            <th>销售员</th>
                            <td id="applyAccountName"></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <header class="title"><span>绑定</span></header>
                <section class="content">
                    <table>
                        <tbody>
                        <tr>
                            <th class="m-table-col-4">姓名</th>
                            <td class="m-table-col-8" id="userName"></td>
                            <th class="m-table-col-4">证件类型</th>
                            <td class="m-table-col-8" id="certificateType"></td>
                        </tr>
                        <tr>
                            <th>手机号</th>
                            <td id="mobile"></td>
                            <th>证件号</th>
                            <td id="certificateNumber"></td>
                        </tr>
                        <tr>
                            <th>激活时间</th>
                            <td id="activateTime"></td>
                            <th></th>
                            <td></td>
                        </tr>
                        <tr>
                            <th>有效期</th>
                            <td id="validDate"></td>
                            <th></th>
                            <td></td>
                        </tr>
                        </tbody>
                    </table>
                </section>
                <div class="u-btn-fixed-placeholder"></div>
                <div class="f-tac u-btn-fixed-b24">
                    <button type="button" class="u-btn u-btn-default step" data-step="2" onclick="history.go(-1)">
                        取消
                    </button>
                    <button id="freeze" type="button" class="u-btn u-btn-primary f-ml20" data-click="true">
                        冻结
                    </button>
                </div>
            </div>
        </div>
    </section>
    <!--内容区结束-->
</div>

<div id="template" class="main-block f-dn">
    <table>
        <tbody>
        <tr>
            <td>
                <div class="f-tac no">01</div>
            </td>
            <td>
                <div class="f-tal recordType">--</div>
            </td>
            <td>
                <div class="f-tac recordTime">--</div>
            </td>
            <td>
                <div class="f-tac recordAmount">--</div>
            </td>
            <td>
                <div class="f-tac mcName">--</div>
            </td>
            <td>
                <div class="f-tac cmName">--</div>
            </td>
            <td>
                <div class="f-tac consumeNum">--</div>
            </td>
            <td>
                <div class="f-tac status">--</div>
            </td>
            <td>
                <div class="f-tac memo">--</div>
            </td>

        </tr>
        </tbody>
    </table>
</div>
<!--js公共引入-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-footer-js.jsp"%>
<!--js引入常量-->
<%@ include file="/WEB-INF/jsp/common/include_new_new/pc/include-global-var-script.jsp"%>
<!--js引入私有 时间组件-->
<%--js引入私有 枚举值信息及公共方法--%>
<script src="${ctx}/static_new_new/js/data/mcardConstant.js"></script>
<script src="${ctx}/static_new_new/js/data/common.js"></script>

<script>
    //会员卡卡号
    var cardNum = dyCom.getUrlParams('cardNum');
    //role角色：1 发行机构；2 销售机构（代理机构也算作销售机构）
    var role = dyCom.getUrlParams('role');
    //会员卡卡ID
    var cardId = '';
    //是否冻结
    var isFrozen = '';

    /*1.初始化*/
    $().ready(function(){
        //查询会员卡信息
        getCardInfo();

        //冻结/解冻功能事件
        $('#freeze').off('click').on('click', function () {
            freezeSubmit();
        });

    });
    /* 2.业务方法  */
    /*获取ajax需要的参数*/
    function getSvrParamsSting(){
        var paramsStr = '?';
        if(token){
            paramsStr += 'token='+token;
        }
        // console.log(paramsStr);
        return paramsStr;
    }
    //查询会员卡信息
    function getCardInfo(){
        var svrParamsString = getSvrParamsSting(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        var paramsJson = {
            restPath:encodeURI('/mcardsvr/mcards/'+cardNum+svrParamsString)
        };

        var optionsAjax = {
            url: ctx+'/ajax/get',  //请求url
            type: "get",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:paramsJson
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                //1 数据渲染
                setInfoData(data.result);

            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }
    //填充基本信息的数据
    function setInfoData(info) {
        if (info) {
            //遍历实体对象下的属性
            for (var key in info) {
                var tempKey = dyCom.stringFiltedNull(info[key]);
                $('#'+key).html(tempKey);
            }
            //处理枚举值信息
            //状态
            var cardStatus = getValue(cardStatusList, dyCom.stringFiltedNull(info.cardStatus))
            $('#cardStatus').html(cardStatus);
            //虚拟卡
            var virtualCard = getValue(isVirtualCard, dyCom.stringFiltedNull(info.isVirtualCard))
            $('#isVirtualCard').html(virtualCard);
            //面值
            var cardPrice = dyCom.numDiv(dyCom.stringFiltedNull(info.cardPrice), '100');
            $('#cardPrice').html(cardPrice + '元');
            //销售方式
            var applyMode = getValue(applyModeList, dyCom.stringFiltedNull(info.applyMode))
            $('#applyMode').html(applyMode);
            //证件类型
            var certificateType = getValue(certificateTypeList, dyCom.stringFiltedNull(info.certificateType))
            $('#certificateType').html(certificateType);
            //有效期
            $('#validDate').html(dyCom.stringFiltedNull(info.validStartDate) + '--' + dyCom.stringFiltedNull(info.validEndDate));
            //给卡ID赋值
            cardId = info.cardId;
            //给卡是否冻结赋值
            if (info.isFrozen || '0' == info.isFrozen) {
                isFrozen = info.isFrozen;
            } else {
                isFrozen = '0';
            }
            //根据当前卡的状态改操作的名字
            if ('1' == info.isFrozen) {
                $('#freeze').text('解冻');
            }
        }
    }
    //获取用户参数
    function getUserInfoParam() {
        var paramsStr = {
            cardNum: cardNum,
            cardId: cardId
        };
        if ('0' == isFrozen) {
            paramsStr.isFrozen = '1';
        } else if ('1' == isFrozen) {
            paramsStr.isFrozen = '0';
        }
        return paramsStr;
    }
    //冻结/解冻提交
    function freezeSubmit() {
        var svrParamsString = getUserInfoParam(); //获取svr接口参数 返回时带 最少带token 当前页 每页多少条
        // console.log(svrParamsString);
        //ajax请求配置
        var optionsAjax = {
            url: ctx+'/ajax/post?restPath='+encodeURI('/mcardsvr/mcards/frozen?token='+token)+'&token='+token,  //请求url
            type: "post",         //请求类型 默认get
            async: true,            //异步|同步加载 默认异步
            dataType: "json",      //数据类型      默认json
            data:JSON.stringify({appData:svrParamsString})
        }
        optionsAjax.callback = function(type,data){
            //回调  type=1 成功  type=2数据为空 type=0 请求失败 data 返回数据
            //返回结果处理
            if(type==1){
                layer.msg('操作成功！',function(){
                    window.location.href = ctx+'/mcards/'+cardNum+'/manage?token='+token+'&role='+ role;
                });
            }else{
                layer.msg(data);
            }
        }
        dyCom.ajaxRequest(optionsAjax);
    }


</script>
</body>
</html>