<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<c:set var="static_js" value="${pageContext.request.contextPath}/static/js"/>
<c:set var="static_css" value="${pageContext.request.contextPath}/static/css"/>
<c:set var="static_images" value="${pageContext.request.contextPath}/static/images"/>
<c:set var="dist_bootstrap" value="${pageContext.request.contextPath}/dist/lib/bootstrap/"/>
<c:set var="dist_jquery" value="${pageContext.request.contextPath}/dist/lib/jquery"/>
<c:set var="dist_styles" value="${pageContext.request.contextPath}/dist/styles"/>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>用卡管理-补换卡</title>
    <link href="${static_css}/bootstrap.min.css" rel="stylesheet">
    <link href="${static_css}/common.css" rel="stylesheet">
    <style>
        .nav>li{
            width: 33.3%;
        }
        .nav-tabs {
            padding: 6px;
        }
        .nav-tabs>li>a {
            background-color: #C8DAF1;
            height: 30px;
            line-height: 30px;
        }
        .nav-tabs>li.active>a, .nav-tabs>li.active>a:focus, .nav-tabs>li.active>a:hover {
            color: #ffffff;
            background-color: #0070C1;
            height: 30px;
            line-height: 30px;
        }
        .ztree li span {
            font-size: 12px;
        }
        .ztree li a:hover {
            text-decoration: none;
        }
        .customer-table>thead>tr {
            background-color: #0070C1;
            color: #FFFFFF;

        }
        .customer-table>thead>tr>th {
            width: 25%;
        }
        .customer-table>tbody>tr>td>a {
            text-decoration: none;
            color: #000000;
        }
        .customer-table>tbody>tr>td>a:hover {
            text-decoration: none;
            background-color: #C8DAF1;
        }
        .new-border table>tbody>tr>td {
            border: 1px solid #bbb;
        }
        .data-range table>tbody>tr>td input{
            border: 2px solid #E7E7E7;
        }
    </style>
</head>

<body>
<div class="body-div" id="loading">
    <!-- 工具栏 -->
    <div class="btn-group-menu">
        &nbsp;
    </div>
    <!--内容-->
    <div class="main-content">
        <!--标题开始-->
        <div class="title">
	        	<span>
	        		补换卡
	        	</span>
        </div>
        <!--标题结束-->
        <form action="${ctx}/mcards/change/submit" id="" name="" method="post">
            <div class="container-fluid">
                <div class="col-xs-12 swlDetail">
                    <div class="col-xs-12">
                        <div class="data-range">
                            <table border="" cellspacing="" cellpadding="" style="width: 100%;border: 1px solid #ddd;"><!--纵向table-->
                                <table class="table table-striped table-bordered table-hover table-condensed">
                                    <thead>
                                    <tr>
                                        <th colspan="3">录入卡号信息</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>原始卡号</td>
                                        <td colspan="2">
                                            <input id="cardNum" name="cardNum" type="text" placeholder="请输入原始卡号">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>补卡卡号</td>
                                        <td colspan="2">
                                            <input id="cardNum2" name="cardNum2" type="text" placeholder="请输入补卡卡号">
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </table>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="add-button" style="text-align: center;">
                            <button type="submit" class="btn btn-primary" onclick="queryCardInfo()">查询</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="col-xs-12">
                    <div style="width:45%;float: left;">
                        <div class="data-range">
                            <table class="table table-bordered table-striped table-hover">
                                <tbody >
                                <tr >
                                    <td style="width: 20%;"  colspan="2">原始卡信息</td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >原始卡号：</td>
                                    <td style="width: 30%;"><span id="oldCardNum"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >卡类型：</td>
                                    <td style="width: 30%;"><span id="oldCardType"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >用户名称：</td>
                                    <td style="width: 30%;"><span id="oldAccountName"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >手机号：</td>
                                    <td style="width: 30%;"><span id="oldMobile"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >证件类型：</td>
                                    <td style="width: 30%;"><span id="oldCertificateType"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >证件号码：</td>
                                    <td style="width: 30%;"><span id="oldCertificateNumber"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >激活时间：</td>
                                    <td style="width: 30%;"><span id="oldActivateTime"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >有效期：</td>
                                    <td style="width: 30%;"><span id="oldValidEndDate"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >卡状态：</td>
                                    <td style="width: 30%;"><span id="oldCardStatus"></span></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div style="width:45%;float: right;">
                        <div class="data-range">
                            <table class="table table-bordered table-striped table-hover">
                                <tbody >
                                <tr >
                                    <td style="width: 20%;"  colspan="2">补卡信息</td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >补卡卡号：</td>
                                    <td style="width: 30%;"><span id="newCardNum"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >卡类型：</td>
                                    <td style="width: 30%;"><span id="newCardType"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >用户名称：</td>
                                    <td style="width: 30%;"><span id="newAccountName"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >手机号：</td>
                                    <td style="width: 30%;"><span id="newMobile"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >证件类型：</td>
                                    <td style="width: 30%;"><span id="newCertificateType"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >证件号码：</td>
                                    <td style="width: 30%;"><span id="newCertificateNumber"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >激活时间：</td>
                                    <td style="width: 30%;"><span id="newActivateTime"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >有效期：</td>
                                    <td style="width: 30%;"><span id="newValidEndDate"></span></td>
                                </tr>
                                <tr >
                                    <td style="width: 20%;" >卡状态：</td>
                                    <td style="width: 30%;"><span id="newCardStatus"></span></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="data-range">
                        <table class="table ">
                            <tr>
                                <td>
                                    <button type="submit" class="btn btn-primary">确认补卡</button>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-primary" onclick="">返回</button>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
</body>

<script src="${dist_jquery}/jquery.js" type="text/javascript" charset="utf-8"></script>
<script src="${dist_bootstrap}/bootstrap.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
    //鼠标经过按钮变色
    function currentMenuBtn() {
        $(".menu-btn").mouseover(function(){
            $(this).children().css("background-color","#8EB4E3");
        });
        $(".menu-btn").mouseout(function(){
            $(this).children().css("background-color","#bdbfbe");
        });
    }
    currentMenuBtn();
</script>
<script>
    function queryCardInfo(){
        var cardnum = $("input#cardNum").val();
        var cardnum2 = $("input#cardNum2").val();
        $.ajax({
            url:'${ctx}/mcardmgr/cards/'+cardnum+'/card/get/ajax',//TODO 待定
            dataType: 'text',
            error: errorMsg1,
            success: function(data) {
                var obj = eval("(" + data + ")");
                    if(obj.status == "10000"){
                    $("#oldCardNum").html(obj.result.typeId);
                    $("#oldCardType").html(obj.result.userName);
                    $("#oldAccountName").html(obj.result.mobile);
                    $("#oldMobile").html(obj.result.certificateNumber);
                    $("#oldCertificateType").html(obj.result.activateTime);
                    $("#oldCertificateNumber").html(obj.result.validEndDate);
                    $("#oldActivateTime").html(obj.result.applyOrganId);
                    $("#oldValidEndDate").html(obj.result.applyOrganId);
                    $("#oldCardStatus").html(obj.result.applyOrganId);
                }else {
                    alert(obj.msg);
                }
            }
        });
        $.ajax({
            url:'${ctx}/mcardmgr/cards/'+cardnum+'/card/get/ajax',//TODO 待定
            dataType: 'text',
            error: errorMsg2,
            success: function(data) {
                var obj = eval("(" + data + ")");
                if(obj.status == "10000"){
                    $("#newCardNum").html(obj.result.typeId);
                    $("#newCardType").html(obj.result.userName);
                    $("#newAccountName").html(obj.result.mobile);
                    $("#newMobile").html(obj.result.certificateNumber);
                    $("#newCertificateType").html(obj.result.activateTime);
                    $("#newCertificateNumber").html(obj.result.validEndDate);
                    $("#newActivateTime").html(obj.result.applyOrganId);
                    $("#newValidEndDate").html(obj.result.applyOrganId);
                    $("#newCardStatus").html(obj.result.applyOrganId);
                }else {
                    alert(obj.msg);
                }
            }
        });
        function errorMsg1(XMLHttpRequest){
            alert("ajax请求数据异常,请求状态码为："+XMLHttpRequest.status);
        }
        function errorMsg2(XMLHttpRequest){
            alert("ajax请求数据异常,请求状态码为："+XMLHttpRequest.status);
        }

    }
</script>
</html>
